/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.ApiClock;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.FakeApiClock;
import com.google.api.gax.core.RecordingScheduler;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.FailedPreconditionException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.rpc.UnavailableException;
import com.google.api.gax.rpc.UnknownException;
import com.google.api.gax.rpc.testing.FakeCallContext;
import com.google.api.gax.rpc.testing.FakeCallableFactory;
import com.google.api.gax.rpc.testing.FakeChannel;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.api.gax.rpc.testing.FakeTransportChannel;
import com.google.common.collect.ImmutableSet;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class RetryingTest {
    private UnaryCallable<Integer, Integer> callInt = (UnaryCallable)Mockito.mock(UnaryCallable.class);
    private RecordingScheduler executor;
    private FakeApiClock fakeClock;
    private ClientContext clientContext;
    private static final RetrySettings FAST_RETRY_SETTINGS = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)2L)).setRetryDelayMultiplier(1.0).setMaxRetryDelay(Duration.ofMillis((long)2L)).setInitialRpcTimeout(Duration.ofMillis((long)2L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)2L)).setTotalTimeout(Duration.ofMillis((long)10L)).build();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void resetClock() {
        this.fakeClock = new FakeApiClock(System.nanoTime());
        this.executor = RecordingScheduler.create(this.fakeClock);
        this.clientContext = ClientContext.newBuilder().setExecutor((ScheduledExecutorService)this.executor).setClock((ApiClock)this.fakeClock).setDefaultCallContext((ApiCallContext)FakeCallContext.createDefault()).setTransportChannel((TransportChannel)FakeTransportChannel.create(new FakeChannel())).build();
    }

    @After
    public void teardown() {
        this.executor.shutdownNow();
    }

    static <V> ApiFuture<V> immediateFailedFuture(Throwable t) {
        return ApiFutures.immediateFailedFuture((Throwable)t);
    }

    @Test
    public void retry() {
        UnavailableException throwable = new UnavailableException(null, (StatusCode)FakeStatusCode.of(StatusCode.Code.UNAVAILABLE), true);
        Mockito.when((Object)this.callInt.futureCall((Object)((Integer)Mockito.any()), (ApiCallContext)Mockito.any())).thenReturn(RetryingTest.immediateFailedFuture((Throwable)throwable)).thenReturn(RetryingTest.immediateFailedFuture((Throwable)throwable)).thenReturn(RetryingTest.immediateFailedFuture((Throwable)throwable)).thenReturn((Object)ApiFutures.immediateFuture((Object)2));
        UnaryCallSettings<Integer, Integer> callSettings = RetryingTest.createSettings(FAST_RETRY_SETTINGS);
        UnaryCallable<Integer, Integer> callable = FakeCallableFactory.createUnaryCallable(this.callInt, callSettings, this.clientContext);
        Truth.assertThat((Integer)((Integer)callable.call((Object)1))).isEqualTo((Object)2);
    }

    @Test(expected=ApiException.class)
    public void retryTotalTimeoutExceeded() {
        UnavailableException throwable = new UnavailableException(null, (StatusCode)FakeStatusCode.of(StatusCode.Code.UNAVAILABLE), true);
        Mockito.when((Object)this.callInt.futureCall((Object)((Integer)Mockito.any()), (ApiCallContext)Mockito.any())).thenReturn(RetryingTest.immediateFailedFuture((Throwable)throwable)).thenReturn((Object)ApiFutures.immediateFuture((Object)2));
        RetrySettings retrySettings = FAST_RETRY_SETTINGS.toBuilder().setInitialRetryDelay(Duration.ofMillis((long)Integer.MAX_VALUE)).setMaxRetryDelay(Duration.ofMillis((long)Integer.MAX_VALUE)).build();
        UnaryCallSettings<Integer, Integer> callSettings = RetryingTest.createSettings(retrySettings);
        UnaryCallable<Integer, Integer> callable = FakeCallableFactory.createUnaryCallable(this.callInt, callSettings, this.clientContext);
        callable.call((Object)1);
    }

    @Test(expected=ApiException.class)
    public void retryMaxAttemptsExceeded() {
        UnavailableException throwable = new UnavailableException(null, (StatusCode)FakeStatusCode.of(StatusCode.Code.UNAVAILABLE), true);
        Mockito.when((Object)this.callInt.futureCall((Object)((Integer)Mockito.any()), (ApiCallContext)Mockito.any())).thenReturn(RetryingTest.immediateFailedFuture((Throwable)throwable)).thenReturn(RetryingTest.immediateFailedFuture((Throwable)throwable)).thenReturn((Object)ApiFutures.immediateFuture((Object)2));
        RetrySettings retrySettings = FAST_RETRY_SETTINGS.toBuilder().setMaxAttempts(2).build();
        UnaryCallSettings<Integer, Integer> callSettings = RetryingTest.createSettings(retrySettings);
        UnaryCallable<Integer, Integer> callable = FakeCallableFactory.createUnaryCallable(this.callInt, callSettings, this.clientContext);
        callable.call((Object)1);
    }

    @Test
    public void retryWithinMaxAttempts() {
        UnavailableException throwable = new UnavailableException(null, (StatusCode)FakeStatusCode.of(StatusCode.Code.UNAVAILABLE), true);
        Mockito.when((Object)this.callInt.futureCall((Object)((Integer)Mockito.any()), (ApiCallContext)Mockito.any())).thenReturn(RetryingTest.immediateFailedFuture((Throwable)throwable)).thenReturn(RetryingTest.immediateFailedFuture((Throwable)throwable)).thenReturn((Object)ApiFutures.immediateFuture((Object)2));
        RetrySettings retrySettings = FAST_RETRY_SETTINGS.toBuilder().setMaxAttempts(3).build();
        UnaryCallSettings<Integer, Integer> callSettings = RetryingTest.createSettings(retrySettings);
        UnaryCallable<Integer, Integer> callable = FakeCallableFactory.createUnaryCallable(this.callInt, callSettings, this.clientContext);
        callable.call((Object)1);
        Truth.assertThat((Integer)((Integer)callable.call((Object)1))).isEqualTo((Object)2);
    }

    @Test
    public void retryOnStatusUnknown() {
        UnknownException throwable = new UnknownException(null, (StatusCode)FakeStatusCode.of(StatusCode.Code.UNKNOWN), true);
        Mockito.when((Object)this.callInt.futureCall((Object)((Integer)Mockito.any()), (ApiCallContext)Mockito.any())).thenReturn(RetryingTest.immediateFailedFuture((Throwable)throwable)).thenReturn(RetryingTest.immediateFailedFuture((Throwable)throwable)).thenReturn(RetryingTest.immediateFailedFuture((Throwable)throwable)).thenReturn((Object)ApiFutures.immediateFuture((Object)2));
        UnaryCallSettings<Integer, Integer> callSettings = RetryingTest.createSettings(FAST_RETRY_SETTINGS);
        UnaryCallable<Integer, Integer> callable = FakeCallableFactory.createUnaryCallable(this.callInt, callSettings, this.clientContext);
        Truth.assertThat((Integer)((Integer)callable.call((Object)1))).isEqualTo((Object)2);
    }

    @Test
    public void retryOnUnexpectedException() {
        this.thrown.expect(ApiException.class);
        this.thrown.expectMessage("foobar");
        UnknownException throwable = new UnknownException("foobar", null, (StatusCode)FakeStatusCode.of(StatusCode.Code.UNKNOWN), false);
        Mockito.when((Object)this.callInt.futureCall((Object)((Integer)Mockito.any()), (ApiCallContext)Mockito.any())).thenReturn(RetryingTest.immediateFailedFuture((Throwable)throwable));
        UnaryCallSettings<Integer, Integer> callSettings = RetryingTest.createSettings(FAST_RETRY_SETTINGS);
        UnaryCallable<Integer, Integer> callable = FakeCallableFactory.createUnaryCallable(this.callInt, callSettings, this.clientContext);
        callable.call((Object)1);
    }

    @Test
    public void retryNoRecover() {
        this.thrown.expect(ApiException.class);
        this.thrown.expectMessage("foobar");
        Mockito.when((Object)this.callInt.futureCall((Object)((Integer)Mockito.any()), (ApiCallContext)Mockito.any())).thenReturn(RetryingTest.immediateFailedFuture(new FailedPreconditionException("foobar", null, (StatusCode)FakeStatusCode.of(StatusCode.Code.FAILED_PRECONDITION), false))).thenReturn((Object)ApiFutures.immediateFuture((Object)2));
        UnaryCallSettings<Integer, Integer> callSettings = RetryingTest.createSettings(FAST_RETRY_SETTINGS);
        UnaryCallable<Integer, Integer> callable = FakeCallableFactory.createUnaryCallable(this.callInt, callSettings, this.clientContext);
        callable.call((Object)1);
    }

    @Test
    public void retryKeepFailing() {
        this.thrown.expect(UncheckedExecutionException.class);
        this.thrown.expectMessage("foobar");
        Mockito.when((Object)this.callInt.futureCall((Object)((Integer)Mockito.any()), (ApiCallContext)Mockito.any())).thenReturn(RetryingTest.immediateFailedFuture((Throwable)new UnavailableException("foobar", null, (StatusCode)FakeStatusCode.of(StatusCode.Code.UNAVAILABLE), true)));
        UnaryCallSettings<Integer, Integer> callSettings = RetryingTest.createSettings(FAST_RETRY_SETTINGS);
        UnaryCallable<Integer, Integer> callable = FakeCallableFactory.createUnaryCallable(this.callInt, callSettings, this.clientContext);
        ApiFuture future = callable.futureCall((Object)1);
        Futures.getUnchecked((Future)future);
    }

    @Test
    public void testKnownStatusCode() {
        ImmutableSet retryable = ImmutableSet.of((Object)StatusCode.Code.UNAVAILABLE);
        Mockito.when((Object)this.callInt.futureCall((Object)((Integer)Mockito.any()), (ApiCallContext)Mockito.any())).thenReturn(RetryingTest.immediateFailedFuture(new FailedPreconditionException("known", null, (StatusCode)FakeStatusCode.of(StatusCode.Code.FAILED_PRECONDITION), false)));
        UnaryCallSettings callSettings = UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)retryable).build();
        UnaryCallable<Integer, Integer> callable = FakeCallableFactory.createUnaryCallable(this.callInt, callSettings, this.clientContext);
        try {
            callable.call((Object)1);
        }
        catch (FailedPreconditionException exception) {
            Truth.assertThat((String)exception.getMessage()).isEqualTo((Object)"known");
        }
    }

    @Test
    public void testUnknownStatusCode() {
        this.thrown.expect(RuntimeException.class);
        ImmutableSet retryable = ImmutableSet.of();
        Mockito.when((Object)this.callInt.futureCall((Object)((Integer)Mockito.any()), (ApiCallContext)Mockito.any())).thenReturn(RetryingTest.immediateFailedFuture(new RuntimeException("unknown")));
        UnaryCallSettings callSettings = UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)retryable).build();
        UnaryCallable<Integer, Integer> callable = FakeCallableFactory.createUnaryCallable(this.callInt, callSettings, this.clientContext);
        callable.call((Object)1);
    }

    public static UnaryCallSettings<Integer, Integer> createSettings(RetrySettings retrySettings) {
        return UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE}).setRetrySettings(retrySettings).build();
    }
}

