/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.common.collect.Sets;
import com.google.common.truth.Truth;
import java.util.HashSet;
import java.util.Set;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class PagedCallSettingsTest {
    @Test
    public void testEmptyBuilder() {
        PagedListResponseFactory pagedListResponseFactory = (PagedListResponseFactory)Mockito.mock(PagedListResponseFactory.class);
        PagedCallSettings.Builder builder = PagedCallSettings.newBuilder((PagedListResponseFactory)pagedListResponseFactory);
        Truth.assertThat((Object)builder.getPagedListResponseFactory()).isSameInstanceAs((Object)pagedListResponseFactory);
        Truth.assertThat((Integer)builder.getRetryableCodes().size()).isEqualTo((Object)0);
        Truth.assertThat((Object)builder.getRetrySettings()).isNotNull();
        PagedCallSettings settings = builder.build();
        Truth.assertThat((Object)settings.getPagedListResponseFactory()).isSameInstanceAs((Object)pagedListResponseFactory);
        Truth.assertThat((Integer)settings.getRetryableCodes().size()).isEqualTo((Object)0);
        Truth.assertThat((Object)settings.getRetrySettings()).isNotNull();
    }

    @Test
    public void testBuilder() {
        PagedListResponseFactory pagedListResponseFactory = (PagedListResponseFactory)Mockito.mock(PagedListResponseFactory.class);
        PagedCallSettings.Builder builder = PagedCallSettings.newBuilder((PagedListResponseFactory)pagedListResponseFactory);
        HashSet retryCodes = Sets.newHashSet((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE});
        RetrySettings retrySettings = RetrySettings.newBuilder().build();
        builder.setRetryableCodes((Set)retryCodes);
        builder.setRetrySettings(retrySettings);
        Truth.assertThat((Integer)builder.getRetryableCodes().size()).isEqualTo((Object)1);
        Truth.assertThat((Object)builder.getRetrySettings()).isSameInstanceAs((Object)retrySettings);
        PagedCallSettings settings = builder.build();
        Truth.assertThat((Integer)settings.getRetryableCodes().size()).isEqualTo((Object)1);
        Truth.assertThat((Object)settings.getRetrySettings()).isSameInstanceAs((Object)retrySettings);
    }

    @Test
    public void testBuilderFromSettings() throws Exception {
        PagedListResponseFactory pagedListResponseFactory = (PagedListResponseFactory)Mockito.mock(PagedListResponseFactory.class);
        PagedCallSettings.Builder builder = PagedCallSettings.newBuilder((PagedListResponseFactory)pagedListResponseFactory);
        HashSet retryCodes = Sets.newHashSet((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE});
        RetrySettings retrySettings = RetrySettings.newBuilder().build();
        builder.setRetryableCodes((Set)retryCodes);
        builder.setRetrySettings(retrySettings);
        Truth.assertThat((Integer)builder.getRetryableCodes().size()).isEqualTo((Object)1);
        Truth.assertThat((Object)builder.getRetrySettings()).isSameInstanceAs((Object)retrySettings);
        PagedCallSettings settings = builder.build();
        PagedCallSettings.Builder newBuilder = settings.toBuilder();
        Truth.assertThat((Integer)newBuilder.getRetryableCodes().size()).isEqualTo((Object)1);
        Truth.assertThat((Object)newBuilder.getRetrySettings()).isSameInstanceAs((Object)retrySettings);
    }
}

