/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.StateCheckingResponseObserver;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamController;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import java.util.ArrayList;
import java.util.List;

class AccumulatingStreamObserver
extends StateCheckingResponseObserver<Integer> {
    private List<Integer> values = new ArrayList<Integer>();
    private StreamController controller;
    private Throwable error;
    private boolean completed = false;

    AccumulatingStreamObserver() {
    }

    protected void onStartImpl(StreamController controller) {
        this.controller = controller;
    }

    protected void onResponseImpl(Integer value) {
        this.values.add(value);
    }

    protected void onErrorImpl(Throwable t) {
        this.error = t;
    }

    protected void onCompleteImpl() {
        this.completed = true;
    }

    public List<Integer> getValues() {
        if (!this.completed) {
            throw new IllegalStateException("Stream not completed.");
        }
        if (this.error != null) {
            throw ApiExceptionFactory.createException((Throwable)this.error, (StatusCode)FakeStatusCode.of(StatusCode.Code.UNKNOWN), (boolean)false);
        }
        return this.values;
    }
}

