/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.batching;

import com.google.api.gax.batching.BlockingSemaphore;
import com.google.api.gax.batching.NonBlockingSemaphore;
import com.google.api.gax.batching.Semaphore64;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class Semaphore64Test {
    @Test(expected=IllegalArgumentException.class)
    public void testNegative() {
        BlockingSemaphore semaphore = new BlockingSemaphore(1L);
        semaphore.acquire(-1L);
    }

    @Test
    public void testReturning() {
        NonBlockingSemaphore semaphore = new NonBlockingSemaphore(1L);
        Truth.assertThat((Boolean)semaphore.acquire(1L)).isTrue();
        Truth.assertThat((Boolean)semaphore.acquire(1L)).isFalse();
        semaphore.release(1L);
        Truth.assertThat((Boolean)semaphore.acquire(1L)).isTrue();
    }

    @Test
    public void testBlocking() throws InterruptedException {
        BlockingSemaphore semaphore = new BlockingSemaphore(1L);
        semaphore.acquire(1L);
        Runnable acquireOneRunnable = new Runnable((Semaphore64)semaphore){
            final /* synthetic */ Semaphore64 val$semaphore;
            {
                this.val$semaphore = semaphore64;
            }

            @Override
            public void run() {
                this.val$semaphore.acquire(1L);
            }
        };
        ArrayList<Thread> acquirers = new ArrayList<Thread>();
        for (int i = 0; i < 5; ++i) {
            Thread t = new Thread(acquireOneRunnable);
            acquirers.add(t);
            t.start();
        }
        Thread.sleep(500L);
        for (Thread t : acquirers) {
            Truth.assertThat((Boolean)t.isAlive()).isTrue();
        }
        semaphore.release(3L);
        semaphore.release(3L);
        for (Thread t : acquirers) {
            t.join(500L);
            Truth.assertThat((Boolean)t.isAlive()).isFalse();
        }
    }
}

