/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import com.google.api.core.AbstractApiFuture;
import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.longrunning.OperationSnapshot;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.testing.FakeCallContext;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.NoopApiTracer;
import com.google.api.gax.tracing.SpanName;
import com.google.api.gax.tracing.TracedOperationCallable;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class TracedOperationCallableTest {
    private static final SpanName SPAN_NAME = SpanName.of((String)"FakeClient", (String)"FakeOperation");
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.STRICT_STUBS);
    @Mock
    private ApiTracerFactory tracerFactory;
    private ApiTracer parentTracer;
    @Mock
    private ApiTracer tracer;
    @Mock
    private OperationCallable<String, String, Long> innerCallable;
    private FakeOperationFuture innerResult;
    private TracedOperationCallable<String, String, Long> tracedOperationCallable;
    private FakeCallContext callContext;

    @Before
    public void setUp() {
        this.parentTracer = NoopApiTracer.getInstance();
        Mockito.when((Object)this.tracerFactory.newTracer((ApiTracer)ArgumentMatchers.any(ApiTracer.class), (SpanName)ArgumentMatchers.any(SpanName.class), (ApiTracerFactory.OperationType)ArgumentMatchers.eq((Object)ApiTracerFactory.OperationType.LongRunning))).thenReturn((Object)this.tracer);
        this.innerResult = new FakeOperationFuture();
        Mockito.when((Object)this.innerCallable.futureCall((Object)ArgumentMatchers.anyString(), (ApiCallContext)ArgumentMatchers.any(ApiCallContext.class))).thenReturn((Object)this.innerResult);
        this.tracedOperationCallable = new TracedOperationCallable(this.innerCallable, this.tracerFactory, SPAN_NAME);
        this.callContext = FakeCallContext.createDefault();
    }

    @Test
    public void testTracerCreated() {
        this.tracedOperationCallable.futureCall((Object)"test", (ApiCallContext)this.callContext);
        ((ApiTracerFactory)Mockito.verify((Object)this.tracerFactory, (VerificationMode)Mockito.times((int)1))).newTracer(this.parentTracer, SPAN_NAME, ApiTracerFactory.OperationType.LongRunning);
    }

    @Test
    public void testOperationFinish() {
        this.innerResult.set("successful result");
        this.tracedOperationCallable.futureCall((Object)"test", (ApiCallContext)this.callContext);
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)1))).operationSucceeded();
    }

    @Test
    public void testOperationCancelled() {
        this.innerResult.cancel(true);
        this.tracedOperationCallable.futureCall((Object)"test", (ApiCallContext)this.callContext);
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)1))).operationCancelled();
    }

    @Test
    public void testExternalOperationCancel() {
        Mockito.reset((Object[])new Object[]{this.innerCallable, this.tracerFactory});
        Mockito.when((Object)this.tracerFactory.newTracer((ApiTracer)ArgumentMatchers.any(ApiTracer.class), (SpanName)ArgumentMatchers.any(SpanName.class), (ApiTracerFactory.OperationType)ArgumentMatchers.eq((Object)ApiTracerFactory.OperationType.Unary))).thenReturn((Object)this.tracer);
        SettableApiFuture innerCancelResult = SettableApiFuture.create();
        Mockito.when((Object)this.innerCallable.cancel(ArgumentMatchers.anyString(), (ApiCallContext)ArgumentMatchers.any(ApiCallContext.class))).thenReturn((Object)innerCancelResult);
        this.tracedOperationCallable.cancel("some external operation", (ApiCallContext)this.callContext);
        ((ApiTracerFactory)Mockito.verify((Object)this.tracerFactory, (VerificationMode)Mockito.times((int)1))).newTracer(this.parentTracer, SpanName.of((String)SPAN_NAME.getClientName(), (String)(SPAN_NAME.getMethodName() + ".Cancel")), ApiTracerFactory.OperationType.Unary);
    }

    @Test
    public void testOperationFailed() {
        RuntimeException fakeError = new RuntimeException("fake error");
        this.innerResult.setException(fakeError);
        this.tracedOperationCallable.futureCall((Object)"test", (ApiCallContext)this.callContext);
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)1))).operationFailed((Throwable)fakeError);
    }

    @Test
    public void testSyncError() {
        RuntimeException fakeError = new RuntimeException("fake error");
        Object[] innerCallableWrapper = new OperationCallable[]{this.innerCallable};
        Mockito.reset((Object[])innerCallableWrapper);
        Mockito.when((Object)this.innerCallable.futureCall(ArgumentMatchers.eq((Object)"failing test"), (ApiCallContext)ArgumentMatchers.any(ApiCallContext.class))).thenThrow(new Throwable[]{fakeError});
        try {
            this.tracedOperationCallable.futureCall((Object)"failing test", (ApiCallContext)this.callContext);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        ((ApiTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.times((int)1))).operationFailed((Throwable)fakeError);
    }

    static class FakeOperationFuture
    extends AbstractApiFuture<String>
    implements OperationFuture<String, Long> {
        FakeOperationFuture() {
        }

        public boolean set(String value) {
            return super.set((Object)value);
        }

        public boolean setException(Throwable throwable) {
            return super.setException(throwable);
        }

        public String getName() {
            throw new UnsupportedOperationException("getInitialFuture() not implemented");
        }

        public ApiFuture<OperationSnapshot> getInitialFuture() {
            throw new UnsupportedOperationException("getInitialFuture() not implemented");
        }

        public RetryingFuture<OperationSnapshot> getPollingFuture() {
            throw new UnsupportedOperationException("getPollingFuture() not implemented");
        }

        public ApiFuture<Long> peekMetadata() {
            throw new UnsupportedOperationException("getInitialFuture() not implemented");
        }

        public ApiFuture<Long> getMetadata() {
            throw new UnsupportedOperationException("getInitialFuture() not implemented");
        }
    }
}

