/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import com.google.api.gax.retrying.ServerStreamingAttemptException;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.DeadlineExceededException;
import com.google.api.gax.rpc.NotFoundException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.OpencensusTracer;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.EndSpanOptions;
import io.opencensus.trace.Span;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracer;
import java.util.Map;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class OpencensusTracerTest {
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.STRICT_STUBS);
    @Mock
    private Tracer internalTracer;
    @Mock
    private Span span;
    @Captor
    private ArgumentCaptor<Map<String, AttributeValue>> attributeCaptor;
    private OpencensusTracer tracer;

    @Before
    public void setUp() {
        this.tracer = new OpencensusTracer(this.internalTracer, this.span, ApiTracerFactory.OperationType.Unary);
    }

    @Test
    public void testUnarySuccessExample() {
        this.tracer.attemptStarted(0);
        this.tracer.connectionSelected("1");
        DeadlineExceededException error0 = new DeadlineExceededException("deadline exceeded", null, (StatusCode)new FakeStatusCode(StatusCode.Code.DEADLINE_EXCEEDED), true);
        this.tracer.attemptFailed((Throwable)error0, Duration.ofMillis((long)5L));
        this.tracer.attemptStarted(1);
        this.tracer.connectionSelected("2");
        this.tracer.attemptSucceeded();
        this.tracer.operationSucceeded();
        ((Span)Mockito.verify((Object)this.span)).addAnnotation("Attempt failed, scheduling next attempt", (Map)ImmutableMap.of((Object)"attempt", (Object)AttributeValue.longAttributeValue((long)0L), (Object)"delay ms", (Object)AttributeValue.longAttributeValue((long)5L), (Object)"status", (Object)AttributeValue.stringAttributeValue((String)"DEADLINE_EXCEEDED"), (Object)"status message", (Object)AttributeValue.stringAttributeValue((String)"deadline exceeded"), (Object)"connection", (Object)AttributeValue.stringAttributeValue((String)"1")));
        ((Span)Mockito.verify((Object)this.span)).addAnnotation("Attempt succeeded", (Map)ImmutableMap.of((Object)"attempt", (Object)AttributeValue.longAttributeValue((long)1L), (Object)"connection", (Object)AttributeValue.stringAttributeValue((String)"2")));
        ((Span)Mockito.verify((Object)this.span)).putAttributes((Map)ImmutableMap.of((Object)"attempt count", (Object)AttributeValue.longAttributeValue((long)2L)));
        ((Span)Mockito.verify((Object)this.span)).end();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.span});
    }

    @Test
    public void testBatchExample() {
        this.tracer.batchRequestSent(100L, 1000L);
        this.tracer.attemptStarted(0);
        this.tracer.connectionSelected("1");
        this.tracer.attemptSucceeded();
        this.tracer.operationSucceeded();
        ((Span)Mockito.verify((Object)this.span)).putAttribute("batch count", AttributeValue.longAttributeValue((long)100L));
        ((Span)Mockito.verify((Object)this.span)).putAttribute("batch size", AttributeValue.longAttributeValue((long)1000L));
    }

    @Test
    public void testLongRunningExample() {
        this.tracer = new OpencensusTracer(this.internalTracer, this.span, ApiTracerFactory.OperationType.LongRunning);
        this.tracer.attemptStarted(0);
        this.tracer.attemptFailed(null, Duration.ofMillis((long)5L));
        this.tracer.lroStartSucceeded();
        this.tracer.attemptStarted(1);
        this.tracer.attemptSucceeded();
        this.tracer.operationSucceeded();
        ((Span)Mockito.verify((Object)this.span)).addAnnotation("Scheduling next poll", (Map)ImmutableMap.of((Object)"attempt", (Object)AttributeValue.longAttributeValue((long)0L), (Object)"delay ms", (Object)AttributeValue.longAttributeValue((long)5L), (Object)"status", (Object)AttributeValue.stringAttributeValue((String)"OK")));
        ((Span)Mockito.verify((Object)this.span)).addAnnotation("Operation started", (Map)ImmutableMap.of());
        ((Span)Mockito.verify((Object)this.span)).addAnnotation("Polling completed", (Map)ImmutableMap.of((Object)"attempt", (Object)AttributeValue.longAttributeValue((long)1L)));
        ((Span)Mockito.verify((Object)this.span)).putAttributes((Map)ImmutableMap.of((Object)"attempt count", (Object)AttributeValue.longAttributeValue((long)2L)));
        ((Span)Mockito.verify((Object)this.span)).end();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.span});
    }

    @Test
    public void testRetriesExhaustedExample() {
        this.tracer.attemptStarted(0);
        this.tracer.connectionSelected("1");
        DeadlineExceededException error0 = new DeadlineExceededException("deadline exceeded", null, (StatusCode)new FakeStatusCode(StatusCode.Code.DEADLINE_EXCEEDED), false);
        this.tracer.attemptFailedRetriesExhausted((Throwable)error0);
        this.tracer.operationFailed((Throwable)error0);
        ((Span)Mockito.verify((Object)this.span)).addAnnotation("Attempts exhausted", (Map)ImmutableMap.of((Object)"attempt", (Object)AttributeValue.longAttributeValue((long)0L), (Object)"status", (Object)AttributeValue.stringAttributeValue((String)"DEADLINE_EXCEEDED"), (Object)"status message", (Object)AttributeValue.stringAttributeValue((String)"deadline exceeded"), (Object)"connection", (Object)AttributeValue.stringAttributeValue((String)"1")));
        ((Span)Mockito.verify((Object)this.span)).putAttributes((Map)ImmutableMap.of((Object)"attempt count", (Object)AttributeValue.longAttributeValue((long)1L)));
        ((Span)Mockito.verify((Object)this.span)).end(EndSpanOptions.builder().setStatus(Status.DEADLINE_EXCEEDED.withDescription("deadline exceeded")).build());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.span});
    }

    @Test
    public void testCancellationExample() {
        this.tracer.attemptStarted(0);
        this.tracer.connectionSelected("1");
        this.tracer.attemptCancelled();
        this.tracer.operationCancelled();
        ((Span)Mockito.verify((Object)this.span)).addAnnotation("Attempt cancelled", (Map)ImmutableMap.of((Object)"attempt", (Object)AttributeValue.longAttributeValue((long)0L), (Object)"connection", (Object)AttributeValue.stringAttributeValue((String)"1")));
        ((Span)Mockito.verify((Object)this.span)).putAttributes((Map)ImmutableMap.of((Object)"attempt count", (Object)AttributeValue.longAttributeValue((long)1L)));
        ((Span)Mockito.verify((Object)this.span)).end(EndSpanOptions.builder().setStatus(Status.CANCELLED.withDescription("Cancelled by caller")).build());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.span});
    }

    @Test
    public void testFailureExample() {
        this.tracer.attemptStarted(0);
        this.tracer.connectionSelected("1");
        NotFoundException error0 = new NotFoundException("not found", null, (StatusCode)new FakeStatusCode(StatusCode.Code.NOT_FOUND), false);
        this.tracer.attemptPermanentFailure((Throwable)error0);
        this.tracer.operationFailed((Throwable)error0);
        ((Span)Mockito.verify((Object)this.span)).addAnnotation("Attempt failed, error not retryable", (Map)ImmutableMap.of((Object)"attempt", (Object)AttributeValue.longAttributeValue((long)0L), (Object)"status", (Object)AttributeValue.stringAttributeValue((String)"NOT_FOUND"), (Object)"status message", (Object)AttributeValue.stringAttributeValue((String)"not found"), (Object)"connection", (Object)AttributeValue.stringAttributeValue((String)"1")));
        ((Span)Mockito.verify((Object)this.span)).putAttributes((Map)ImmutableMap.of((Object)"attempt count", (Object)AttributeValue.longAttributeValue((long)1L)));
        ((Span)Mockito.verify((Object)this.span)).end(EndSpanOptions.builder().setStatus(Status.NOT_FOUND.withDescription("not found")).build());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.span});
    }

    @Test
    public void testResponseCount() {
        this.tracer.attemptStarted(0);
        this.tracer.responseReceived();
        this.tracer.responseReceived();
        this.tracer.attemptFailed((Throwable)new RuntimeException(), Duration.ofMillis((long)1L));
        this.tracer.attemptStarted(1);
        this.tracer.responseReceived();
        this.tracer.attemptSucceeded();
        this.tracer.operationSucceeded();
        ((Span)Mockito.verify((Object)this.span)).addAnnotation((String)Mockito.eq((Object)"Attempt failed, scheduling next attempt"), (Map)this.attributeCaptor.capture());
        Truth.assertThat((Map)((Map)this.attributeCaptor.getValue())).containsEntry((Object)"attempt response count", (Object)AttributeValue.longAttributeValue((long)2L));
        ((Span)Mockito.verify((Object)this.span)).addAnnotation((String)Mockito.eq((Object)"Attempt succeeded"), (Map)this.attributeCaptor.capture());
        Truth.assertThat((Map)((Map)this.attributeCaptor.getValue())).containsEntry((Object)"attempt response count", (Object)AttributeValue.longAttributeValue((long)1L));
        ((Span)Mockito.verify((Object)this.span)).putAttributes((Map)this.attributeCaptor.capture());
        Truth.assertThat((Map)((Map)this.attributeCaptor.getValue())).containsEntry((Object)"total response count", (Object)AttributeValue.longAttributeValue((long)3L));
    }

    @Test
    public void testRequestCount() {
        this.tracer.attemptStarted(0);
        this.tracer.requestSent();
        this.tracer.requestSent();
        this.tracer.attemptFailed((Throwable)new RuntimeException(), Duration.ofMillis((long)1L));
        this.tracer.attemptStarted(1);
        this.tracer.requestSent();
        this.tracer.attemptSucceeded();
        this.tracer.operationSucceeded();
        ((Span)Mockito.verify((Object)this.span)).addAnnotation((String)Mockito.eq((Object)"Attempt failed, scheduling next attempt"), (Map)this.attributeCaptor.capture());
        Truth.assertThat((Map)((Map)this.attributeCaptor.getValue())).containsEntry((Object)"attempt request count", (Object)AttributeValue.longAttributeValue((long)2L));
        ((Span)Mockito.verify((Object)this.span)).addAnnotation((String)Mockito.eq((Object)"Attempt succeeded"), (Map)this.attributeCaptor.capture());
        Truth.assertThat((Map)((Map)this.attributeCaptor.getValue())).containsEntry((Object)"attempt request count", (Object)AttributeValue.longAttributeValue((long)1L));
        ((Span)Mockito.verify((Object)this.span)).putAttributes((Map)this.attributeCaptor.capture());
        Truth.assertThat((Map)((Map)this.attributeCaptor.getValue())).containsEntry((Object)"total request count", (Object)AttributeValue.longAttributeValue((long)3L));
    }

    @Test
    public void testAttemptNumber() {
        this.tracer.attemptStarted(0);
        this.tracer.attemptFailed((Throwable)new RuntimeException(), Duration.ofMillis((long)1L));
        this.tracer.attemptStarted(1);
        this.tracer.attemptSucceeded();
        this.tracer.operationSucceeded();
        ((Span)Mockito.verify((Object)this.span)).addAnnotation((String)Mockito.eq((Object)"Attempt failed, scheduling next attempt"), (Map)this.attributeCaptor.capture());
        Truth.assertThat((Map)((Map)this.attributeCaptor.getValue())).containsEntry((Object)"attempt", (Object)AttributeValue.longAttributeValue((long)0L));
        ((Span)Mockito.verify((Object)this.span)).addAnnotation((String)Mockito.eq((Object)"Attempt succeeded"), (Map)this.attributeCaptor.capture());
        Truth.assertThat((Map)((Map)this.attributeCaptor.getValue())).containsEntry((Object)"attempt", (Object)AttributeValue.longAttributeValue((long)1L));
        ((Span)Mockito.verify((Object)this.span)).putAttributes((Map)this.attributeCaptor.capture());
        Truth.assertThat((Map)((Map)this.attributeCaptor.getValue())).containsEntry((Object)"attempt count", (Object)AttributeValue.longAttributeValue((long)2L));
    }

    @Test
    public void testStatusCode() {
        this.tracer.attemptStarted(0);
        this.tracer.attemptFailed((Throwable)new DeadlineExceededException("deadline exceeded", null, (StatusCode)new FakeStatusCode(StatusCode.Code.DEADLINE_EXCEEDED), true), Duration.ofMillis((long)1L));
        this.tracer.attemptStarted(1);
        NotFoundException permanentError = new NotFoundException("not found", null, (StatusCode)new FakeStatusCode(StatusCode.Code.NOT_FOUND), false);
        this.tracer.attemptPermanentFailure((Throwable)permanentError);
        this.tracer.operationFailed((Throwable)permanentError);
        ((Span)Mockito.verify((Object)this.span)).addAnnotation((String)Mockito.eq((Object)"Attempt failed, scheduling next attempt"), (Map)this.attributeCaptor.capture());
        Truth.assertThat((Map)((Map)this.attributeCaptor.getValue())).containsEntry((Object)"status", (Object)AttributeValue.stringAttributeValue((String)"DEADLINE_EXCEEDED"));
        ((Span)Mockito.verify((Object)this.span)).addAnnotation((String)Mockito.eq((Object)"Attempt failed, error not retryable"), (Map)this.attributeCaptor.capture());
        Truth.assertThat((Map)((Map)this.attributeCaptor.getValue())).containsEntry((Object)"status", (Object)AttributeValue.stringAttributeValue((String)"NOT_FOUND"));
    }

    @Test
    public void testErrorConversion() {
        for (StatusCode.Code code : StatusCode.Code.values()) {
            ApiException error = new ApiException("fake message", null, (StatusCode)new FakeStatusCode(code), false);
            Status opencensusStatus = OpencensusTracer.convertErrorToStatus((Throwable)error);
            Truth.assertThat((String)opencensusStatus.getDescription()).isEqualTo((Object)"fake message");
            Truth.assertThat((String)opencensusStatus.getCanonicalCode().toString()).isEqualTo((Object)code.toString());
        }
    }

    @Test
    public void testStreamingErrorConversion() {
        ServerStreamingAttemptException error = new ServerStreamingAttemptException((Throwable)new DeadlineExceededException("timeout", null, (StatusCode)new FakeStatusCode(StatusCode.Code.DEADLINE_EXCEEDED), true), true, true);
        Status opencensusStatus = OpencensusTracer.convertErrorToStatus((Throwable)error);
        Truth.assertThat((String)opencensusStatus.getDescription()).isEqualTo((Object)"timeout");
        Truth.assertThat((Comparable)opencensusStatus.getCanonicalCode()).isEqualTo((Object)Status.CanonicalCode.DEADLINE_EXCEEDED);
    }
}

