/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.ApiFunction;
import com.google.api.gax.longrunning.OperationSnapshot;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class OperationCallSettingsTest {
    @Test
    public void testEmptyBuilder() {
        OperationCallSettings.Builder builder = OperationCallSettings.newBuilder();
        Truth.assertThat((Object)builder.getResponseTransformer()).isNull();
        Truth.assertThat((Object)builder.getMetadataTransformer()).isNull();
        Truth.assertThat((Object)builder.getInitialCallSettings()).isNull();
        Truth.assertThat((Object)builder.getPollingAlgorithm()).isNull();
    }

    @Test
    public void testBuilder() {
        OperationCallSettings.Builder builder = OperationCallSettings.newBuilder();
        UnaryCallSettings initialCallSettings = UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE}).build();
        TimedRetryAlgorithm pollingAlgorithm = (TimedRetryAlgorithm)Mockito.mock(TimedRetryAlgorithm.class);
        ResponseTransformer responseTransformer = new ResponseTransformer();
        MetadataTransformer metadataTransformer = new MetadataTransformer();
        builder.setPollingAlgorithm(pollingAlgorithm);
        builder.setResponseTransformer((ApiFunction)responseTransformer);
        builder.setMetadataTransformer((ApiFunction)metadataTransformer);
        builder.setInitialCallSettings(initialCallSettings);
        Truth.assertThat((Object)builder.getInitialCallSettings()).isSameAs((Object)initialCallSettings);
        OperationCallSettings settings = builder.build();
        Truth.assertThat((Object)settings.getPollingAlgorithm()).isSameAs((Object)pollingAlgorithm);
        Truth.assertThat((Object)settings.getResponseTransformer()).isSameAs((Object)responseTransformer);
        Truth.assertThat((Object)settings.getMetadataTransformer()).isSameAs((Object)metadataTransformer);
        Truth.assertThat((Object)settings.getInitialCallSettings()).isNotNull();
        Truth.assertThat((Integer)settings.getInitialCallSettings().getRetryableCodes().size()).isEqualTo((Object)1);
    }

    @Test
    public void testBuilderFromSettings() throws Exception {
        OperationCallSettings.Builder builder = OperationCallSettings.newBuilder();
        UnaryCallSettings initialCallSettings = UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE}).build();
        TimedRetryAlgorithm pollingAlgorithm = (TimedRetryAlgorithm)Mockito.mock(TimedRetryAlgorithm.class);
        ResponseTransformer responseTransformer = new ResponseTransformer();
        MetadataTransformer metadataTransformer = new MetadataTransformer();
        builder.setPollingAlgorithm(pollingAlgorithm);
        builder.setResponseTransformer((ApiFunction)responseTransformer);
        builder.setMetadataTransformer((ApiFunction)metadataTransformer);
        builder.setInitialCallSettings(initialCallSettings);
        Truth.assertThat((Object)builder.getInitialCallSettings()).isSameAs((Object)initialCallSettings);
        OperationCallSettings settings = builder.build();
        OperationCallSettings.Builder newBuilder = settings.toBuilder();
        Truth.assertThat((Object)newBuilder.getPollingAlgorithm()).isSameAs((Object)pollingAlgorithm);
        Truth.assertThat((Object)newBuilder.getResponseTransformer()).isSameAs((Object)responseTransformer);
        Truth.assertThat((Object)newBuilder.getMetadataTransformer()).isSameAs((Object)metadataTransformer);
        Truth.assertThat((Object)newBuilder.getInitialCallSettings()).isNotNull();
        Truth.assertThat((Integer)newBuilder.getInitialCallSettings().getRetryableCodes().size()).isEqualTo((Object)1);
    }

    private static class MetadataTransformer
    implements ApiFunction<OperationSnapshot, Long> {
        private MetadataTransformer() {
        }

        public Long apply(OperationSnapshot operationSnapshot) {
            return (Long)operationSnapshot.getMetadata();
        }
    }

    private static class ResponseTransformer
    implements ApiFunction<OperationSnapshot, String> {
        private ResponseTransformer() {
        }

        public String apply(OperationSnapshot operationSnapshot) {
            return (String)operationSnapshot.getResponse();
        }
    }
}

