/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.ApiClock;
import com.google.api.gax.rpc.FixedWatchdogProvider;
import com.google.api.gax.rpc.Watchdog;
import com.google.api.gax.rpc.WatchdogProvider;
import com.google.common.truth.Truth;
import java.util.concurrent.ScheduledExecutorService;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class FixedWatchdogProviderTest {
    @Test
    public void testNull() {
        WatchdogProvider provider = FixedWatchdogProvider.create(null);
        Truth.assertThat((Object)provider.getWatchdog()).isNull();
    }

    @Test
    public void testSameInstance() {
        Watchdog watchdog = (Watchdog)Mockito.mock(Watchdog.class);
        WatchdogProvider provider = FixedWatchdogProvider.create((Watchdog)watchdog);
        Truth.assertThat((Object)provider.getWatchdog()).isSameAs((Object)watchdog);
    }

    @Test
    public void testNoModifications() {
        WatchdogProvider provider = FixedWatchdogProvider.create((Watchdog)((Watchdog)Mockito.mock(Watchdog.class)));
        Truth.assertThat((Boolean)provider.needsCheckInterval()).isFalse();
        Truth.assertThat((Boolean)provider.needsClock()).isFalse();
        Truth.assertThat((Boolean)provider.needsExecutor()).isFalse();
        Throwable actualError = null;
        try {
            provider.withCheckInterval(Duration.ofSeconds((long)10L));
        }
        catch (Throwable t) {
            actualError = t;
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(UnsupportedOperationException.class);
        actualError = null;
        try {
            provider.withClock((ApiClock)Mockito.mock(ApiClock.class));
        }
        catch (Throwable t) {
            actualError = t;
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(UnsupportedOperationException.class);
        actualError = null;
        try {
            provider.withExecutor((ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class));
        }
        catch (Throwable t) {
            actualError = t;
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(UnsupportedOperationException.class);
    }
}

