/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.ApiFuture;
import com.google.api.gax.rpc.FirstElementCallable;
import com.google.api.gax.rpc.testing.MockStreamingApi;
import com.google.common.truth.Truth;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FirstElementCallableTest {
    private MockStreamingApi.MockServerStreamingCallable<String, String> upstream;
    private FirstElementCallable<String, String> callable;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setup() {
        this.upstream = new MockStreamingApi.MockServerStreamingCallable();
        this.callable = new FirstElementCallable(this.upstream);
    }

    @Test
    public void testHappyPath() throws InterruptedException, ExecutionException {
        ApiFuture result = this.callable.futureCall((Object)"request");
        MockStreamingApi.MockServerStreamingCall<String, String> call = this.upstream.popLastCall();
        Truth.assertThat((Boolean)call.getController().isAutoFlowControlEnabled()).isFalse();
        Truth.assertThat((Integer)call.getController().popLastPull()).isEqualTo((Object)1);
        call.getController().getObserver().onResponse((Object)"response");
        Truth.assertThat((String)((String)result.get())).isEqualTo((Object)"response");
        Truth.assertThat(call.getController().getObserver()).isNotNull();
    }

    @Test
    public void testEarlyTermination() throws Exception {
        ApiFuture result = this.callable.futureCall((Object)"request");
        MockStreamingApi.MockServerStreamingCall<String, String> call = this.upstream.popLastCall();
        Truth.assertThat((Boolean)call.getController().isAutoFlowControlEnabled()).isFalse();
        Truth.assertThat((Integer)call.getController().popLastPull()).isEqualTo((Object)1);
        result.cancel(true);
        Truth.assertThat((Boolean)call.getController().isCancelled()).isTrue();
        call.getController().getObserver().onError((Throwable)new RuntimeException("Some other upstream cancellation notice"));
        Throwable actualError = null;
        try {
            result.get(1L, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            actualError = e;
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(CancellationException.class);
    }

    @Test
    public void testNoResults() throws Exception {
        ApiFuture result = this.callable.futureCall((Object)"request");
        MockStreamingApi.MockServerStreamingCall<String, String> call = this.upstream.popLastCall();
        Truth.assertThat((Boolean)call.getController().isAutoFlowControlEnabled()).isFalse();
        call.getController().getObserver().onComplete();
        Truth.assertThat((String)((String)result.get())).isNull();
    }

    @Test
    public void testErrorAfterResultIsIgnored() throws Exception {
        ApiFuture result = this.callable.futureCall((Object)"request");
        MockStreamingApi.MockServerStreamingCall<String, String> call = this.upstream.popLastCall();
        Truth.assertThat((Boolean)call.getController().isAutoFlowControlEnabled()).isFalse();
        call.getController().getObserver().onResponse((Object)"response");
        call.getController().getObserver().onError((Throwable)new RuntimeException("some error that will be ignored"));
        Truth.assertThat((String)((String)result.get())).isEqualTo((Object)"response");
    }
}

