/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.ApiClock;
import com.google.api.core.ApiFunction;
import com.google.api.core.NanoClock;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.FixedWatchdogProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.InstantiatingWatchdogProvider;
import com.google.api.gax.rpc.NoHeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.Watchdog;
import com.google.api.gax.rpc.WatchdogProvider;
import com.google.api.gax.rpc.testing.FakeCallContext;
import com.google.api.gax.rpc.testing.FakeClientSettings;
import com.google.auth.Credentials;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class ClientSettingsTest {
    @Test
    public void testEmptyBuilder() throws Exception {
        FakeClientSettings.Builder builder = new FakeClientSettings.Builder();
        Truth.assertThat((Object)builder.getExecutorProvider()).isInstanceOf(InstantiatingExecutorProvider.class);
        Truth.assertThat((Object)builder.getTransportChannelProvider()).isNull();
        Truth.assertThat((Object)builder.getCredentialsProvider()).isInstanceOf(NoCredentialsProvider.class);
        Truth.assertThat((Object)builder.getClock()).isInstanceOf(NanoClock.class);
        Truth.assertThat((Object)builder.getHeaderProvider()).isInstanceOf(NoHeaderProvider.class);
        Truth.assertThat((Object)builder.getInternalHeaderProvider()).isInstanceOf(NoHeaderProvider.class);
        Truth.assertThat((Object)builder.getWatchdogProvider()).isInstanceOf(InstantiatingWatchdogProvider.class);
        Truth.assertThat((Comparable)builder.getWatchdogCheckInterval()).isGreaterThan((Comparable)Duration.ZERO);
        FakeClientSettings settings = builder.build();
        Truth.assertThat((Object)settings.getExecutorProvider()).isSameAs((Object)builder.getExecutorProvider());
        Truth.assertThat((Object)settings.getTransportChannelProvider()).isSameAs((Object)builder.getTransportChannelProvider());
        Truth.assertThat((Object)settings.getCredentialsProvider()).isSameAs((Object)builder.getCredentialsProvider());
        Truth.assertThat((Object)settings.getClock()).isSameAs((Object)builder.getClock());
        Truth.assertThat((Object)settings.getHeaderProvider()).isSameAs((Object)builder.getHeaderProvider());
        Truth.assertThat((Object)settings.getInternalHeaderProvider()).isSameAs((Object)builder.getInternalHeaderProvider());
        Truth.assertThat((Object)settings.getWatchdogProvider()).isInstanceOf(InstantiatingWatchdogProvider.class);
        Truth.assertThat((Comparable)settings.getWatchdogCheckInterval()).isGreaterThan((Comparable)Duration.ZERO);
        String settingsString = settings.toString();
        Truth.assertThat((String)settingsString).contains((CharSequence)"executorProvider");
        Truth.assertThat((String)settingsString).contains((CharSequence)"transportChannelProvider");
        Truth.assertThat((String)settingsString).contains((CharSequence)"credentialsProvider");
        Truth.assertThat((String)settingsString).contains((CharSequence)"clock");
        Truth.assertThat((String)settingsString).contains((CharSequence)"headerProvider");
        Truth.assertThat((String)settingsString).contains((CharSequence)"watchdogProvider");
        Truth.assertThat((String)settingsString).contains((CharSequence)"watchdogCheckInterval");
    }

    @Test
    public void testBuilder() throws Exception {
        FakeClientSettings.Builder builder = new FakeClientSettings.Builder();
        ExecutorProvider executorProvider = (ExecutorProvider)Mockito.mock(ExecutorProvider.class);
        TransportChannelProvider transportProvider = (TransportChannelProvider)Mockito.mock(TransportChannelProvider.class);
        CredentialsProvider credentialsProvider = (CredentialsProvider)Mockito.mock(CredentialsProvider.class);
        ApiClock clock = (ApiClock)Mockito.mock(ApiClock.class);
        HeaderProvider headerProvider = (HeaderProvider)Mockito.mock(HeaderProvider.class);
        HeaderProvider internalHeaderProvider = (HeaderProvider)Mockito.mock(HeaderProvider.class);
        WatchdogProvider watchdogProvider = (WatchdogProvider)Mockito.mock(WatchdogProvider.class);
        Duration watchdogCheckInterval = Duration.ofSeconds((long)13L);
        builder.setExecutorProvider(executorProvider);
        builder.setTransportChannelProvider(transportProvider);
        builder.setCredentialsProvider(credentialsProvider);
        builder.setHeaderProvider(headerProvider);
        builder.setInternalHeaderProvider(internalHeaderProvider);
        builder.setClock(clock);
        builder.setWatchdogProvider(watchdogProvider);
        builder.setWatchdogCheckInterval(watchdogCheckInterval);
        Truth.assertThat((Object)builder.getExecutorProvider()).isSameAs((Object)executorProvider);
        Truth.assertThat((Object)builder.getTransportChannelProvider()).isSameAs((Object)transportProvider);
        Truth.assertThat((Object)builder.getCredentialsProvider()).isSameAs((Object)credentialsProvider);
        Truth.assertThat((Object)builder.getClock()).isSameAs((Object)clock);
        Truth.assertThat((Object)builder.getHeaderProvider()).isSameAs((Object)headerProvider);
        Truth.assertThat((Object)builder.getInternalHeaderProvider()).isSameAs((Object)internalHeaderProvider);
        Truth.assertThat((Object)builder.getWatchdogProvider()).isSameAs((Object)watchdogProvider);
        Truth.assertThat((Comparable)builder.getWatchdogCheckInterval()).isSameAs((Object)watchdogCheckInterval);
        String builderString = builder.toString();
        Truth.assertThat((String)builderString).contains((CharSequence)"executorProvider");
        Truth.assertThat((String)builderString).contains((CharSequence)"transportChannelProvider");
        Truth.assertThat((String)builderString).contains((CharSequence)"credentialsProvider");
        Truth.assertThat((String)builderString).contains((CharSequence)"clock");
        Truth.assertThat((String)builderString).contains((CharSequence)"headerProvider");
        Truth.assertThat((String)builderString).contains((CharSequence)"internalHeaderProvider");
        Truth.assertThat((String)builderString).contains((CharSequence)"watchdogProvider");
        Truth.assertThat((String)builderString).contains((CharSequence)"watchdogCheckInterval");
    }

    @Test
    public void testBuilderFromClientContext() throws Exception {
        ApiClock clock = (ApiClock)Mockito.mock(ApiClock.class);
        FakeCallContext callContext = FakeCallContext.createDefault();
        Map<String, String> headers = Collections.singletonMap("spiffykey", "spiffyvalue");
        Watchdog watchdog = (Watchdog)Mockito.mock(Watchdog.class);
        Duration watchdogCheckInterval = Duration.ofSeconds((long)12L);
        ClientContext clientContext = ClientContext.newBuilder().setExecutor((ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class)).setTransportChannel((TransportChannel)Mockito.mock(TransportChannel.class)).setCredentials((Credentials)Mockito.mock(Credentials.class)).setClock(clock).setDefaultCallContext((ApiCallContext)callContext).setHeaders(headers).setStreamWatchdog(watchdog).setStreamWatchdogCheckInterval(watchdogCheckInterval).build();
        FakeClientSettings.Builder builder = new FakeClientSettings.Builder(clientContext);
        Truth.assertThat((Object)builder.getExecutorProvider()).isInstanceOf(FixedExecutorProvider.class);
        Truth.assertThat((Object)builder.getTransportChannelProvider()).isInstanceOf(FixedTransportChannelProvider.class);
        Truth.assertThat((Object)builder.getCredentialsProvider()).isInstanceOf(FixedCredentialsProvider.class);
        Truth.assertThat((Object)builder.getClock()).isSameAs((Object)clock);
        Truth.assertThat((Map)builder.getHeaderProvider().getHeaders()).containsEntry((Object)"spiffykey", (Object)"spiffyvalue");
        Truth.assertThat((Object)builder.getWatchdogProvider()).isInstanceOf(FixedWatchdogProvider.class);
        Truth.assertThat((Object)builder.getWatchdogProvider().getWatchdog()).isSameAs((Object)watchdog);
        Truth.assertThat((Comparable)builder.getWatchdogCheckInterval()).isEqualTo((Object)watchdogCheckInterval);
    }

    @Test
    public void testBuilderFromSettings() throws Exception {
        FakeClientSettings.Builder builder = new FakeClientSettings.Builder();
        ExecutorProvider executorProvider = (ExecutorProvider)Mockito.mock(ExecutorProvider.class);
        TransportChannelProvider transportProvider = (TransportChannelProvider)Mockito.mock(TransportChannelProvider.class);
        CredentialsProvider credentialsProvider = (CredentialsProvider)Mockito.mock(CredentialsProvider.class);
        ApiClock clock = (ApiClock)Mockito.mock(ApiClock.class);
        HeaderProvider headerProvider = (HeaderProvider)Mockito.mock(HeaderProvider.class);
        HeaderProvider internalHeaderProvider = (HeaderProvider)Mockito.mock(HeaderProvider.class);
        WatchdogProvider watchdogProvider = (WatchdogProvider)Mockito.mock(WatchdogProvider.class);
        Duration watchdogCheckInterval = Duration.ofSeconds((long)14L);
        builder.setExecutorProvider(executorProvider);
        builder.setTransportChannelProvider(transportProvider);
        builder.setCredentialsProvider(credentialsProvider);
        builder.setClock(clock);
        builder.setHeaderProvider(headerProvider);
        builder.setInternalHeaderProvider(internalHeaderProvider);
        builder.setWatchdogProvider(watchdogProvider);
        builder.setWatchdogCheckInterval(watchdogCheckInterval);
        FakeClientSettings settings = builder.build();
        FakeClientSettings.Builder newBuilder = new FakeClientSettings.Builder(settings);
        Truth.assertThat((Object)newBuilder.getExecutorProvider()).isSameAs((Object)executorProvider);
        Truth.assertThat((Object)newBuilder.getTransportChannelProvider()).isSameAs((Object)transportProvider);
        Truth.assertThat((Object)newBuilder.getCredentialsProvider()).isSameAs((Object)credentialsProvider);
        Truth.assertThat((Object)newBuilder.getClock()).isSameAs((Object)clock);
        Truth.assertThat((Object)newBuilder.getHeaderProvider()).isSameAs((Object)headerProvider);
        Truth.assertThat((Object)newBuilder.getInternalHeaderProvider()).isSameAs((Object)internalHeaderProvider);
        Truth.assertThat((Object)newBuilder.getWatchdogProvider()).isSameAs((Object)watchdogProvider);
        Truth.assertThat((Comparable)newBuilder.getWatchdogCheckInterval()).isEqualTo((Object)watchdogCheckInterval);
    }

    @Test
    public void testApplyToAllUnaryMethods() throws Exception {
        ArrayList<UnaryCallSettings.Builder> builders = new ArrayList<UnaryCallSettings.Builder>();
        builders.add(UnaryCallSettings.newUnaryCallSettingsBuilder());
        builders.add(UnaryCallSettings.newUnaryCallSettingsBuilder());
        final int[] count = new int[]{0};
        ClientSettings.Builder.applyToAllUnaryMethods(builders, (ApiFunction)new ApiFunction<UnaryCallSettings.Builder<?, ?>, Void>(){

            public Void apply(UnaryCallSettings.Builder<?, ?> input) {
                if (count[0] == 0) {
                    input.setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE});
                } else {
                    input.setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED});
                }
                count[0] = count[0] + 1;
                return null;
            }
        });
        Truth.assertThat((Iterable)((UnaryCallSettings.Builder)builders.get(0)).getRetryableCodes()).containsExactly(new Object[]{StatusCode.Code.UNAVAILABLE});
        Truth.assertThat((Iterable)((UnaryCallSettings.Builder)builders.get(1)).getRetryableCodes()).containsExactly(new Object[]{StatusCode.Code.DEADLINE_EXCEEDED});
    }
}

