/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.BatchedFuture;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BatchedFutureTest {
    @Test
    public void testSet() throws Exception {
        BatchedFuture future = BatchedFuture.create();
        Truth.assertThat((Boolean)future.isDone()).isFalse();
        future.set((Object)42);
        Truth.assertThat((Integer)((Integer)future.get())).isEqualTo((Object)42);
        Truth.assertThat((Integer)((Integer)future.get(1L, TimeUnit.HOURS))).isEqualTo((Object)42);
        Truth.assertThat((Boolean)future.isDone()).isTrue();
    }

    @Test
    public void testTransform() throws Exception {
        BatchedFuture inputFuture = BatchedFuture.create();
        ApiFuture transformedFuture = ApiFutures.transform((ApiFuture)inputFuture, (ApiFunction)new ApiFunction<Integer, String>(){

            public String apply(Integer input) {
                return input.toString();
            }
        }, (Executor)MoreExecutors.directExecutor());
        inputFuture.set((Object)6);
        Truth.assertThat((String)((String)transformedFuture.get())).isEqualTo((Object)"6");
    }
}

