/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.gax.rpc.Batch;
import com.google.api.gax.rpc.BatchedFuture;
import com.google.api.gax.rpc.BatchingDescriptor;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.rpc.testing.FakeBatchableApi;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class BatchTest {
    @Test
    public void testConstructor() {
        FakeBatchableApi.LabeledIntList request = new FakeBatchableApi.LabeledIntList("lable", 2);
        Batch<FakeBatchableApi.LabeledIntList, List<Integer>> batch = this.createBatch(request);
        Truth.assertThat((Object)batch.getRequest()).isEqualTo((Object)request);
        Truth.assertThat((Object)batch.getCallable()).isSameAs((Object)batch.getCallable());
        Truth.assertThat((Integer)batch.getRequestIssuerList().size()).isEqualTo((Object)1);
        Truth.assertThat((Long)batch.getByteCount()).isEqualTo((Object)2);
    }

    @Test
    public void testMerge() {
        FakeBatchableApi.LabeledIntList request1 = new FakeBatchableApi.LabeledIntList("lable", 1);
        Batch<FakeBatchableApi.LabeledIntList, List<Integer>> batch1 = this.createBatch(request1);
        FakeBatchableApi.LabeledIntList request2 = new FakeBatchableApi.LabeledIntList("lable", 2);
        Batch<FakeBatchableApi.LabeledIntList, List<Integer>> batch2 = this.createBatch(request2);
        batch1.merge(batch2);
        Truth.assertThat((Long)batch1.getByteCount()).isEqualTo((Object)3);
    }

    @Test
    public void testMergeStartEmpty() {
        FakeBatchableApi.LabeledIntList request1 = new FakeBatchableApi.LabeledIntList("lable", new ArrayList<Integer>());
        Batch<FakeBatchableApi.LabeledIntList, List<Integer>> batch1 = this.createBatch(request1, null);
        Truth.assertThat((Object)batch1.getCallable()).isNull();
        FakeBatchableApi.LabeledIntList request2 = new FakeBatchableApi.LabeledIntList("lable", 2);
        Batch<FakeBatchableApi.LabeledIntList, List<Integer>> batch2 = this.createBatch(request2);
        batch1.merge(batch2);
        Truth.assertThat((Long)batch1.getByteCount()).isEqualTo((Object)2);
        Truth.assertThat((Object)batch1.getCallable()).isNotNull();
        Truth.assertThat((Object)batch1.getCallable()).isSameAs((Object)batch2.getCallable());
    }

    @Test
    public void testBatchElementCounter() {
        Batch.BatchElementCounter counter = new Batch.BatchElementCounter((BatchingDescriptor)FakeBatchableApi.SQUARER_BATCHING_DESC);
        FakeBatchableApi.LabeledIntList request = new FakeBatchableApi.LabeledIntList("lable", 3);
        Batch<FakeBatchableApi.LabeledIntList, List<Integer>> batch = this.createBatch(request);
        Truth.assertThat((Long)counter.count(batch)).isEqualTo((Object)1);
    }

    @Test
    public void testBatchByteCounter() {
        Batch.BatchByteCounter counter = new Batch.BatchByteCounter();
        FakeBatchableApi.LabeledIntList request = new FakeBatchableApi.LabeledIntList("lable", 3);
        Batch<FakeBatchableApi.LabeledIntList, List<Integer>> batch = this.createBatch(request);
        Truth.assertThat((Long)counter.count(batch)).isEqualTo((Object)3);
    }

    @Test
    public void testBatchMergerImpl() {
        FakeBatchableApi.LabeledIntList request1 = new FakeBatchableApi.LabeledIntList("lable", 1);
        Batch<FakeBatchableApi.LabeledIntList, List<Integer>> batch1 = this.createBatch(request1);
        FakeBatchableApi.LabeledIntList request2 = new FakeBatchableApi.LabeledIntList("lable", 2);
        Batch<FakeBatchableApi.LabeledIntList, List<Integer>> batch2 = this.createBatch(request2);
        Batch.BatchMergerImpl batchMerger = new Batch.BatchMergerImpl();
        batchMerger.merge(batch1, batch2);
        Truth.assertThat((Long)batch1.getByteCount()).isEqualTo((Object)3);
    }

    private Batch<FakeBatchableApi.LabeledIntList, List<Integer>> createBatch(FakeBatchableApi.LabeledIntList request) {
        UnaryCallable callable = (UnaryCallable)Mockito.mock(UnaryCallable.class);
        return this.createBatch(request, (UnaryCallable<FakeBatchableApi.LabeledIntList, List<Integer>>)callable);
    }

    private Batch<FakeBatchableApi.LabeledIntList, List<Integer>> createBatch(FakeBatchableApi.LabeledIntList request, UnaryCallable<FakeBatchableApi.LabeledIntList, List<Integer>> callable) {
        FakeBatchableApi.SquarerBatchingDescriptor batchingDescriptor = FakeBatchableApi.SQUARER_BATCHING_DESC;
        BatchedFuture batchedFuture = new BatchedFuture();
        return new Batch((BatchingDescriptor)batchingDescriptor, (Object)request, callable, batchedFuture);
    }
}

