/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.batching;

import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;

public class TrackedFlowController
extends FlowController {
    private long elementsReserved = 0L;
    private long elementsReleased = 0L;
    private long bytesReserved = 0L;
    private long bytesReleased = 0L;
    private int callsToReserve = 0;
    private int callsToRelease = 0;

    public TrackedFlowController(FlowControlSettings settings) {
        super(settings);
    }

    public void reserve(long elements, long bytes) throws FlowController.FlowControlException {
        super.reserve(elements, bytes);
        this.elementsReserved += elements;
        this.bytesReserved += bytes;
        ++this.callsToReserve;
    }

    public void release(long elements, long bytes) {
        super.release(elements, bytes);
        this.elementsReleased += elements;
        this.bytesReleased += bytes;
        ++this.callsToRelease;
    }

    public long getElementsReserved() {
        return this.elementsReserved;
    }

    public long getElementsReleased() {
        return this.elementsReleased;
    }

    public long getBytesReserved() {
        return this.bytesReserved;
    }

    public long getBytesReleased() {
        return this.bytesReleased;
    }

    public int getCallsToReserve() {
        return this.callsToReserve;
    }

    public int getCallsToRelease() {
        return this.callsToRelease;
    }
}

