/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.protobuf;

import com.google.api.gax.protobuf.AutoValue_Type_Enum;
import com.google.api.gax.protobuf.AutoValue_Type_Map;
import com.google.api.gax.protobuf.AutoValue_Type_Message;
import com.google.api.gax.protobuf.AutoValue_Type_Primitive;
import com.google.api.gax.protobuf.AutoValue_Type_Repeated;
import com.google.api.gax.protobuf.ProtoReflectionUtil;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;

public abstract class Type {
    public static final Type BOOL = new AutoValue_Type_Primitive(Kind.BOOL);
    public static final Type INT64 = new AutoValue_Type_Primitive(Kind.INT64);
    public static final Type UINT64 = new AutoValue_Type_Primitive(Kind.UINT64);
    public static final Type STRING = new AutoValue_Type_Primitive(Kind.STRING);
    public static final Type BYTES = new AutoValue_Type_Primitive(Kind.BYTES);
    public static final Type DOUBLE = new AutoValue_Type_Primitive(Kind.DOUBLE);

    public static Type forMessage(Descriptors.Descriptor message) {
        return new AutoValue_Type_Message(message);
    }

    public static Type forEnum(Descriptors.EnumDescriptor enumType) {
        return new AutoValue_Type_Enum(enumType);
    }

    public static Type forRepeated(Type elemType) {
        Preconditions.checkArgument((!elemType.isRepeated() && !elemType.isMap() ? 1 : 0) != 0);
        return new AutoValue_Type_Repeated(elemType);
    }

    public static Type forMap(Type keyType, Type valueType) {
        Preconditions.checkArgument((keyType.isPrimitive() && keyType.getKind() != Kind.BYTES && !valueType.isRepeated() && !valueType.isMap() ? 1 : 0) != 0);
        return new AutoValue_Type_Map(keyType, valueType);
    }

    public static Type forField(Descriptors.FieldDescriptor descriptor) {
        if (descriptor.isMapField()) {
            Descriptors.Descriptor message = descriptor.getMessageType();
            return Type.forMap(Type.forField(message.findFieldByNumber(1)), Type.forField(message.findFieldByNumber(2)));
        }
        Type type = Type.internalForField(descriptor);
        if (descriptor.isRepeated()) {
            return Type.forRepeated(type);
        }
        return type;
    }

    public static Type forJavaType(Class<?> type) {
        if (com.google.protobuf.Message.class.isAssignableFrom(type)) {
            Class<?> messageType = type;
            return Type.forMessage(ProtoReflectionUtil.getDefaultInstance(messageType).getDescriptorForType());
        }
        if (type.equals(String.class)) {
            return STRING;
        }
        if (type.equals(Integer.class) || type.equals(Long.class)) {
            return INT64;
        }
        if (type.equals(Boolean.class)) {
            return BOOL;
        }
        if (type.equals(Double.class) || type.equals(Float.class)) {
            return DOUBLE;
        }
        if (type.equals(ByteString.class)) {
            return BYTES;
        }
        throw new IllegalArgumentException("cannot convert to proto type: " + type.getName());
    }

    private static Type internalForField(Descriptors.FieldDescriptor field) {
        switch (field.getType()) {
            case BOOL: {
                return BOOL;
            }
            case SFIXED32: 
            case INT32: 
            case SINT32: 
            case SFIXED64: 
            case INT64: 
            case SINT64: {
                return INT64;
            }
            case FIXED32: 
            case UINT32: 
            case FIXED64: 
            case UINT64: {
                return UINT64;
            }
            case FLOAT: 
            case DOUBLE: {
                return DOUBLE;
            }
            case STRING: {
                return STRING;
            }
            case BYTES: {
                return BYTES;
            }
            case MESSAGE: {
                return Type.forMessage(field.getMessageType());
            }
            case ENUM: {
                return Type.forEnum(field.getEnumType());
            }
        }
        throw new IllegalArgumentException("unknown field type: " + field.getType());
    }

    public abstract Kind getKind();

    public boolean isPrimitive() {
        return this instanceof Primitive;
    }

    public boolean isRepeated() {
        return this.getKind() == Kind.REPEATED;
    }

    public Type getRepeatedElemType() {
        Preconditions.checkArgument((boolean)this.isRepeated());
        return ((Repeated)this).elemType();
    }

    public boolean isMap() {
        return this.getKind() == Kind.MAP;
    }

    public Type getMapKeyType() {
        Preconditions.checkArgument((boolean)this.isMap());
        return ((Map)this).keyType();
    }

    public Type getMapValueType() {
        Preconditions.checkArgument((boolean)this.isMap());
        return ((Map)this).valueType();
    }

    public boolean isMessage() {
        return this.getKind() == Kind.MESSAGE;
    }

    public Descriptors.Descriptor getMessageDescriptor() {
        Preconditions.checkArgument((boolean)this.isMessage());
        return ((Message)this).descriptor();
    }

    public boolean isEnum() {
        return this.getKind() == Kind.ENUM;
    }

    public Descriptors.EnumDescriptor getEnumDescriptor() {
        Preconditions.checkArgument((boolean)this.isEnum());
        return ((Enum)this).descriptor();
    }

    static abstract class Map
    extends Type {
        Map() {
        }

        abstract Type keyType();

        abstract Type valueType();

        @Override
        public Kind getKind() {
            return Kind.MAP;
        }

        public String toString() {
            return String.format("map<%s, %s>", this.keyType(), this.valueType());
        }
    }

    static abstract class Repeated
    extends Type {
        Repeated() {
        }

        abstract Type elemType();

        @Override
        public Kind getKind() {
            return Kind.REPEATED;
        }

        public String toString() {
            return "repeated " + this.elemType().toString();
        }
    }

    static abstract class Enum
    extends Type {
        Enum() {
        }

        abstract Descriptors.EnumDescriptor descriptor();

        @Override
        public Kind getKind() {
            return Kind.ENUM;
        }

        public String toString() {
            return this.descriptor().getFullName();
        }
    }

    static abstract class Message
    extends Type {
        Message() {
        }

        abstract Descriptors.Descriptor descriptor();

        @Override
        public Kind getKind() {
            return Kind.MESSAGE;
        }

        public String toString() {
            return this.descriptor().getFullName();
        }
    }

    static abstract class Primitive
    extends Type {
        Primitive() {
        }

        @Override
        public abstract Kind getKind();

        public String toString() {
            switch (this.getKind()) {
                case INT64: {
                    return "int64";
                }
                case UINT64: {
                    return "uint64";
                }
                case DOUBLE: {
                    return "double";
                }
                case BOOL: {
                    return "bool";
                }
                case STRING: {
                    return "string";
                }
                case BYTES: {
                    return "bytes";
                }
            }
            return this.getKind().toString();
        }
    }

    public static enum Kind {
        INT64,
        UINT64,
        DOUBLE,
        BOOL,
        STRING,
        BYTES,
        MESSAGE,
        ENUM,
        REPEATED,
        MAP;

    }
}

