/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.core;

import com.google.api.gax.core.ApiService;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.AbstractService;
import com.google.common.util.concurrent.Service;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class AbstractApiService
implements ApiService {
    private static final ImmutableMap<Service.State, ApiService.State> guavaToGaxState = ImmutableMap.builder().put((Object)Service.State.FAILED, (Object)ApiService.State.FAILED).put((Object)Service.State.NEW, (Object)ApiService.State.NEW).put((Object)Service.State.RUNNING, (Object)ApiService.State.RUNNING).put((Object)Service.State.STARTING, (Object)ApiService.State.STARTING).put((Object)Service.State.STOPPING, (Object)ApiService.State.STOPPING).put((Object)Service.State.TERMINATED, (Object)ApiService.State.TERMINATED).build();
    private final InnerService impl = new InnerService();

    protected AbstractApiService() {
    }

    protected abstract void doStart();

    protected abstract void doStop();

    @Override
    public void addListener(final ApiService.Listener listener, Executor executor) {
        this.impl.addListener(new Service.Listener(){

            public void failed(Service.State from, Throwable failure) {
                listener.failed((ApiService.State)((Object)guavaToGaxState.get((Object)from)), failure);
            }

            public void running() {
                listener.running();
            }

            public void starting() {
                listener.starting();
            }

            public void stopping(Service.State from) {
                listener.stopping((ApiService.State)((Object)guavaToGaxState.get((Object)from)));
            }

            public void terminated(Service.State from) {
                listener.terminated((ApiService.State)((Object)guavaToGaxState.get((Object)from)));
            }
        }, executor);
    }

    @Override
    public void awaitRunning() {
        this.impl.awaitRunning();
    }

    @Override
    public void awaitRunning(long timeout, TimeUnit unit) throws TimeoutException {
        this.impl.awaitRunning(timeout, unit);
    }

    @Override
    public void awaitTerminated() {
        this.impl.awaitTerminated();
    }

    @Override
    public void awaitTerminated(long timeout, TimeUnit unit) throws TimeoutException {
        this.impl.awaitTerminated(timeout, unit);
    }

    @Override
    public Throwable failureCause() {
        return this.impl.failureCause();
    }

    @Override
    public boolean isRunning() {
        return this.impl.isRunning();
    }

    @Override
    public ApiService startAsync() {
        this.impl.startAsync();
        return this;
    }

    @Override
    public ApiService.State state() {
        return (ApiService.State)((Object)guavaToGaxState.get((Object)this.impl.state()));
    }

    @Override
    public ApiService stopAsync() {
        this.impl.stopAsync();
        return this;
    }

    protected void notifyStarted() {
        this.impl.innerNotifyStarted();
    }

    protected void notifyStopped() {
        this.impl.innerNotifyStopped();
    }

    protected void notifyFailed(Throwable cause) {
        this.impl.innerNotifyFailed(cause);
    }

    private class InnerService
    extends AbstractService {
        private InnerService() {
        }

        protected void doStart() {
            AbstractApiService.this.doStart();
        }

        protected void doStop() {
            AbstractApiService.this.doStop();
        }

        private void innerNotifyStarted() {
            this.notifyStarted();
        }

        private void innerNotifyStopped() {
            this.notifyStopped();
        }

        private void innerNotifyFailed(Throwable cause) {
            this.notifyFailed(cause);
        }
    }
}

