/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ExecutorProvider;
import io.grpc.ManagedChannel;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

public class ProviderManager
implements ExecutorProvider,
ChannelProvider {
    private final ExecutorProvider executorProvider;
    private final ChannelProvider channelProvider;
    private ManagedChannel channel;
    private ScheduledExecutorService executor;
    private Object lock = new Object();

    private ProviderManager(ExecutorProvider executorProvider, ChannelProvider channelProvider) {
        this.executorProvider = executorProvider;
        this.channelProvider = channelProvider;
    }

    @Override
    public boolean shouldAutoClose() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledExecutorService getExecutor() {
        Object object = this.lock;
        synchronized (object) {
            if (this.executor == null) {
                this.executor = this.executorProvider.getExecutor();
            }
        }
        return this.executor;
    }

    @Override
    public boolean needsExecutor() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagedChannel getChannel() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.channel == null) {
                this.channel = this.channelProvider.needsExecutor() ? this.channelProvider.getChannel(this.getExecutor()) : this.channelProvider.getChannel();
            }
        }
        return this.channel;
    }

    @Override
    public ManagedChannel getChannel(Executor executor) {
        throw new IllegalStateException("getChannel(Executor) called when needsExecutor() is false");
    }

    public void shutdown() {
        if (this.channel != null && this.channelProvider.shouldAutoClose()) {
            this.channel.shutdown();
        }
        if (this.executor != null && this.executorProvider.shouldAutoClose()) {
            this.executor.shutdown();
        }
    }

    public void shutdownNow() {
        if (this.channel != null && this.channelProvider.shouldAutoClose()) {
            this.channel.shutdownNow();
        }
        if (this.executor != null && this.executorProvider.shouldAutoClose()) {
            this.executor.shutdownNow();
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private ExecutorProvider executorProvider;
        private ChannelProvider channelProvider;

        private Builder() {
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            this.executorProvider = executorProvider;
            return this;
        }

        public Builder setChannelProvider(ChannelProvider channelProvider) {
            this.channelProvider = channelProvider;
            return this;
        }

        public ProviderManager build() {
            return new ProviderManager(this.executorProvider, this.channelProvider);
        }
    }
}

