/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.bundling.ThresholdBundleReceiver;
import com.google.api.gax.grpc.Bundle;
import com.google.api.gax.grpc.BundledRequestIssuer;
import com.google.api.gax.grpc.BundlingDescriptor;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.common.base.Preconditions;
import java.util.List;

class BundleExecutor<RequestT, ResponseT>
implements ThresholdBundleReceiver<Bundle<RequestT, ResponseT>> {
    private final BundlingDescriptor<RequestT, ResponseT> bundlingDescriptor;
    private final String partitionKey;

    public BundleExecutor(BundlingDescriptor<RequestT, ResponseT> bundlingDescriptor, String partitionKey) {
        this.bundlingDescriptor = (BundlingDescriptor)Preconditions.checkNotNull(bundlingDescriptor);
        this.partitionKey = (String)Preconditions.checkNotNull((Object)partitionKey);
    }

    @Override
    public void validateBundle(Bundle<RequestT, ResponseT> item) {
        String itemPartitionKey = this.bundlingDescriptor.getBundlePartitionKey(item.getRequest());
        if (!itemPartitionKey.equals(this.partitionKey)) {
            String requestClassName = item.getRequest().getClass().getSimpleName();
            throw new IllegalArgumentException(String.format("For type %s, invalid partition key: %s, should be: %s", requestClassName, itemPartitionKey, this.partitionKey));
        }
    }

    @Override
    public void processBundle(Bundle<RequestT, ResponseT> bundle) {
        UnaryCallable<RequestT, ResponseT> callable = bundle.getCallable();
        RequestT request = bundle.getRequest();
        List<BundledRequestIssuer<ResponseT>> requestIssuerList = bundle.getRequestIssuerList();
        try {
            ResponseT bundleResponse = callable.call(request);
            this.bundlingDescriptor.splitResponse(bundleResponse, requestIssuerList);
        }
        catch (Throwable exception) {
            this.bundlingDescriptor.splitException(exception, requestIssuerList);
        }
        for (BundledRequestIssuer<ResponseT> requestIssuer : requestIssuerList) {
            requestIssuer.sendResult();
        }
    }
}

