/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.bundling;

import com.google.api.gax.bundling.BundleMerger;
import com.google.api.gax.bundling.BundlingFlowController;
import com.google.api.gax.bundling.BundlingThreshold;
import com.google.api.gax.core.FlowController;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.joda.time.Duration;

public final class ThresholdBundler<E> {
    private ImmutableList<BundlingThreshold<E>> thresholdPrototypes;
    private final Duration maxDelay;
    private final BundlingFlowController<E> flowController;
    private final BundleMerger<E> bundleMerger;
    private final Lock lock = new ReentrantLock();
    private final Condition bundleCondition = this.lock.newCondition();
    private BundleState currentBundleState;
    private Queue<E> closedBundles = new ArrayDeque();

    private ThresholdBundler(ImmutableList<BundlingThreshold<E>> thresholds, Duration maxDelay, BundlingFlowController<E> flowController, BundleMerger<E> bundleMerger) {
        this.thresholdPrototypes = ThresholdBundler.copyResetThresholds((ImmutableList)Preconditions.checkNotNull(thresholds));
        this.maxDelay = maxDelay;
        this.flowController = (BundlingFlowController)Preconditions.checkNotNull(flowController);
        this.bundleMerger = (BundleMerger)Preconditions.checkNotNull(bundleMerger);
        this.currentBundleState = null;
    }

    public static <T> Builder<T> newBuilder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(E e) throws FlowController.FlowControlException {
        Lock lock = this.lock;
        this.flowController.reserve(e);
        lock.lock();
        try {
            boolean signalBundleIsReady = false;
            if (this.currentBundleState == null) {
                this.currentBundleState = new BundleState(this.thresholdPrototypes, this.maxDelay);
                this.currentBundleState.start();
                signalBundleIsReady = true;
            }
            this.currentBundleState.add(e);
            if (this.currentBundleState.isAnyThresholdReached()) {
                signalBundleIsReady = true;
                this.closedBundles.add(this.currentBundleState.getBundle());
                this.currentBundleState = null;
            }
            if (signalBundleIsReady) {
                this.bundleCondition.signalAll();
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void flush() {
        Lock lock = this.lock;
        lock.lock();
        try {
            if (this.currentBundleState != null) {
                this.closedBundles.add(this.currentBundleState.getBundle());
                this.currentBundleState = null;
            }
            this.bundleCondition.signalAll();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E removeBundle() {
        Lock lock = this.lock;
        lock.lock();
        try {
            Object outBundle = null;
            if (this.closedBundles.size() > 0) {
                outBundle = this.closedBundles.remove();
            } else if (this.currentBundleState != null) {
                outBundle = this.currentBundleState.getBundle();
                this.currentBundleState = null;
            }
            if (outBundle != null) {
                this.flowController.release(outBundle);
                Object object = outBundle;
                return (E)object;
            }
            E e = null;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    public E takeBundle() throws InterruptedException {
        Lock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.shouldWait()) {
                if (this.currentBundleState == null || this.maxDelay == null) {
                    this.bundleCondition.await();
                    continue;
                }
                this.bundleCondition.await(this.currentBundleState.getDelayLeft().getMillis(), TimeUnit.MILLISECONDS);
            }
            E e = this.removeBundle();
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isEmpty() {
        Lock lock = this.lock;
        lock.lock();
        try {
            if (this.closedBundles.size() > 0) {
                boolean bl = false;
                return bl;
            }
            if (this.currentBundleState != null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    private boolean shouldWait() {
        if (this.closedBundles.size() > 0) {
            return false;
        }
        if (this.currentBundleState == null) {
            return true;
        }
        if (this.maxDelay == null) {
            return true;
        }
        return this.currentBundleState.getDelayLeft().getMillis() > 0L;
    }

    private static <E> ImmutableList<BundlingThreshold<E>> copyResetThresholds(ImmutableList<BundlingThreshold<E>> thresholds) {
        ImmutableList.Builder resetThresholds = ImmutableList.builder();
        for (BundlingThreshold threshold : thresholds) {
            resetThresholds.add(threshold.copyWithZeroedValue());
        }
        return resetThresholds.build();
    }

    private class BundleState {
        private final ImmutableList<BundlingThreshold<E>> thresholds;
        private final Duration maxDelay;
        private E bundle;
        private Stopwatch stopwatch;

        private BundleState(ImmutableList<BundlingThreshold<E>> thresholds, Duration maxDelay) {
            this.thresholds = ThresholdBundler.copyResetThresholds(thresholds);
            this.maxDelay = maxDelay;
        }

        private void start() {
            this.stopwatch = Stopwatch.createStarted();
        }

        private void add(E newBundle) {
            if (this.bundle == null) {
                this.bundle = newBundle;
            } else {
                ThresholdBundler.this.bundleMerger.merge(this.bundle, newBundle);
            }
            for (BundlingThreshold threshold : this.thresholds) {
                threshold.accumulate(newBundle);
            }
        }

        private E getBundle() {
            return this.bundle;
        }

        private Duration getDelayLeft() {
            return Duration.millis((long)(this.maxDelay.getMillis() - this.stopwatch.elapsed(TimeUnit.MILLISECONDS)));
        }

        private boolean isAnyThresholdReached() {
            for (BundlingThreshold threshold : this.thresholds) {
                if (!threshold.isThresholdReached()) continue;
                return true;
            }
            return false;
        }
    }

    public static final class Builder<E> {
        private List<BundlingThreshold<E>> thresholds = Lists.newArrayList();
        private Duration maxDelay;
        private BundlingFlowController<E> flowController;
        private BundleMerger<E> bundleMerger;

        private Builder() {
        }

        public Builder<E> setMaxDelay(Duration maxDelay) {
            this.maxDelay = maxDelay;
            return this;
        }

        public Builder<E> setThresholds(List<BundlingThreshold<E>> thresholds) {
            this.thresholds = thresholds;
            return this;
        }

        public Builder<E> addThreshold(BundlingThreshold<E> threshold) {
            this.thresholds.add(threshold);
            return this;
        }

        public Builder<E> setFlowController(BundlingFlowController<E> flowController) {
            this.flowController = flowController;
            return this;
        }

        public Builder<E> setBundleMerger(BundleMerger<E> bundleMerger) {
            this.bundleMerger = bundleMerger;
            return this;
        }

        public ThresholdBundler<E> build() {
            return new ThresholdBundler(ImmutableList.copyOf(this.thresholds), this.maxDelay, this.flowController, this.bundleMerger);
        }
    }
}

