/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.stats;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicLong;

public class Distribution {
    private final AtomicLong[] bucketCounts;
    private long count;
    private double mean;
    private double sumOfSquaredDeviation;

    public Distribution(int totalBuckets) {
        Preconditions.checkArgument((totalBuckets > 0 ? 1 : 0) != 0);
        this.bucketCounts = new AtomicLong[totalBuckets];
        for (int i = 0; i < totalBuckets; ++i) {
            this.bucketCounts[i] = new AtomicLong();
        }
    }

    public long getNthPercentile(double percentile) {
        Preconditions.checkArgument((percentile > 0.0 ? 1 : 0) != 0);
        Preconditions.checkArgument((percentile <= 100.0 ? 1 : 0) != 0);
        long[] bucketCounts = this.getBucketCounts();
        long total = 0L;
        for (long count : bucketCounts) {
            total += count;
        }
        if (total == 0L) {
            return 0L;
        }
        long count = (long)Math.ceil((double)total * percentile / 100.0);
        for (int i = 0; i < bucketCounts.length; ++i) {
            if ((count -= bucketCounts[i]) > 0L) continue;
            return i;
        }
        return 0L;
    }

    public synchronized void reset() {
        for (AtomicLong element : this.bucketCounts) {
            element.set(0L);
        }
        this.count = 0L;
        this.mean = 0.0;
        this.sumOfSquaredDeviation = 0.0;
    }

    public long getCount() {
        return this.count;
    }

    public double getSumOfSquareDeviations() {
        return this.sumOfSquaredDeviation;
    }

    public double getMean() {
        return this.mean;
    }

    public long[] getBucketCounts() {
        long[] counts = new long[this.bucketCounts.length];
        for (int i = 0; i < counts.length; ++i) {
            counts[i] = this.bucketCounts[i].longValue();
        }
        return counts;
    }

    public synchronized Distribution copy() {
        Distribution distributionCopy = new Distribution(this.bucketCounts.length);
        distributionCopy.count = this.count;
        distributionCopy.mean = this.mean;
        distributionCopy.sumOfSquaredDeviation = this.sumOfSquaredDeviation;
        for (int i = 0; i < this.bucketCounts.length; ++i) {
            distributionCopy.bucketCounts[i].set(this.bucketCounts[i].get());
        }
        return distributionCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(int bucket) {
        Preconditions.checkArgument((bucket >= 0 ? 1 : 0) != 0);
        Distribution distribution = this;
        synchronized (distribution) {
            ++this.count;
            double dev = (double)bucket - this.mean;
            this.mean += dev / (double)this.count;
            this.sumOfSquaredDeviation += dev * ((double)bucket - this.mean);
        }
        if (bucket >= this.bucketCounts.length) {
            this.bucketCounts[this.bucketCounts.length - 1].incrementAndGet();
            return;
        }
        this.bucketCounts[bucket].incrementAndGet();
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(Distribution.class);
        helper.add("bucketCounts", (Object)this.bucketCounts);
        helper.add("count", this.count);
        helper.add("mean", this.mean);
        helper.add("sumOfSquaredDeviation", this.sumOfSquaredDeviation);
        return helper.toString();
    }
}

