/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.core.RpcFuture;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.FutureCallable;
import com.google.api.gax.grpc.ListenableFutureDelegate;
import com.google.api.gax.grpc.PagedListResponseFactory;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;

class PagedCallable<RequestT, ResponseT, PagedListResponseT>
implements FutureCallable<RequestT, PagedListResponseT> {
    private final FutureCallable<RequestT, ResponseT> callable;
    private final PagedListResponseFactory<RequestT, ResponseT, PagedListResponseT> pagedListResponseFactory;

    PagedCallable(FutureCallable<RequestT, ResponseT> callable, PagedListResponseFactory<RequestT, ResponseT, PagedListResponseT> pagedListResponseFactory) {
        this.callable = (FutureCallable)Preconditions.checkNotNull(callable);
        this.pagedListResponseFactory = pagedListResponseFactory;
    }

    public String toString() {
        return String.format("paged(%s)", this.callable);
    }

    @Override
    public RpcFuture<PagedListResponseT> futureCall(RequestT request, CallContext context) {
        PagedListResponseT pagedListResponse = this.pagedListResponseFactory.createPagedListResponse(UnaryCallable.create(this.callable), request, context);
        return new ListenableFutureDelegate(Futures.immediateFuture(pagedListResponse));
    }
}

