/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.core;

import com.google.api.gax.core.Function;
import com.google.api.gax.core.RpcFuture;
import com.google.api.gax.core.RpcFutureCallback;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class SettableRpcFuture<V>
implements RpcFuture<V> {
    private final SettableFuture<V> impl = SettableFuture.create();

    @Override
    public void addListener(Runnable listener, Executor executor) {
        this.impl.addListener(listener, executor);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.impl.cancel(mayInterruptIfRunning);
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return (V)this.impl.get();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (V)this.impl.get(timeout, unit);
    }

    @Override
    public boolean isCancelled() {
        return this.impl.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.impl.isDone();
    }

    public boolean set(V value) {
        return this.impl.set(value);
    }

    public boolean setException(Throwable throwable) {
        return this.impl.setException(throwable);
    }

    @Override
    public void addCallback(final RpcFutureCallback<? super V> callback) {
        Futures.addCallback(this.impl, (FutureCallback)new FutureCallback<V>(){

            public void onFailure(Throwable t) {
                callback.onFailure(t);
            }

            public void onSuccess(V v) {
                callback.onSuccess(v);
            }
        });
    }

    @Override
    public <X extends Throwable> RpcFuture catching(Class<X> exceptionType, final Function<? super X, ? extends V> callback) {
        SettableRpcFuture<V> future = new SettableRpcFuture<V>();
        future.impl.setFuture(Futures.catching(this.impl, exceptionType, (com.google.common.base.Function)new com.google.common.base.Function<X, V>(){

            public V apply(X input) {
                return callback.apply(input);
            }
        }));
        return future;
    }
}

