
package com.google.api.gax.grpc;

import javax.annotation.Generated;
import org.joda.time.Duration;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_BundlingSettings extends BundlingSettings {

  private final Integer elementCountThreshold;
  private final Integer elementCountLimit;
  private final Integer requestByteThreshold;
  private final Integer requestByteLimit;
  private final Duration delayThreshold;
  private final Integer blockingCallCountThreshold;

  private AutoValue_BundlingSettings(
      @javax.annotation.Nullable Integer elementCountThreshold,
      @javax.annotation.Nullable Integer elementCountLimit,
      @javax.annotation.Nullable Integer requestByteThreshold,
      @javax.annotation.Nullable Integer requestByteLimit,
      Duration delayThreshold,
      @javax.annotation.Nullable Integer blockingCallCountThreshold) {
    this.elementCountThreshold = elementCountThreshold;
    this.elementCountLimit = elementCountLimit;
    this.requestByteThreshold = requestByteThreshold;
    this.requestByteLimit = requestByteLimit;
    if (delayThreshold == null) {
      throw new NullPointerException("Null delayThreshold");
    }
    this.delayThreshold = delayThreshold;
    this.blockingCallCountThreshold = blockingCallCountThreshold;
  }

  @javax.annotation.Nullable
  @Override
  public Integer getElementCountThreshold() {
    return elementCountThreshold;
  }

  @javax.annotation.Nullable
  @Override
  public Integer getElementCountLimit() {
    return elementCountLimit;
  }

  @javax.annotation.Nullable
  @Override
  public Integer getRequestByteThreshold() {
    return requestByteThreshold;
  }

  @javax.annotation.Nullable
  @Override
  public Integer getRequestByteLimit() {
    return requestByteLimit;
  }

  @Override
  public Duration getDelayThreshold() {
    return delayThreshold;
  }

  @javax.annotation.Nullable
  @Override
  public Integer getBlockingCallCountThreshold() {
    return blockingCallCountThreshold;
  }

  @Override
  public String toString() {
    return "BundlingSettings{"
        + "elementCountThreshold=" + elementCountThreshold + ", "
        + "elementCountLimit=" + elementCountLimit + ", "
        + "requestByteThreshold=" + requestByteThreshold + ", "
        + "requestByteLimit=" + requestByteLimit + ", "
        + "delayThreshold=" + delayThreshold + ", "
        + "blockingCallCountThreshold=" + blockingCallCountThreshold
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof BundlingSettings) {
      BundlingSettings that = (BundlingSettings) o;
      return ((this.elementCountThreshold == null) ? (that.getElementCountThreshold() == null) : this.elementCountThreshold.equals(that.getElementCountThreshold()))
           && ((this.elementCountLimit == null) ? (that.getElementCountLimit() == null) : this.elementCountLimit.equals(that.getElementCountLimit()))
           && ((this.requestByteThreshold == null) ? (that.getRequestByteThreshold() == null) : this.requestByteThreshold.equals(that.getRequestByteThreshold()))
           && ((this.requestByteLimit == null) ? (that.getRequestByteLimit() == null) : this.requestByteLimit.equals(that.getRequestByteLimit()))
           && (this.delayThreshold.equals(that.getDelayThreshold()))
           && ((this.blockingCallCountThreshold == null) ? (that.getBlockingCallCountThreshold() == null) : this.blockingCallCountThreshold.equals(that.getBlockingCallCountThreshold()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (elementCountThreshold == null) ? 0 : elementCountThreshold.hashCode();
    h *= 1000003;
    h ^= (elementCountLimit == null) ? 0 : elementCountLimit.hashCode();
    h *= 1000003;
    h ^= (requestByteThreshold == null) ? 0 : requestByteThreshold.hashCode();
    h *= 1000003;
    h ^= (requestByteLimit == null) ? 0 : requestByteLimit.hashCode();
    h *= 1000003;
    h ^= delayThreshold.hashCode();
    h *= 1000003;
    h ^= (blockingCallCountThreshold == null) ? 0 : blockingCallCountThreshold.hashCode();
    return h;
  }

  static final class Builder extends BundlingSettings.Builder {
    private Integer elementCountThreshold;
    private Integer elementCountLimit;
    private Integer requestByteThreshold;
    private Integer requestByteLimit;
    private Duration delayThreshold;
    private Integer blockingCallCountThreshold;
    Builder() {
    }
    Builder(BundlingSettings source) {
      this.elementCountThreshold = source.getElementCountThreshold();
      this.elementCountLimit = source.getElementCountLimit();
      this.requestByteThreshold = source.getRequestByteThreshold();
      this.requestByteLimit = source.getRequestByteLimit();
      this.delayThreshold = source.getDelayThreshold();
      this.blockingCallCountThreshold = source.getBlockingCallCountThreshold();
    }
    @Override
    public BundlingSettings.Builder setElementCountThreshold(Integer elementCountThreshold) {
      this.elementCountThreshold = elementCountThreshold;
      return this;
    }
    @Override
    public BundlingSettings.Builder setElementCountLimit(Integer elementCountLimit) {
      this.elementCountLimit = elementCountLimit;
      return this;
    }
    @Override
    public BundlingSettings.Builder setRequestByteThreshold(Integer requestByteThreshold) {
      this.requestByteThreshold = requestByteThreshold;
      return this;
    }
    @Override
    public BundlingSettings.Builder setRequestByteLimit(Integer requestByteLimit) {
      this.requestByteLimit = requestByteLimit;
      return this;
    }
    @Override
    public BundlingSettings.Builder setDelayThreshold(Duration delayThreshold) {
      this.delayThreshold = delayThreshold;
      return this;
    }
    @Override
    public BundlingSettings.Builder setBlockingCallCountThreshold(Integer blockingCallCountThreshold) {
      this.blockingCallCountThreshold = blockingCallCountThreshold;
      return this;
    }
    @Override
    public BundlingSettings autoBuild() {
      String missing = "";
      if (delayThreshold == null) {
        missing += " delayThreshold";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_BundlingSettings(
          this.elementCountThreshold,
          this.elementCountLimit,
          this.requestByteThreshold,
          this.requestByteLimit,
          this.delayThreshold,
          this.blockingCallCountThreshold);
    }
  }
}
