
package com.google.api.gax.core;

import com.google.auth.Credentials;
import java.util.List;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ConnectionSettings extends ConnectionSettings {

  private final ConnectionSettings.CredentialsProvider credentialsProvider;
  private final String serviceAddress;
  private final int port;

  private AutoValue_ConnectionSettings(
      ConnectionSettings.CredentialsProvider credentialsProvider,
      String serviceAddress,
      int port) {
    if (credentialsProvider == null) {
      throw new NullPointerException("Null credentialsProvider");
    }
    this.credentialsProvider = credentialsProvider;
    if (serviceAddress == null) {
      throw new NullPointerException("Null serviceAddress");
    }
    this.serviceAddress = serviceAddress;
    this.port = port;
  }

  @Override
  ConnectionSettings.CredentialsProvider getCredentialsProvider() {
    return credentialsProvider;
  }

  @Override
  public String getServiceAddress() {
    return serviceAddress;
  }

  @Override
  public int getPort() {
    return port;
  }

  @Override
  public String toString() {
    return "ConnectionSettings{"
        + "credentialsProvider=" + credentialsProvider + ", "
        + "serviceAddress=" + serviceAddress + ", "
        + "port=" + port
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ConnectionSettings) {
      ConnectionSettings that = (ConnectionSettings) o;
      return (this.credentialsProvider.equals(that.getCredentialsProvider()))
           && (this.serviceAddress.equals(that.getServiceAddress()))
           && (this.port == that.getPort());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= credentialsProvider.hashCode();
    h *= 1000003;
    h ^= serviceAddress.hashCode();
    h *= 1000003;
    h ^= port;
    return h;
  }

  static final class Builder extends ConnectionSettings.Builder {
    private ConnectionSettings.CredentialsProvider credentialsProvider;
    private String serviceAddress;
    private Integer port;
    Builder() {
    }
    Builder(ConnectionSettings source) {
      this.credentialsProvider = source.getCredentialsProvider();
      this.serviceAddress = source.getServiceAddress();
      this.port = source.getPort();
    }
    @Override
    public ConnectionSettings.Builder setCredentialsProvider(ConnectionSettings.CredentialsProvider credentialsProvider) {
      this.credentialsProvider = credentialsProvider;
      return this;
    }
    @Override
    public ConnectionSettings.Builder setServiceAddress(String serviceAddress) {
      this.serviceAddress = serviceAddress;
      return this;
    }
    @Override
    public ConnectionSettings.Builder setPort(int port) {
      this.port = port;
      return this;
    }
    @Override
    public ConnectionSettings build() {
      String missing = "";
      if (credentialsProvider == null) {
        missing += " credentialsProvider";
      }
      if (serviceAddress == null) {
        missing += " serviceAddress";
      }
      if (port == null) {
        missing += " port";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ConnectionSettings(
          this.credentialsProvider,
          this.serviceAddress,
          this.port);
    }
  }
}
