
package com.google.api.gax.grpc;

import javax.annotation.Generated;
import org.joda.time.Duration;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_BundlingSettings extends BundlingSettings {

  private final Integer elementCountThreshold;
  private final Integer requestByteThreshold;
  private final Duration delayThreshold;
  private final Integer blockingCallCountThreshold;

  private AutoValue_BundlingSettings(
      @javax.annotation.Nullable Integer elementCountThreshold,
      @javax.annotation.Nullable Integer requestByteThreshold,
      Duration delayThreshold,
      @javax.annotation.Nullable Integer blockingCallCountThreshold) {
    this.elementCountThreshold = elementCountThreshold;
    this.requestByteThreshold = requestByteThreshold;
    if (delayThreshold == null) {
      throw new NullPointerException("Null delayThreshold");
    }
    this.delayThreshold = delayThreshold;
    this.blockingCallCountThreshold = blockingCallCountThreshold;
  }

  @javax.annotation.Nullable
  @Override
  public Integer getElementCountThreshold() {
    return elementCountThreshold;
  }

  @javax.annotation.Nullable
  @Override
  public Integer getRequestByteThreshold() {
    return requestByteThreshold;
  }

  @Override
  public Duration getDelayThreshold() {
    return delayThreshold;
  }

  @javax.annotation.Nullable
  @Override
  public Integer getBlockingCallCountThreshold() {
    return blockingCallCountThreshold;
  }

  @Override
  public String toString() {
    return "BundlingSettings{"
        + "elementCountThreshold=" + elementCountThreshold + ", "
        + "requestByteThreshold=" + requestByteThreshold + ", "
        + "delayThreshold=" + delayThreshold + ", "
        + "blockingCallCountThreshold=" + blockingCallCountThreshold
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof BundlingSettings) {
      BundlingSettings that = (BundlingSettings) o;
      return ((this.elementCountThreshold == null) ? (that.getElementCountThreshold() == null) : this.elementCountThreshold.equals(that.getElementCountThreshold()))
           && ((this.requestByteThreshold == null) ? (that.getRequestByteThreshold() == null) : this.requestByteThreshold.equals(that.getRequestByteThreshold()))
           && (this.delayThreshold.equals(that.getDelayThreshold()))
           && ((this.blockingCallCountThreshold == null) ? (that.getBlockingCallCountThreshold() == null) : this.blockingCallCountThreshold.equals(that.getBlockingCallCountThreshold()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (elementCountThreshold == null) ? 0 : elementCountThreshold.hashCode();
    h *= 1000003;
    h ^= (requestByteThreshold == null) ? 0 : requestByteThreshold.hashCode();
    h *= 1000003;
    h ^= delayThreshold.hashCode();
    h *= 1000003;
    h ^= (blockingCallCountThreshold == null) ? 0 : blockingCallCountThreshold.hashCode();
    return h;
  }

  static final class Builder extends BundlingSettings.Builder {
    private Integer elementCountThreshold;
    private Integer requestByteThreshold;
    private Duration delayThreshold;
    private Integer blockingCallCountThreshold;
    Builder() {
    }
    Builder(BundlingSettings source) {
      this.elementCountThreshold = source.getElementCountThreshold();
      this.requestByteThreshold = source.getRequestByteThreshold();
      this.delayThreshold = source.getDelayThreshold();
      this.blockingCallCountThreshold = source.getBlockingCallCountThreshold();
    }
    @Override
    public BundlingSettings.Builder setElementCountThreshold(Integer elementCountThreshold) {
      this.elementCountThreshold = elementCountThreshold;
      return this;
    }
    @Override
    public BundlingSettings.Builder setRequestByteThreshold(Integer requestByteThreshold) {
      this.requestByteThreshold = requestByteThreshold;
      return this;
    }
    @Override
    public BundlingSettings.Builder setDelayThreshold(Duration delayThreshold) {
      this.delayThreshold = delayThreshold;
      return this;
    }
    @Override
    public BundlingSettings.Builder setBlockingCallCountThreshold(Integer blockingCallCountThreshold) {
      this.blockingCallCountThreshold = blockingCallCountThreshold;
      return this;
    }
    @Override
    public BundlingSettings autoBuild() {
      String missing = "";
      if (delayThreshold == null) {
        missing += " delayThreshold";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_BundlingSettings(
          this.elementCountThreshold,
          this.requestByteThreshold,
          this.delayThreshold,
          this.blockingCallCountThreshold);
    }
  }
}
