/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.testing;

import com.google.api.gax.testing.CommandWrapper;
import com.google.api.gax.testing.EmulatorRunner;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class GCloudEmulatorRunner
implements EmulatorRunner {
    private final List<String> commandText;
    private final String versionPrefix;
    private final String minVersion;
    private Process process;

    public GCloudEmulatorRunner(List<String> commandText, String versionPrefix, String minVersion) {
        this.commandText = commandText;
        this.versionPrefix = versionPrefix;
        this.minVersion = minVersion;
    }

    @Override
    public boolean isAvailable() {
        try {
            return this.isGCloudInstalled() && this.isEmulatorUpdateToDate() && this.commandText.size() > 0;
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace(System.err);
            return false;
        }
    }

    @Override
    public void start() throws IOException {
        this.process = CommandWrapper.create().command(this.commandText).start();
    }

    @Override
    public void stop() throws InterruptedException {
        if (this.process != null) {
            this.process.destroy();
            this.process.waitFor();
        }
    }

    @Override
    public Process getProcess() {
        return this.process;
    }

    private boolean isGCloudInstalled() {
        Map<String, String> env = System.getenv();
        for (String envName : env.keySet()) {
            if (!envName.equals("PATH")) continue;
            return env.get(envName).contains("google-cloud-sdk");
        }
        return false;
    }

    private boolean isEmulatorUpdateToDate() throws IOException, InterruptedException {
        String currentVersion = this.installedEmulatorVersion(this.versionPrefix);
        return currentVersion != null && currentVersion.compareTo(this.minVersion) >= 0;
    }

    private String installedEmulatorVersion(String versionPrefix) throws IOException, InterruptedException {
        Process process = CommandWrapper.create().command(Arrays.asList("gcloud", "version")).redirectErrorStream().start();
        process.waitFor();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line = reader.readLine();
            while (line != null) {
                String[] lineComponents;
                if (line.startsWith(versionPrefix) && (lineComponents = line.split(" ")).length > 1) {
                    String string = lineComponents[1];
                    return string;
                }
                line = reader.readLine();
            }
            String string = null;
            return string;
        }
    }
}

