/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.testing;

import com.google.api.gax.testing.CommandWrapper;
import com.google.api.gax.testing.EmulatorRunner;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class DownloadableEmulatorRunner
implements EmulatorRunner {
    private final List<String> commandText;
    private final String md5CheckSum;
    private final URL downloadUrl;
    private final String fileName;
    private Process process;
    private static final Logger log = Logger.getLogger(DownloadableEmulatorRunner.class.getName());

    public DownloadableEmulatorRunner(List<String> commandText, URL downloadUrl, String md5CheckSum) {
        this.commandText = commandText;
        this.md5CheckSum = md5CheckSum;
        this.downloadUrl = downloadUrl;
        String[] splitUrl = downloadUrl.toString().split("/");
        this.fileName = splitUrl[splitUrl.length - 1];
    }

    @Override
    public boolean isAvailable() {
        try {
            this.downloadZipFile();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void start() throws IOException {
        Path emulatorPath = this.downloadEmulator();
        this.process = CommandWrapper.create().command(this.commandText).directory(emulatorPath).start();
    }

    @Override
    public void stop() throws InterruptedException {
        if (this.process != null) {
            this.process.destroy();
            this.process.waitFor();
        }
    }

    @Override
    public Process getProcess() {
        return this.process;
    }

    private Path downloadEmulator() throws IOException {
        String[] splittedUrl = this.downloadUrl.toString().split("/");
        String fileName = splittedUrl[splittedUrl.length - 1];
        Path emulatorPath = Files.createTempDirectory(fileName.split("\\.")[0], new FileAttribute[0]);
        File emulatorFolder = emulatorPath.toFile();
        emulatorFolder.deleteOnExit();
        File zipFile = this.downloadZipFile();
        try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFile));){
            if (log.isLoggable(Level.FINE)) {
                log.fine("Unzipping emulator");
            }
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                File filePath = new File(emulatorPath.toFile(), entry.getName());
                if (!entry.isDirectory()) {
                    this.extractFile(zipIn, filePath);
                } else {
                    filePath.mkdir();
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
        return emulatorPath;
    }

    private File downloadZipFile() throws IOException {
        File zipFile = new File(System.getProperty("java.io.tmpdir"), this.fileName);
        if (!zipFile.exists() || this.md5CheckSum != null && !this.md5CheckSum.equals(DownloadableEmulatorRunner.md5(zipFile))) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Fetching emulator");
            }
            ReadableByteChannel rbc = Channels.newChannel(this.downloadUrl.openStream());
            try (FileOutputStream fos = new FileOutputStream(zipFile);){
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            }
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("Using cached emulator");
        }
        return zipFile;
    }

    private void extractFile(ZipInputStream zipIn, File filePath) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));){
            int read;
            byte[] bytesIn = new byte[1024];
            while ((read = zipIn.read(bytesIn)) != -1) {
                bos.write(bytesIn, 0, read);
            }
        }
    }

    private static String md5(File zipFile) throws IOException {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(zipFile));){
                int len;
                byte[] bytes = new byte[0x400000];
                while ((len = ((InputStream)is).read(bytes)) >= 0) {
                    md5.update(bytes, 0, len);
                }
            }
            return String.format("%032x", new BigInteger(1, md5.digest()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }
}

