/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class InstantiatingHttpJsonChannelProviderTest {
    @Test
    public void basicTest() throws IOException {
        String endpoint = "localhost:8080";
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        executor.shutdown();
        InstantiatingHttpJsonChannelProvider provider = InstantiatingHttpJsonChannelProvider.newBuilder().build();
        Truth.assertThat((Boolean)provider.needsEndpoint()).isTrue();
        provider = provider.withEndpoint(endpoint);
        Truth.assertThat((Boolean)provider.needsEndpoint()).isFalse();
        Truth.assertThat((Boolean)provider.needsExecutor()).isTrue();
        provider = provider.withExecutor((ScheduledExecutorService)executor);
        Truth.assertThat((Boolean)provider.needsExecutor()).isFalse();
        Truth.assertThat((Boolean)provider.needsHeaders()).isTrue();
        provider = provider.withHeaders(Collections.emptyMap());
        Truth.assertThat((Boolean)provider.needsHeaders()).isFalse();
        Truth.assertThat((Boolean)provider.acceptsPoolSize()).isFalse();
        Exception thrownException = null;
        try {
            provider.withPoolSize(1);
        }
        catch (Exception e) {
            thrownException = e;
        }
        Truth.assertThat((Throwable)thrownException).isInstanceOf(UnsupportedOperationException.class);
        Truth.assertThat((Boolean)provider.needsCredentials()).isFalse();
        thrownException = null;
        try {
            provider.withCredentials(null);
        }
        catch (Exception e) {
            thrownException = e;
        }
        Truth.assertThat((Throwable)thrownException).isInstanceOf(UnsupportedOperationException.class);
        Assert.assertEquals((Object)HttpJsonTransportChannel.getHttpJsonTransportName(), (Object)provider.getTransportName());
        Truth.assertThat((Object)provider.getTransportChannel()).isInstanceOf(HttpJsonTransportChannel.class);
        provider.getTransportChannel().shutdownNow();
    }
}

