/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.core.SettableApiFuture;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallContext;
import com.google.api.gax.httpjson.HttpJsonCallOptions;
import com.google.api.gax.httpjson.HttpJsonChannel;
import com.google.api.gax.httpjson.HttpJsonDirectCallable;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.pathtemplate.PathTemplate;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;
import org.threeten.bp.temporal.TemporalAmount;

public class HttpJsonDirectCallableTest {
    private final ApiMethodDescriptor<String, String> API_DESCRIPTOR = ApiMethodDescriptor.newBuilder().setFullMethodName("fakeMethod").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)new FakeRequestFormatter()).setResponseParser((HttpResponseParser)new FakeResponseParser()).build();

    @Test
    public void testTimeout() {
        HttpJsonChannel mockChannel = (HttpJsonChannel)Mockito.mock(HttpJsonChannel.class);
        String expectedRequest = "fake";
        HttpJsonDirectCallable callable = new HttpJsonDirectCallable(this.API_DESCRIPTOR);
        ArgumentCaptor capturedCallOptions = ArgumentCaptor.forClass(HttpJsonCallOptions.class);
        Mockito.when((Object)mockChannel.issueFutureUnaryCall((HttpJsonCallOptions)capturedCallOptions.capture(), (Object)Mockito.anyString(), (ApiMethodDescriptor)Mockito.any(ApiMethodDescriptor.class))).thenReturn((Object)SettableApiFuture.create());
        Duration timeout = Duration.ofSeconds((long)10L);
        Instant minExpectedDeadline = Instant.now().plus((TemporalAmount)timeout);
        HttpJsonCallContext callContext = HttpJsonCallContext.createDefault().withChannel(mockChannel).withTimeout(timeout);
        callable.futureCall((Object)expectedRequest, (ApiCallContext)callContext);
        Instant maxExpectedDeadline = Instant.now().plus((TemporalAmount)timeout);
        Truth.assertThat((Comparable)((HttpJsonCallOptions)capturedCallOptions.getValue()).getDeadline()).isAtLeast((Comparable)minExpectedDeadline);
        Truth.assertThat((Comparable)((HttpJsonCallOptions)capturedCallOptions.getValue()).getDeadline()).isAtMost((Comparable)maxExpectedDeadline);
    }

    @Test
    public void testTimeoutAfterDeadline() {
        HttpJsonChannel mockChannel = (HttpJsonChannel)Mockito.mock(HttpJsonChannel.class);
        String expectedRequest = "fake";
        HttpJsonDirectCallable callable = new HttpJsonDirectCallable(this.API_DESCRIPTOR);
        ArgumentCaptor capturedCallOptions = ArgumentCaptor.forClass(HttpJsonCallOptions.class);
        Mockito.when((Object)mockChannel.issueFutureUnaryCall((HttpJsonCallOptions)capturedCallOptions.capture(), (Object)Mockito.anyString(), (ApiMethodDescriptor)Mockito.any(ApiMethodDescriptor.class))).thenReturn((Object)SettableApiFuture.create());
        Instant priorDeadline = Instant.now().plusSeconds(5L);
        Duration timeout = Duration.ofSeconds((long)10L);
        HttpJsonCallContext callContext = HttpJsonCallContext.createDefault().withChannel(mockChannel).withDeadline(priorDeadline).withTimeout(timeout);
        callable.futureCall((Object)expectedRequest, (ApiCallContext)callContext);
        Truth.assertThat((Comparable)((HttpJsonCallOptions)capturedCallOptions.getValue()).getDeadline()).isEqualTo((Object)priorDeadline);
    }

    @Test
    public void testTimeoutBeforeDeadline() {
        HttpJsonChannel mockChannel = (HttpJsonChannel)Mockito.mock(HttpJsonChannel.class);
        String expectedRequest = "fake";
        HttpJsonDirectCallable callable = new HttpJsonDirectCallable(this.API_DESCRIPTOR);
        ArgumentCaptor capturedCallOptions = ArgumentCaptor.forClass(HttpJsonCallOptions.class);
        Mockito.when((Object)mockChannel.issueFutureUnaryCall((HttpJsonCallOptions)capturedCallOptions.capture(), (Object)Mockito.anyString(), (ApiMethodDescriptor)Mockito.any(ApiMethodDescriptor.class))).thenReturn((Object)SettableApiFuture.create());
        Duration timeout = Duration.ofSeconds((long)10L);
        Instant subsequentDeadline = Instant.now().plusSeconds(15L);
        Instant minExpectedDeadline = Instant.now().plus((TemporalAmount)timeout);
        HttpJsonCallContext callContext = HttpJsonCallContext.createDefault().withChannel(mockChannel).withDeadline(subsequentDeadline).withTimeout(timeout);
        callable.futureCall((Object)expectedRequest, (ApiCallContext)callContext);
        Instant maxExpectedDeadline = Instant.now().plus((TemporalAmount)timeout);
        Truth.assertThat((Comparable)((HttpJsonCallOptions)capturedCallOptions.getValue()).getDeadline()).isAtLeast((Comparable)minExpectedDeadline);
        Truth.assertThat((Comparable)((HttpJsonCallOptions)capturedCallOptions.getValue()).getDeadline()).isAtMost((Comparable)maxExpectedDeadline);
    }

    private static final class FakeResponseParser
    implements HttpResponseParser<String> {
        private FakeResponseParser() {
        }

        public String parse(InputStream httpContent) {
            return "fake";
        }

        public String serialize(String response) {
            return response;
        }
    }

    private static final class FakeRequestFormatter
    implements HttpRequestFormatter<String> {
        private FakeRequestFormatter() {
        }

        public Map<String, List<String>> getQueryParamNames(String apiMessage) {
            return ImmutableMap.of();
        }

        public String getRequestBody(String apiMessage) {
            return "fake";
        }

        public String getPath(String apiMessage) {
            return "/fake/path";
        }

        public PathTemplate getPathTemplate() {
            return PathTemplate.create((String)"/fake/path");
        }
    }
}

