/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageOperationTransformers;
import com.google.api.gax.httpjson.EmptyMessage;
import com.google.api.gax.httpjson.HttpJsonStatusCode;
import com.google.api.gax.httpjson.testing.FakeApiMessage;
import com.google.api.gax.longrunning.OperationSnapshot;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnavailableException;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import java.util.List;
import java.util.Map;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ApiMessageOperationTransformersTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testResponseTransformer() {
        ApiMessageOperationTransformers.ResponseTransformer transformer = ApiMessageOperationTransformers.ResponseTransformer.create(EmptyMessage.class);
        EmptyMessage emptyResponse = EmptyMessage.getDefaultInstance();
        FakeMetadataMessage metadata = new FakeMetadataMessage(Status.PENDING, StatusCode.Code.OK);
        OperationSnapshotImpl operationSnapshot = new OperationSnapshotImpl(new FakeOperationMessage("Pending; no response method", emptyResponse, metadata));
        Truth.assertThat((Object)transformer.apply((OperationSnapshot)operationSnapshot)).isEqualTo((Object)emptyResponse);
    }

    @Test
    public void testResponseTransformer_exception() {
        this.thrown.expect(UnavailableException.class);
        ApiMessageOperationTransformers.ResponseTransformer transformer = ApiMessageOperationTransformers.ResponseTransformer.create(EmptyMessage.class);
        EmptyMessage emptyResponse = EmptyMessage.getDefaultInstance();
        FakeMetadataMessage metadata = new FakeMetadataMessage(Status.PENDING, StatusCode.Code.UNAVAILABLE);
        OperationSnapshotImpl operationSnapshot = new OperationSnapshotImpl(new FakeOperationMessage("Unavailable; no response method", emptyResponse, metadata));
        Truth.assertThat((Object)transformer.apply((OperationSnapshot)operationSnapshot)).isEqualTo((Object)emptyResponse);
    }

    @Test
    public void testResponseTransformer_mismatchedTypes() {
        this.thrown.expect(ApiException.class);
        this.thrown.expectMessage("cannot be cast");
        ApiMessageOperationTransformers.ResponseTransformer transformer = ApiMessageOperationTransformers.ResponseTransformer.create(EmptyMessage.class);
        FakeMetadataMessage metadata = new FakeMetadataMessage(Status.PENDING, StatusCode.Code.OK);
        FakeApiMessage bananaResponse = new FakeApiMessage((Map<String, Object>)ImmutableMap.of((Object)"name", (Object)"banana"), null, null);
        EmptyMessage emptyResponse = EmptyMessage.getDefaultInstance();
        OperationSnapshotImpl operationSnapshot = new OperationSnapshotImpl(new FakeOperationMessage("No response method", bananaResponse, metadata));
        Truth.assertThat((Object)transformer.apply((OperationSnapshot)operationSnapshot)).isEqualTo((Object)emptyResponse);
    }

    @Test
    public void testMetadataTransformer() {
        ApiMessageOperationTransformers.MetadataTransformer transformer = ApiMessageOperationTransformers.MetadataTransformer.create(FakeMetadataMessage.class);
        EmptyMessage returnType = EmptyMessage.getDefaultInstance();
        FakeMetadataMessage metadataMessage = new FakeMetadataMessage(Status.PENDING, StatusCode.Code.OK);
        FakeOperationMessage operation = new FakeOperationMessage("foo", returnType, metadataMessage);
        OperationSnapshotImpl operationSnapshot = new OperationSnapshotImpl(operation);
        Truth.assertThat((Object)transformer.apply((OperationSnapshot)operationSnapshot)).isEqualTo(metadataMessage);
    }

    @Test
    public void testMetadataTransformer_mismatchedTypes() {
        this.thrown.expect(ApiException.class);
        this.thrown.expectMessage("cannot be cast");
        ApiMessageOperationTransformers.MetadataTransformer transformer = ApiMessageOperationTransformers.MetadataTransformer.create(FakeOperationMessage.class);
        FakeMetadataMessage metadataMessage = new FakeMetadataMessage(Status.PENDING, StatusCode.Code.OK);
        FakeApiMessage bananaResponse = new FakeApiMessage((Map<String, Object>)ImmutableMap.of((Object)"name", (Object)"banana"), null, null);
        FakeOperationMessage metadata = new FakeOperationMessage("No response method", bananaResponse, metadataMessage);
        OperationSnapshotImpl operationSnapshot = new OperationSnapshotImpl(metadata);
        Truth.assertThat((Object)transformer.apply((OperationSnapshot)operationSnapshot)).isEqualTo((Object)bananaResponse);
    }

    private static class OperationSnapshotImpl
    implements OperationSnapshot {
        private final FakeOperationMessage operation;

        public OperationSnapshotImpl(FakeOperationMessage operation) {
            this.operation = operation;
        }

        public String getName() {
            return (String)this.operation.getFieldValue("name");
        }

        public Object getMetadata() {
            return this.operation.metadata;
        }

        public boolean isDone() {
            return this.operation.metadata.getFieldValue("status") != Status.PENDING;
        }

        public Object getResponse() {
            return this.operation.getApiMessageRequestBody();
        }

        public StatusCode getErrorCode() {
            return HttpJsonStatusCode.of((StatusCode.Code)((StatusCode.Code)this.operation.metadata.getFieldValue("code")));
        }

        public String getErrorMessage() {
            return ((StatusCode.Code)this.operation.metadata.getFieldValue("code")).name();
        }
    }

    private static class FakeOperationMessage<ResponseT extends ApiMessage, MetadataT extends ApiMessage>
    implements ApiMessage {
        private final String name;
        private final ResponseT responseT;
        private final MetadataT metadata;

        public FakeOperationMessage(String name, ResponseT responseT, MetadataT metadata) {
            this.name = name;
            this.responseT = responseT;
            this.metadata = metadata;
        }

        public Object getFieldValue(String fieldName) {
            if ("name".equals(fieldName)) {
                return this.name;
            }
            if ("responseT".equals(fieldName)) {
                return this.responseT;
            }
            if ("metadata".equals(fieldName)) {
                return this.metadata;
            }
            return null;
        }

        public List<String> getFieldMask() {
            return null;
        }

        public ResponseT getApiMessageRequestBody() {
            return this.responseT;
        }
    }

    private static class FakeMetadataMessage<ResponseT extends ApiMessage>
    implements ApiMessage {
        private final Status status;
        private final StatusCode.Code code;

        public FakeMetadataMessage(Status status, StatusCode.Code code) {
            this.status = status;
            this.code = code;
        }

        public Object getFieldValue(String fieldName) {
            if ("status".equals(fieldName)) {
                return this.status;
            }
            if ("code".equals(fieldName)) {
                return this.code;
            }
            return null;
        }

        public List<String> getFieldMask() {
            return null;
        }

        public ApiMessage getApiMessageRequestBody() {
            return null;
        }
    }

    private static enum Status {
        PENDING,
        DONE;

    }
}

