/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.client.http.HttpHeaders;
import com.google.api.gax.httpjson.HttpHeadersUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class HttpHeadersUtilsTest {
    @Test
    public void testSetHeader() {
        HttpHeaders headers = new HttpHeaders();
        Assert.assertEquals((Object)headers, (Object)HttpHeadersUtils.setHeader((HttpHeaders)headers, (String)"Custom-Header", (String)"CustomHeader"));
        HttpHeadersUtils.setHeader((HttpHeaders)headers, (String)"accept", (String)"Accept");
        HttpHeadersUtils.setHeader((HttpHeaders)headers, (String)"accept-encoding", (String)"AcceptEncoding");
        HttpHeadersUtils.setHeader((HttpHeaders)headers, (String)"Authorization", (String)"Authorization");
        HttpHeadersUtils.setHeader((HttpHeaders)headers, (String)"cache-Control", (String)"CacheControl");
        HttpHeadersUtils.setHeader((HttpHeaders)headers, (String)"Content-Encoding", (String)"ContentEncoding");
        HttpHeadersUtils.setHeader((HttpHeaders)headers, (String)"Content-Length", (String)"123");
        HttpHeadersUtils.setHeader((HttpHeaders)headers, (String)"Content-MD5", (String)"ContentMD5");
        HttpHeadersUtils.setHeader((HttpHeaders)headers, (String)"Content-Range", (String)"ContentRange");
        HttpHeadersUtils.setHeader((HttpHeaders)headers, (String)"Content-Type", (String)"ContentType");
        HttpHeadersUtils.setHeader((HttpHeaders)headers, (String)"Cookie", (String)"Cookie");
        HttpHeadersUtils.setHeader((HttpHeaders)headers, (String)"Date", (String)"Date");
        HttpHeadersUtils.setHeader((HttpHeaders)headers, (String)"ETag", (String)"ETag");
        HttpHeadersUtils.setHeader((HttpHeaders)headers, (String)"Expires", (String)"Expires");
        HttpHeadersUtils.setHeader((HttpHeaders)headers, (String)"If-Modified-Since", (String)"IfModifiedSince");
        HttpHeadersUtils.setHeader((HttpHeaders)headers, (String)"If-Match", (String)"IfMatch");
        HttpHeadersUtils.setHeader((HttpHeaders)headers, (String)"If-None-Match", (String)"IfNoneMatch");
        HttpHeadersUtils.setHeader((HttpHeaders)headers, (String)"If-Unmodified-Since", (String)"IfUnmodifiedSince");
        HttpHeadersUtils.setHeader((HttpHeaders)headers, (String)"If-Range", (String)"IfRange");
        HttpHeadersUtils.setHeader((HttpHeaders)headers, (String)"Last-Modified", (String)"LastModified");
        HttpHeadersUtils.setHeader((HttpHeaders)headers, (String)"Location", (String)"Location");
        HttpHeadersUtils.setHeader((HttpHeaders)headers, (String)"Mime-Version", (String)"MimeVersion");
        HttpHeadersUtils.setHeader((HttpHeaders)headers, (String)"Range", (String)"Range");
        HttpHeadersUtils.setHeader((HttpHeaders)headers, (String)"Retry-After", (String)"RetryAfter");
        HttpHeadersUtils.setHeader((HttpHeaders)headers, (String)"User-Agent", (String)"UserAgent");
        HttpHeadersUtils.setHeader((HttpHeaders)headers, (String)"WWW-Authenticate", (String)"Authenticate");
        HttpHeadersUtils.setHeader((HttpHeaders)headers, (String)"Age", (String)"456");
        Assert.assertEquals((Object)"CustomHeader", (Object)headers.get((Object)"Custom-Header"));
        Assert.assertEquals((Object)"CustomHeader", (Object)headers.get((Object)"custom-header"));
        Assert.assertEquals((Object)"Accept", (Object)headers.getAccept());
        Assert.assertEquals((Object)"AcceptEncoding", (Object)headers.getAcceptEncoding());
        Assert.assertEquals((Object)"Authorization", (Object)headers.getAuthorization());
        Assert.assertEquals((Object)"CacheControl", (Object)headers.getCacheControl());
        Assert.assertEquals((Object)"ContentEncoding", (Object)headers.getContentEncoding());
        Assert.assertEquals((Object)123L, (Object)headers.getContentLength());
        Assert.assertEquals((Object)"ContentMD5", (Object)headers.getContentMD5());
        Assert.assertEquals((Object)"ContentRange", (Object)headers.getContentRange());
        Assert.assertEquals((Object)"ContentType", (Object)headers.getContentType());
        Assert.assertEquals((Object)"Cookie", (Object)headers.getCookie());
        Assert.assertEquals((Object)"Date", (Object)headers.getDate());
        Assert.assertEquals((Object)"ETag", (Object)headers.getETag());
        Assert.assertEquals((Object)"Expires", (Object)headers.getExpires());
        Assert.assertEquals((Object)"IfModifiedSince", (Object)headers.getIfModifiedSince());
        Assert.assertEquals((Object)"IfMatch", (Object)headers.getIfMatch());
        Assert.assertEquals((Object)"IfNoneMatch", (Object)headers.getIfNoneMatch());
        Assert.assertEquals((Object)"IfUnmodifiedSince", (Object)headers.getIfUnmodifiedSince());
        Assert.assertEquals((Object)"IfRange", (Object)headers.getIfRange());
        Assert.assertEquals((Object)"LastModified", (Object)headers.getLastModified());
        Assert.assertEquals((Object)"Location", (Object)headers.getLocation());
        Assert.assertEquals((Object)"MimeVersion", (Object)headers.getMimeVersion());
        Assert.assertEquals((Object)"Range", (Object)headers.getRange());
        Assert.assertEquals((Object)"RetryAfter", (Object)headers.getRetryAfter());
        Assert.assertEquals((Object)"UserAgent", (Object)headers.getUserAgent());
        Assert.assertEquals((Object)ImmutableList.of((Object)"UserAgent"), (Object)headers.get((Object)"User-Agent"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"UserAgent"), (Object)headers.get((Object)"user-agent"));
        Assert.assertEquals((Object)"Authenticate", (Object)headers.getAuthenticate());
        Assert.assertEquals((Object)456L, (Object)headers.getAge());
    }

    @Test
    public void testSetHeaders() {
        HttpHeaders headers = new HttpHeaders();
        ImmutableMap headersMap = ImmutableMap.of((Object)"Custom-Header", (Object)"CustomHeader", (Object)"accept", (Object)"Accept", (Object)"Content-Length", (Object)"123");
        Assert.assertEquals((Object)headers, (Object)HttpHeadersUtils.setHeaders((HttpHeaders)headers, (Map)headersMap));
        Assert.assertEquals((Object)"CustomHeader", (Object)headers.get((Object)"Custom-Header"));
        Assert.assertEquals((Object)"Accept", (Object)headers.getAccept());
        Assert.assertEquals((Object)123L, (Object)headers.getContentLength());
    }

    @Test
    public void testGetUserAgentValue() {
        ImmutableMap headersMap = ImmutableMap.of((Object)"Custom-Header", (Object)"CustomHeader", (Object)"User-Agent", (Object)"this is me", (Object)"accept", (Object)"Accept");
        Assert.assertEquals((Object)"this is me", (Object)HttpHeadersUtils.getUserAgentValue((Map)headersMap));
        headersMap = ImmutableMap.of((Object)"Custom-Header", (Object)"CustomHeader", (Object)"accept", (Object)"Accept");
        Assert.assertNull((Object)HttpHeadersUtils.getUserAgentValue((Map)headersMap));
    }
}

