/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallOptions;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpRequestRunnable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.auth.Credentials;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.junit.Test;
import org.threeten.bp.Instant;

public class ApiMessageHttpRequestTest {
    private static final String ENDPOINT = "https://www.googleapis.com/animals/v1/projects/";
    private static PathTemplate nameTemplate = PathTemplate.create((String)"name/{name}");
    private static HttpJsonCallOptions fakeCallOptions = new HttpJsonCallOptions(){

        public Instant getDeadline() {
            return null;
        }

        public Credentials getCredentials() {
            return null;
        }
    };

    @Test
    public void testFieldMask() throws IOException {
        ArrayList fieldMask = Lists.newArrayList((Object[])new String[]{"name", "limbs", "poisonous"});
        FrogMessage frogMessage = new FrogMessage("tree_frog", 4, Lists.newArrayList((Object[])new String[]{"legs"}), null);
        InsertFrogRequest insertFrogRequest = new InsertFrogRequest("name/tree_frog", "request57", frogMessage, fieldMask);
        OutputStream outputStream = this.insertFrog(insertFrogRequest);
        Truth.assertThat((String)outputStream.toString()).isEqualTo((Object)"{\"name\":\"tree_frog\",\"limbs\":[\"legs\"],\"poisonous\":null}");
    }

    @Test
    public void testNullFieldMask() throws IOException {
        List<String> nullFieldMask = null;
        FrogMessage frogMessage = new FrogMessage("tree_frog", 4, Lists.newArrayList((Object[])new String[]{"legs"}), null);
        InsertFrogRequest insertFrogRequest = new InsertFrogRequest("name/tree_frog", "request57", frogMessage, nullFieldMask);
        OutputStream outputStream = this.insertFrog(insertFrogRequest);
        Truth.assertThat((String)outputStream.toString()).isEqualTo((Object)"{\"name\":\"tree_frog\",\"legs\":4,\"limbs\":[\"legs\"]}");
    }

    private OutputStream insertFrog(InsertFrogRequest insertFrogRequest) throws IOException {
        ApiMessageHttpRequestFormatter frogFormatter = ApiMessageHttpRequestFormatter.newBuilder().setResourceNameField("name").setPathTemplate(nameTemplate).setResourceNameFactory((ResourceNameFactory)new ResourceNameFactory<ResourceName>(){

            public ResourceName parse(final String formattedString) {
                return new ResourceName(){

                    public Map<String, String> getFieldValuesMap() {
                        HashMap<String, String> fieldValues = new HashMap<String, String>();
                        fieldValues.put("name", nameTemplate.parse(formattedString).get((Object)"name"));
                        return fieldValues;
                    }

                    public String getFieldValue(String s) {
                        return this.getFieldValuesMap().get(s);
                    }
                };
            }
        }).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).build();
        ApiMethodDescriptor apiMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("house.details.get").setHttpMethod(null).setRequestFormatter((HttpRequestFormatter)frogFormatter).build();
        HttpRequestRunnable httpRequestRunnable = HttpRequestRunnable.newBuilder().setHttpJsonCallOptions(fakeCallOptions).setEndpoint(ENDPOINT).setRequest((Object)insertFrogRequest).setApiMethodDescriptor(apiMethodDescriptor).setHttpTransport((HttpTransport)new MockHttpTransport()).setJsonFactory((JsonFactory)new JacksonFactory()).build();
        HttpRequest httpRequest = httpRequestRunnable.createHttpRequest();
        String expectedUrl = "https://www.googleapis.com/animals/v1/projects/name/tree_frog?requestId=request57";
        Truth.assertThat((String)httpRequest.getUrl().toString()).isEqualTo((Object)expectedUrl);
        PrintableOutputStream outputStream = new PrintableOutputStream();
        httpRequest.getContent().writeTo((OutputStream)outputStream);
        return outputStream;
    }

    public static class PrintableOutputStream
    extends OutputStream {
        private StringBuilder string = new StringBuilder();

        @Override
        public void write(int x) {
            this.string.append((char)x);
        }

        public String toString() {
            return this.string.toString();
        }
    }

    private static class FrogMessage
    implements ApiMessage {
        private final String name;
        private final Integer legs;
        private final List<String> limbs;
        private final Boolean poisonous;

        FrogMessage(String name, Integer legs, List<String> limbs, Boolean poisonous) {
            this.name = name;
            this.legs = legs;
            this.limbs = limbs;
            this.poisonous = poisonous;
        }

        @Nullable
        public Object getFieldValue(String fieldName) {
            if ("name".equals(fieldName)) {
                return this.name;
            }
            if ("legs".equals(fieldName)) {
                return this.legs;
            }
            if ("limbs".equals(fieldName)) {
                return this.limbs;
            }
            if ("poisonous".equals(fieldName)) {
                return this.poisonous;
            }
            return null;
        }

        @Nullable
        public List<String> getFieldMask() {
            return null;
        }

        @Nullable
        public ApiMessage getApiMessageRequestBody() {
            return null;
        }
    }

    private static class InsertFrogRequest
    implements ApiMessage {
        private final String name;
        private final String requestId;
        private final FrogMessage requestBody;
        private final transient List<String> fieldMask;

        InsertFrogRequest(String name, String requestId, FrogMessage frog, List<String> fieldMask) {
            this.name = name;
            this.requestId = requestId;
            this.requestBody = frog;
            this.fieldMask = fieldMask;
        }

        @Nullable
        public ApiMessage getApiMessageRequestBody() {
            return this.requestBody;
        }

        @Nullable
        public Object getFieldValue(String fieldName) {
            if ("name".equals(fieldName)) {
                return this.name;
            }
            if ("requestId".equals(fieldName)) {
                return this.requestId;
            }
            if ("requestBody".equals(fieldName)) {
                return this.requestBody;
            }
            return null;
        }

        @Nullable
        public List<String> getFieldMask() {
            return this.fieldMask;
        }
    }
}

