/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.api.gax.httpjson.HttpJsonChannel;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.internal.Headers;
import com.google.auth.Credentials;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;
import org.threeten.bp.temporal.TemporalAmount;

@BetaApi
@InternalExtensionOnly
public final class HttpJsonCallContext
implements ApiCallContext {
    private final HttpJsonChannel channel;
    private final Instant deadline;
    private final Credentials credentials;
    private final ImmutableMap<String, List<String>> extraHeaders;

    public static HttpJsonCallContext createDefault() {
        return new HttpJsonCallContext(null, null, null, (ImmutableMap<String, List<String>>)ImmutableMap.of());
    }

    private HttpJsonCallContext(HttpJsonChannel channel, Instant deadline, Credentials credentials, ImmutableMap<String, List<String>> extraHeaders) {
        this.channel = channel;
        this.deadline = deadline;
        this.credentials = credentials;
        this.extraHeaders = extraHeaders;
    }

    public HttpJsonCallContext nullToSelf(ApiCallContext inputContext) {
        HttpJsonCallContext httpJsonCallContext;
        if (inputContext == null) {
            httpJsonCallContext = this;
        } else {
            if (!(inputContext instanceof HttpJsonCallContext)) {
                throw new IllegalArgumentException("context must be an instance of HttpJsonCallContext, but found " + inputContext.getClass().getName());
            }
            httpJsonCallContext = (HttpJsonCallContext)inputContext;
        }
        return httpJsonCallContext;
    }

    public HttpJsonCallContext merge(ApiCallContext inputCallContext) {
        Credentials newCredentials;
        Instant newDeadline;
        if (inputCallContext == null) {
            return this;
        }
        if (!(inputCallContext instanceof HttpJsonCallContext)) {
            throw new IllegalArgumentException("context must be an instance of HttpJsonCallContext, but found " + inputCallContext.getClass().getName());
        }
        HttpJsonCallContext httpJsonCallContext = (HttpJsonCallContext)inputCallContext;
        HttpJsonChannel newChannel = httpJsonCallContext.channel;
        if (newChannel == null) {
            newChannel = this.channel;
        }
        if ((newDeadline = httpJsonCallContext.deadline) == null) {
            newDeadline = this.deadline;
        }
        if ((newCredentials = httpJsonCallContext.credentials) == null) {
            newCredentials = this.credentials;
        }
        ImmutableMap newExtraHeaders = Headers.mergeHeaders(this.extraHeaders, httpJsonCallContext.extraHeaders);
        return new HttpJsonCallContext(newChannel, newDeadline, newCredentials, (ImmutableMap<String, List<String>>)newExtraHeaders);
    }

    public HttpJsonCallContext withCredentials(Credentials newCredentials) {
        return new HttpJsonCallContext(this.channel, this.deadline, newCredentials, this.extraHeaders);
    }

    public HttpJsonCallContext withTransportChannel(TransportChannel inputChannel) {
        Preconditions.checkNotNull((Object)inputChannel);
        if (!(inputChannel instanceof HttpJsonTransportChannel)) {
            throw new IllegalArgumentException("Expected HttpJsonTransportChannel, got " + inputChannel.getClass().getName());
        }
        HttpJsonTransportChannel transportChannel = (HttpJsonTransportChannel)inputChannel;
        return this.withChannel(transportChannel.getChannel());
    }

    public HttpJsonCallContext withTimeout(Duration rpcTimeout) {
        Instant newDeadline = Instant.now().plus((TemporalAmount)rpcTimeout);
        HttpJsonCallContext nextContext = this.withDeadline(newDeadline);
        if (this.deadline == null) {
            return nextContext;
        }
        if (this.deadline.isBefore(newDeadline)) {
            return this;
        }
        return nextContext;
    }

    public ApiCallContext withStreamWaitTimeout(@Nonnull Duration streamWaitTimeout) {
        throw new UnsupportedOperationException("Http/json transport does not support streaming");
    }

    @Nullable
    public Duration getStreamWaitTimeout() {
        throw new UnsupportedOperationException("Http/json transport does not support streaming");
    }

    public ApiCallContext withStreamIdleTimeout(@Nonnull Duration streamIdleTimeout) {
        throw new UnsupportedOperationException("Http/json transport does not support streaming");
    }

    @Nullable
    public Duration getStreamIdleTimeout() {
        throw new UnsupportedOperationException("Http/json transport does not support streaming");
    }

    @BetaApi(value="The surface for extra headers is not stable yet and may change in the future.")
    public ApiCallContext withExtraHeaders(Map<String, List<String>> extraHeaders) {
        Preconditions.checkNotNull(extraHeaders);
        ImmutableMap newExtraHeaders = Headers.mergeHeaders(this.extraHeaders, extraHeaders);
        return new HttpJsonCallContext(this.channel, this.deadline, this.credentials, (ImmutableMap<String, List<String>>)newExtraHeaders);
    }

    @BetaApi(value="The surface for extra headers is not stable yet and may change in the future.")
    public Map<String, List<String>> getExtraHeaders() {
        return this.extraHeaders;
    }

    public HttpJsonChannel getChannel() {
        return this.channel;
    }

    public Instant getDeadline() {
        return this.deadline;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public HttpJsonCallContext withChannel(HttpJsonChannel newChannel) {
        return new HttpJsonCallContext(newChannel, this.deadline, this.credentials, this.extraHeaders);
    }

    public HttpJsonCallContext withDeadline(Instant newDeadline) {
        return new HttpJsonCallContext(this.channel, newDeadline, this.credentials, this.extraHeaders);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return Objects.hash(new Object[0]);
    }
}

