/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@BetaApi
public class ApiMessageHttpRequestFormatter<T extends ApiMessage>
implements HttpRequestFormatter<T> {
    private final ResourceNameFactory resourceNameFactory;

    public ApiMessageHttpRequestFormatter(ResourceNameFactory resourceNameFactory) {
        this.resourceNameFactory = resourceNameFactory;
    }

    @Override
    public Map<String, List<String>> getQueryParams(T apiMessage, Set<String> paramNames) {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        Map<String, List<String>> nullableParams = apiMessage.populateFieldsInMap(paramNames);
        for (Map.Entry<String, List<String>> pair : nullableParams.entrySet()) {
            if (pair.getValue() == null || pair.getValue().size() <= 0 || pair.getValue().get(0) == null) continue;
            queryParams.put(pair.getKey(), pair.getValue());
        }
        return queryParams;
    }

    @Override
    public Map<String, String> getPathParams(T apiMessage, String resourceNameField) {
        String resourceNamePath = apiMessage.getFieldStringValue(resourceNameField);
        if (resourceNamePath == null) {
            throw new IllegalArgumentException(String.format("Resource name field %s is null in message object.", resourceNameField));
        }
        return this.resourceNameFactory.parse(resourceNamePath).getFieldValuesMap();
    }

    @Override
    public void writeRequestBody(ApiMessage apiMessage, Gson marshaller, Appendable writer) {
        ApiMessage body = apiMessage.getApiMessageRequestBody();
        if (body != null) {
            marshaller.toJson((Object)body, writer);
        }
    }
}

