/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.Deadline;
import io.grpc.DoubleHistogramMetricInstrument;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LongCounterMetricInstrument;
import io.grpc.MetricInstrumentRegistry;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.services.MetricReport;
import io.grpc.util.ForwardingSubchannel;
import io.grpc.util.MultiChildLoadBalancer;
import io.grpc.xds.WeightedTargetLoadBalancer;
import io.grpc.xds.orca.OrcaOobUtil;
import io.grpc.xds.orca.OrcaPerRequestUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

final class WeightedRoundRobinLoadBalancer
extends MultiChildLoadBalancer {
    private static final LongCounterMetricInstrument RR_FALLBACK_COUNTER;
    private static final LongCounterMetricInstrument ENDPOINT_WEIGHT_NOT_YET_USEABLE_COUNTER;
    private static final LongCounterMetricInstrument ENDPOINT_WEIGHT_STALE_COUNTER;
    private static final DoubleHistogramMetricInstrument ENDPOINT_WEIGHTS_HISTOGRAM;
    private static final Logger log;
    private WeightedRoundRobinLoadBalancerConfig config;
    private final SynchronizationContext syncContext;
    private final ScheduledExecutorService timeService;
    private SynchronizationContext.ScheduledHandle weightUpdateTimer;
    private final Runnable updateWeightTask;
    private final AtomicInteger sequence;
    private final long infTime;
    private final Deadline.Ticker ticker;
    private String locality = "";
    private String backendService = "";
    private LoadBalancer.SubchannelPicker currentPicker = new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withNoResult());

    public WeightedRoundRobinLoadBalancer(LoadBalancer.Helper helper, Deadline.Ticker ticker) {
        this(helper, ticker, new Random());
    }

    @VisibleForTesting
    WeightedRoundRobinLoadBalancer(LoadBalancer.Helper helper, Deadline.Ticker ticker, Random random) {
        super(OrcaOobUtil.newOrcaReportingHelper(helper));
        this.ticker = Preconditions.checkNotNull(ticker, "ticker");
        this.infTime = ticker.nanoTime() + Long.MAX_VALUE;
        this.syncContext = Preconditions.checkNotNull(helper.getSynchronizationContext(), "syncContext");
        this.timeService = Preconditions.checkNotNull(helper.getScheduledExecutorService(), "timeService");
        this.updateWeightTask = new UpdateWeightTask();
        this.sequence = new AtomicInteger(random.nextInt());
        log.log(Level.FINE, "weighted_round_robin LB created");
    }

    @Override
    protected MultiChildLoadBalancer.ChildLbState createChildLbState(Object key) {
        return new WeightedChildLbState(key, this.pickFirstLbProvider);
    }

    @Override
    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        if (resolvedAddresses.getLoadBalancingPolicyConfig() == null) {
            Status unavailableStatus = Status.UNAVAILABLE.withDescription("NameResolver returned no WeightedRoundRobinLoadBalancerConfig. addrs=" + resolvedAddresses.getAddresses() + ", attrs=" + resolvedAddresses.getAttributes());
            this.handleNameResolutionError(unavailableStatus);
            return unavailableStatus;
        }
        String locality = resolvedAddresses.getAttributes().get(WeightedTargetLoadBalancer.CHILD_NAME);
        this.locality = locality != null ? locality : "";
        String backendService = resolvedAddresses.getAttributes().get(NameResolver.ATTR_BACKEND_SERVICE);
        this.backendService = backendService != null ? backendService : "";
        this.config = (WeightedRoundRobinLoadBalancerConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        if (this.weightUpdateTimer != null && this.weightUpdateTimer.isPending()) {
            this.weightUpdateTimer.cancel();
        }
        this.updateWeightTask.run();
        Status status = super.acceptResolvedAddresses(resolvedAddresses);
        this.createAndApplyOrcaListeners();
        return status;
    }

    @Override
    protected void updateOverallBalancingState() {
        List<MultiChildLoadBalancer.ChildLbState> activeList = this.getReadyChildren();
        if (activeList.isEmpty()) {
            boolean isConnecting = false;
            for (MultiChildLoadBalancer.ChildLbState childLbState : this.getChildLbStates()) {
                ConnectivityState state = childLbState.getCurrentState();
                if (state != ConnectivityState.CONNECTING && state != ConnectivityState.IDLE) continue;
                isConnecting = true;
                break;
            }
            if (isConnecting) {
                this.updateBalancingState(ConnectivityState.CONNECTING, new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withNoResult()));
            } else {
                this.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, this.createReadyPicker(this.getChildLbStates()));
            }
        } else {
            this.updateBalancingState(ConnectivityState.READY, this.createReadyPicker(activeList));
        }
    }

    private LoadBalancer.SubchannelPicker createReadyPicker(Collection<MultiChildLoadBalancer.ChildLbState> activeList) {
        WeightedRoundRobinPicker picker = new WeightedRoundRobinPicker(ImmutableList.copyOf(activeList), this.config.enableOobLoadReport, this.config.errorUtilizationPenalty, this.sequence);
        this.updateWeight(picker);
        return picker;
    }

    private void updateWeight(WeightedRoundRobinPicker picker) {
        boolean weightsEffective;
        LoadBalancer.Helper helper = this.getHelper();
        float[] newWeights = new float[picker.children.size()];
        AtomicInteger staleEndpoints = new AtomicInteger();
        AtomicInteger notYetUsableEndpoints = new AtomicInteger();
        for (int i = 0; i < picker.children.size(); ++i) {
            double newWeight = ((WeightedChildLbState)picker.children.get(i)).getWeight(staleEndpoints, notYetUsableEndpoints);
            helper.getMetricRecorder().recordDoubleHistogram(ENDPOINT_WEIGHTS_HISTOGRAM, newWeight, ImmutableList.of(helper.getChannelTarget()), ImmutableList.of(this.locality, this.backendService));
            newWeights[i] = newWeight > 0.0 ? (float)newWeight : 0.0f;
        }
        if (staleEndpoints.get() > 0) {
            helper.getMetricRecorder().addLongCounter(ENDPOINT_WEIGHT_STALE_COUNTER, staleEndpoints.get(), ImmutableList.of(helper.getChannelTarget()), ImmutableList.of(this.locality, this.backendService));
        }
        if (notYetUsableEndpoints.get() > 0) {
            helper.getMetricRecorder().addLongCounter(ENDPOINT_WEIGHT_NOT_YET_USEABLE_COUNTER, notYetUsableEndpoints.get(), ImmutableList.of(helper.getChannelTarget()), ImmutableList.of(this.locality, this.backendService));
        }
        if (!(weightsEffective = picker.updateWeight(newWeights))) {
            helper.getMetricRecorder().addLongCounter(RR_FALLBACK_COUNTER, 1L, ImmutableList.of(helper.getChannelTarget()), ImmutableList.of(this.locality, this.backendService));
        }
    }

    private void updateBalancingState(ConnectivityState state, LoadBalancer.SubchannelPicker picker) {
        if (state != this.currentConnectivityState || !picker.equals(this.currentPicker)) {
            this.getHelper().updateBalancingState(state, picker);
            this.currentConnectivityState = state;
            this.currentPicker = picker;
        }
    }

    private void createAndApplyOrcaListeners() {
        for (MultiChildLoadBalancer.ChildLbState child : this.getChildLbStates()) {
            WeightedChildLbState wChild = (WeightedChildLbState)child;
            for (WrrSubchannel weightedSubchannel : wChild.subchannels) {
                if (this.config.enableOobLoadReport) {
                    OrcaOobUtil.setListener(weightedSubchannel, wChild.getOrCreateOrcaListener(this.config.errorUtilizationPenalty), OrcaOobUtil.OrcaReportingConfig.newBuilder().setReportInterval(this.config.oobReportingPeriodNanos, TimeUnit.NANOSECONDS).build());
                    continue;
                }
                OrcaOobUtil.setListener(weightedSubchannel, null, null);
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.weightUpdateTimer != null) {
            this.weightUpdateTimer.cancel();
        }
        super.shutdown();
    }

    static {
        log = Logger.getLogger(WeightedRoundRobinLoadBalancer.class.getName());
        MetricInstrumentRegistry metricInstrumentRegistry = MetricInstrumentRegistry.getDefaultRegistry();
        RR_FALLBACK_COUNTER = metricInstrumentRegistry.registerLongCounter("grpc.lb.wrr.rr_fallback", "EXPERIMENTAL. Number of scheduler updates in which there were not enough endpoints with valid weight, which caused the WRR policy to fall back to RR behavior", "{update}", Lists.newArrayList("grpc.target"), Lists.newArrayList("grpc.lb.locality", "grpc.lb.backend_service"), false);
        ENDPOINT_WEIGHT_NOT_YET_USEABLE_COUNTER = metricInstrumentRegistry.registerLongCounter("grpc.lb.wrr.endpoint_weight_not_yet_usable", "EXPERIMENTAL. Number of endpoints from each scheduler update that don't yet have usable weight information", "{endpoint}", Lists.newArrayList("grpc.target"), Lists.newArrayList("grpc.lb.locality", "grpc.lb.backend_service"), false);
        ENDPOINT_WEIGHT_STALE_COUNTER = metricInstrumentRegistry.registerLongCounter("grpc.lb.wrr.endpoint_weight_stale", "EXPERIMENTAL. Number of endpoints from each scheduler update whose latest weight is older than the expiration period", "{endpoint}", Lists.newArrayList("grpc.target"), Lists.newArrayList("grpc.lb.locality", "grpc.lb.backend_service"), false);
        ENDPOINT_WEIGHTS_HISTOGRAM = metricInstrumentRegistry.registerDoubleHistogram("grpc.lb.wrr.endpoint_weights", "EXPERIMENTAL. The histogram buckets will be endpoint weight ranges.", "{weight}", Lists.newArrayList(), Lists.newArrayList("grpc.target"), Lists.newArrayList("grpc.lb.locality", "grpc.lb.backend_service"), false);
    }

    static final class WeightedRoundRobinLoadBalancerConfig {
        final long blackoutPeriodNanos;
        final long weightExpirationPeriodNanos;
        final boolean enableOobLoadReport;
        final long oobReportingPeriodNanos;
        final long weightUpdatePeriodNanos;
        final float errorUtilizationPenalty;

        public static Builder newBuilder() {
            return new Builder();
        }

        private WeightedRoundRobinLoadBalancerConfig(long blackoutPeriodNanos, long weightExpirationPeriodNanos, boolean enableOobLoadReport, long oobReportingPeriodNanos, long weightUpdatePeriodNanos, float errorUtilizationPenalty) {
            this.blackoutPeriodNanos = blackoutPeriodNanos;
            this.weightExpirationPeriodNanos = weightExpirationPeriodNanos;
            this.enableOobLoadReport = enableOobLoadReport;
            this.oobReportingPeriodNanos = oobReportingPeriodNanos;
            this.weightUpdatePeriodNanos = weightUpdatePeriodNanos;
            this.errorUtilizationPenalty = errorUtilizationPenalty;
        }

        public boolean equals(Object o) {
            if (!(o instanceof WeightedRoundRobinLoadBalancerConfig)) {
                return false;
            }
            WeightedRoundRobinLoadBalancerConfig that = (WeightedRoundRobinLoadBalancerConfig)o;
            return this.blackoutPeriodNanos == that.blackoutPeriodNanos && this.weightExpirationPeriodNanos == that.weightExpirationPeriodNanos && this.enableOobLoadReport == that.enableOobLoadReport && this.oobReportingPeriodNanos == that.oobReportingPeriodNanos && this.weightUpdatePeriodNanos == that.weightUpdatePeriodNanos && Float.compare(this.errorUtilizationPenalty, that.errorUtilizationPenalty) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.blackoutPeriodNanos, this.weightExpirationPeriodNanos, this.enableOobLoadReport, this.oobReportingPeriodNanos, this.weightUpdatePeriodNanos, Float.valueOf(this.errorUtilizationPenalty));
        }

        static final class Builder {
            long blackoutPeriodNanos = 10000000000L;
            long weightExpirationPeriodNanos = 180000000000L;
            boolean enableOobLoadReport = false;
            long oobReportingPeriodNanos = 10000000000L;
            long weightUpdatePeriodNanos = 1000000000L;
            float errorUtilizationPenalty = 1.0f;

            private Builder() {
            }

            Builder setBlackoutPeriodNanos(long blackoutPeriodNanos) {
                this.blackoutPeriodNanos = blackoutPeriodNanos;
                return this;
            }

            Builder setWeightExpirationPeriodNanos(long weightExpirationPeriodNanos) {
                this.weightExpirationPeriodNanos = weightExpirationPeriodNanos;
                return this;
            }

            Builder setEnableOobLoadReport(boolean enableOobLoadReport) {
                this.enableOobLoadReport = enableOobLoadReport;
                return this;
            }

            Builder setOobReportingPeriodNanos(long oobReportingPeriodNanos) {
                this.oobReportingPeriodNanos = oobReportingPeriodNanos;
                return this;
            }

            Builder setWeightUpdatePeriodNanos(long weightUpdatePeriodNanos) {
                this.weightUpdatePeriodNanos = weightUpdatePeriodNanos;
                return this;
            }

            Builder setErrorUtilizationPenalty(float errorUtilizationPenalty) {
                this.errorUtilizationPenalty = errorUtilizationPenalty;
                return this;
            }

            WeightedRoundRobinLoadBalancerConfig build() {
                return new WeightedRoundRobinLoadBalancerConfig(this.blackoutPeriodNanos, this.weightExpirationPeriodNanos, this.enableOobLoadReport, this.oobReportingPeriodNanos, this.weightUpdatePeriodNanos, this.errorUtilizationPenalty);
            }
        }
    }

    @VisibleForTesting
    static final class StaticStrideScheduler {
        private final short[] scaledWeights;
        private final AtomicInteger sequence;
        private final boolean usesRoundRobin;
        private static final int K_MAX_WEIGHT = 65535;
        private static final double K_MAX_RATIO = 10.0;
        private static final double K_MIN_RATIO = 0.1;

        StaticStrideScheduler(float[] weights, AtomicInteger sequence) {
            double unscaledMeanWeight;
            Preconditions.checkArgument(weights.length >= 1, "Couldn't build scheduler: requires at least one weight");
            int numChannels = weights.length;
            int numWeightedChannels = 0;
            double sumWeight = 0.0;
            float unscaledMaxWeight = 0.0f;
            for (float weight : weights) {
                if (!(weight > 0.0f)) continue;
                sumWeight += (double)weight;
                unscaledMaxWeight = Math.max(weight, unscaledMaxWeight);
                ++numWeightedChannels;
            }
            if (numWeightedChannels > 0) {
                unscaledMeanWeight = sumWeight / (double)numWeightedChannels;
                unscaledMaxWeight = Math.min(unscaledMaxWeight, (float)(10.0 * unscaledMeanWeight));
            } else {
                unscaledMeanWeight = 1.0;
                unscaledMaxWeight = 1.0f;
            }
            this.usesRoundRobin = numWeightedChannels < 2;
            double scalingFactor = 65535.0f / unscaledMaxWeight;
            int weightLowerBound = (int)Math.ceil(scalingFactor * unscaledMeanWeight * 0.1);
            short[] scaledWeights = new short[numChannels];
            for (int i = 0; i < numChannels; ++i) {
                if (weights[i] <= 0.0f) {
                    scaledWeights[i] = (short)Math.round(scalingFactor * unscaledMeanWeight);
                    continue;
                }
                int weight = (int)Math.round(scalingFactor * (double)Math.min(weights[i], unscaledMaxWeight));
                scaledWeights[i] = (short)Math.max(weight, weightLowerBound);
            }
            this.scaledWeights = scaledWeights;
            this.sequence = sequence;
        }

        boolean usesRoundRobin() {
            return this.usesRoundRobin;
        }

        private long nextSequence() {
            return Integer.toUnsignedLong(this.sequence.getAndIncrement());
        }

        int pick() {
            long offset;
            long generation;
            int backendIndex;
            int weight;
            do {
                long sequence = this.nextSequence();
                backendIndex = (int)(sequence % (long)this.scaledWeights.length);
                generation = sequence / (long)this.scaledWeights.length;
            } while (((long)(weight = Short.toUnsignedInt(this.scaledWeights[backendIndex])) * generation + (offset = 32767L * (long)backendIndex)) % 65535L < (long)(65535 - weight));
            return backendIndex;
        }
    }

    @VisibleForTesting
    static final class WeightedRoundRobinPicker
    extends LoadBalancer.SubchannelPicker {
        private final List<MultiChildLoadBalancer.ChildLbState> children;
        private final List<LoadBalancer.SubchannelPicker> pickers;
        private final List<OrcaPerRequestUtil.OrcaPerRequestReportListener> reportListeners;
        private final boolean enableOobLoadReport;
        private final float errorUtilizationPenalty;
        private final AtomicInteger sequence;
        private final int hashCode;
        private volatile StaticStrideScheduler scheduler;

        WeightedRoundRobinPicker(List<MultiChildLoadBalancer.ChildLbState> children, boolean enableOobLoadReport, float errorUtilizationPenalty, AtomicInteger sequence) {
            Preconditions.checkNotNull(children, "children");
            Preconditions.checkArgument(!children.isEmpty(), "empty child list");
            this.children = children;
            ArrayList<LoadBalancer.SubchannelPicker> pickers = new ArrayList<LoadBalancer.SubchannelPicker>(children.size());
            ArrayList<OrcaPerRequestUtil.OrcaPerRequestReportListener> reportListeners = new ArrayList<OrcaPerRequestUtil.OrcaPerRequestReportListener>(children.size());
            for (MultiChildLoadBalancer.ChildLbState child : children) {
                WeightedChildLbState wChild = (WeightedChildLbState)child;
                pickers.add(wChild.getCurrentPicker());
                reportListeners.add(wChild.getOrCreateOrcaListener(errorUtilizationPenalty));
            }
            this.pickers = pickers;
            this.reportListeners = reportListeners;
            this.enableOobLoadReport = enableOobLoadReport;
            this.errorUtilizationPenalty = errorUtilizationPenalty;
            this.sequence = Preconditions.checkNotNull(sequence, "sequence");
            int sum = 0;
            for (LoadBalancer.SubchannelPicker picker : pickers) {
                sum += picker.hashCode();
            }
            this.hashCode = sum ^ Boolean.hashCode(enableOobLoadReport) ^ Float.hashCode(errorUtilizationPenalty);
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            int pick = this.scheduler.pick();
            LoadBalancer.PickResult pickResult = this.pickers.get(pick).pickSubchannel(args);
            LoadBalancer.Subchannel subchannel = pickResult.getSubchannel();
            if (subchannel == null) {
                return pickResult;
            }
            if (!this.enableOobLoadReport) {
                return LoadBalancer.PickResult.withSubchannel(subchannel, OrcaPerRequestUtil.getInstance().newOrcaClientStreamTracerFactory(this.reportListeners.get(pick)));
            }
            return LoadBalancer.PickResult.withSubchannel(subchannel);
        }

        private boolean updateWeight(float[] newWeights) {
            this.scheduler = new StaticStrideScheduler(newWeights, this.sequence);
            return !this.scheduler.usesRoundRobin();
        }

        public String toString() {
            return MoreObjects.toStringHelper(WeightedRoundRobinPicker.class).add("enableOobLoadReport", this.enableOobLoadReport).add("errorUtilizationPenalty", this.errorUtilizationPenalty).add("pickers", this.pickers).toString();
        }

        @VisibleForTesting
        List<MultiChildLoadBalancer.ChildLbState> getChildren() {
            return this.children;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof WeightedRoundRobinPicker)) {
                return false;
            }
            WeightedRoundRobinPicker other = (WeightedRoundRobinPicker)o;
            if (other == this) {
                return true;
            }
            return this.hashCode == other.hashCode && this.sequence == other.sequence && this.enableOobLoadReport == other.enableOobLoadReport && Float.compare(this.errorUtilizationPenalty, other.errorUtilizationPenalty) == 0 && this.pickers.size() == other.pickers.size() && new HashSet<LoadBalancer.SubchannelPicker>(this.pickers).containsAll(other.pickers);
        }
    }

    @VisibleForTesting
    final class WrrSubchannel
    extends ForwardingSubchannel {
        private final LoadBalancer.Subchannel delegate;
        private final WeightedChildLbState owner;

        WrrSubchannel(LoadBalancer.Subchannel delegate, WeightedChildLbState owner) {
            this.delegate = Preconditions.checkNotNull(delegate, "delegate");
            this.owner = Preconditions.checkNotNull(owner, "owner");
        }

        @Override
        public void start(final LoadBalancer.SubchannelStateListener listener) {
            this.owner.addSubchannel(this);
            this.delegate().start(new LoadBalancer.SubchannelStateListener(){

                @Override
                public void onSubchannelState(ConnectivityStateInfo newState) {
                    if (newState.getState().equals((Object)ConnectivityState.READY)) {
                        WrrSubchannel.this.owner.nonEmptySince = WeightedRoundRobinLoadBalancer.this.infTime;
                    }
                    listener.onSubchannelState(newState);
                }
            });
        }

        @Override
        protected LoadBalancer.Subchannel delegate() {
            return this.delegate;
        }

        @Override
        public void shutdown() {
            super.shutdown();
            this.owner.removeSubchannel(this);
        }
    }

    private final class UpdateWeightTask
    implements Runnable {
        private UpdateWeightTask() {
        }

        @Override
        public void run() {
            if (WeightedRoundRobinLoadBalancer.this.currentPicker != null && WeightedRoundRobinLoadBalancer.this.currentPicker instanceof WeightedRoundRobinPicker) {
                WeightedRoundRobinLoadBalancer.this.updateWeight((WeightedRoundRobinPicker)WeightedRoundRobinLoadBalancer.this.currentPicker);
            }
            WeightedRoundRobinLoadBalancer.this.weightUpdateTimer = WeightedRoundRobinLoadBalancer.this.syncContext.schedule(this, ((WeightedRoundRobinLoadBalancer)WeightedRoundRobinLoadBalancer.this).config.weightUpdatePeriodNanos, TimeUnit.NANOSECONDS, WeightedRoundRobinLoadBalancer.this.timeService);
        }
    }

    @VisibleForTesting
    final class WeightedChildLbState
    extends MultiChildLoadBalancer.ChildLbState {
        private final Set<WrrSubchannel> subchannels;
        private volatile long lastUpdated;
        private volatile long nonEmptySince;
        private volatile double weight;
        private OrcaReportListener orcaReportListener;

        public WeightedChildLbState(Object key, LoadBalancerProvider policyProvider) {
            super(key, policyProvider);
            this.subchannels = new HashSet<WrrSubchannel>();
            this.weight = 0.0;
        }

        @Override
        protected MultiChildLoadBalancer.ChildLbState.ChildLbStateHelper createChildHelper() {
            return new WrrChildLbStateHelper();
        }

        private double getWeight(AtomicInteger staleEndpoints, AtomicInteger notYetUsableEndpoints) {
            if (WeightedRoundRobinLoadBalancer.this.config == null) {
                return 0.0;
            }
            long now = WeightedRoundRobinLoadBalancer.this.ticker.nanoTime();
            if (now - this.lastUpdated >= ((WeightedRoundRobinLoadBalancer)WeightedRoundRobinLoadBalancer.this).config.weightExpirationPeriodNanos) {
                this.nonEmptySince = WeightedRoundRobinLoadBalancer.this.infTime;
                staleEndpoints.incrementAndGet();
                return 0.0;
            }
            if (now - this.nonEmptySince < ((WeightedRoundRobinLoadBalancer)WeightedRoundRobinLoadBalancer.this).config.blackoutPeriodNanos && ((WeightedRoundRobinLoadBalancer)WeightedRoundRobinLoadBalancer.this).config.blackoutPeriodNanos > 0L) {
                notYetUsableEndpoints.incrementAndGet();
                return 0.0;
            }
            return this.weight;
        }

        public void addSubchannel(WrrSubchannel wrrSubchannel) {
            this.subchannels.add(wrrSubchannel);
        }

        public OrcaReportListener getOrCreateOrcaListener(float errorUtilizationPenalty) {
            if (this.orcaReportListener != null && this.orcaReportListener.errorUtilizationPenalty == errorUtilizationPenalty) {
                return this.orcaReportListener;
            }
            this.orcaReportListener = new OrcaReportListener(errorUtilizationPenalty);
            return this.orcaReportListener;
        }

        public void removeSubchannel(WrrSubchannel wrrSubchannel) {
            this.subchannels.remove(wrrSubchannel);
        }

        final class OrcaReportListener
        implements OrcaPerRequestUtil.OrcaPerRequestReportListener,
        OrcaOobUtil.OrcaOobReportListener {
            private final float errorUtilizationPenalty;

            OrcaReportListener(float errorUtilizationPenalty) {
                this.errorUtilizationPenalty = errorUtilizationPenalty;
            }

            @Override
            public void onLoadReport(MetricReport report) {
                double utilization;
                double newWeight = 0.0;
                double d = utilization = report.getApplicationUtilization() > 0.0 ? report.getApplicationUtilization() : report.getCpuUtilization();
                if (utilization > 0.0 && report.getQps() > 0.0) {
                    double penalty = 0.0;
                    if (report.getEps() > 0.0 && this.errorUtilizationPenalty > 0.0f) {
                        penalty = report.getEps() / report.getQps() * (double)this.errorUtilizationPenalty;
                    }
                    newWeight = report.getQps() / (utilization + penalty);
                }
                if (newWeight == 0.0) {
                    return;
                }
                if (WeightedChildLbState.this.nonEmptySince == WeightedRoundRobinLoadBalancer.this.infTime) {
                    WeightedChildLbState.this.nonEmptySince = WeightedRoundRobinLoadBalancer.this.ticker.nanoTime();
                }
                WeightedChildLbState.this.lastUpdated = WeightedRoundRobinLoadBalancer.this.ticker.nanoTime();
                WeightedChildLbState.this.weight = newWeight;
            }
        }

        final class WrrChildLbStateHelper
        extends MultiChildLoadBalancer.ChildLbState.ChildLbStateHelper {
            WrrChildLbStateHelper() {
            }

            @Override
            public LoadBalancer.Subchannel createSubchannel(LoadBalancer.CreateSubchannelArgs args) {
                return new WrrSubchannel(super.createSubchannel(args), WeightedChildLbState.this);
            }

            @Override
            public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
                super.updateBalancingState(newState, newPicker);
                if (!WeightedRoundRobinLoadBalancer.this.resolvingAddresses && newState == ConnectivityState.IDLE) {
                    WeightedChildLbState.this.getLb().requestConnection();
                }
            }
        }
    }
}

