/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.lexicon;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;

public class Keyword {
    private static final String CLASS_KEYWORD = "class";
    private static final ImmutableList<String> KEYWORDS = ImmutableList.of("abstract", "continue", "for", "new", "switch", "assert", "default", "if", "package", "synchronized", "boolean", "do", new String[]{"goto", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"});
    private static final String ESCAPE_CHAR = "_";

    public static boolean isKeyword(String s) {
        return s.equals(CLASS_KEYWORD) || KEYWORDS.contains(s);
    }

    public static String unescapeKeyword(String str) {
        if (Strings.isNullOrEmpty(str)) {
            return str;
        }
        if (!str.endsWith(ESCAPE_CHAR)) {
            return str;
        }
        String strWithoutEscapeChar = str.substring(0, str.lastIndexOf(ESCAPE_CHAR));
        return Keyword.isKeyword(strWithoutEscapeChar) ? strWithoutEscapeChar : str;
    }

    public static String escapeKeyword(String str) {
        return Keyword.isKeyword(str) ? str + ESCAPE_CHAR : str;
    }

    public static boolean isInvalidFieldName(String s) {
        return KEYWORDS.contains(s);
    }
}

