/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.ConnectivityState;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerRegistry;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.ObjectPool;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.xds.CdsLoadBalancerProvider;
import io.grpc.xds.ClusterResolverLoadBalancerProvider;
import io.grpc.xds.InternalXdsAttributes;
import io.grpc.xds.XdsClusterResource;
import io.grpc.xds.client.XdsClient;
import io.grpc.xds.client.XdsLogger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

final class CdsLoadBalancer2
extends LoadBalancer {
    private final XdsLogger logger;
    private final LoadBalancer.Helper helper;
    private final SynchronizationContext syncContext;
    private final LoadBalancerRegistry lbRegistry;
    private ObjectPool<XdsClient> xdsClientPool;
    private XdsClient xdsClient;
    private CdsLbState cdsLbState;
    private LoadBalancer.ResolvedAddresses resolvedAddresses;

    CdsLoadBalancer2(LoadBalancer.Helper helper) {
        this(helper, LoadBalancerRegistry.getDefaultRegistry());
    }

    @VisibleForTesting
    CdsLoadBalancer2(LoadBalancer.Helper helper, LoadBalancerRegistry lbRegistry) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
        this.syncContext = Preconditions.checkNotNull(helper.getSynchronizationContext(), "syncContext");
        this.lbRegistry = Preconditions.checkNotNull(lbRegistry, "lbRegistry");
        this.logger = XdsLogger.withLogId(InternalLogId.allocate("cds-lb", helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created", new Object[0]);
    }

    @Override
    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        if (this.resolvedAddresses != null) {
            return Status.OK;
        }
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        this.resolvedAddresses = resolvedAddresses;
        this.xdsClientPool = resolvedAddresses.getAttributes().get(InternalXdsAttributes.XDS_CLIENT_POOL);
        this.xdsClient = this.xdsClientPool.getObject();
        CdsLoadBalancerProvider.CdsConfig config = (CdsLoadBalancerProvider.CdsConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Config: {0}", config);
        this.cdsLbState = new CdsLbState(config.name);
        this.cdsLbState.start();
        return Status.OK;
    }

    @Override
    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        if (this.cdsLbState != null && this.cdsLbState.childLb != null) {
            this.cdsLbState.childLb.handleNameResolutionError(error);
        } else {
            this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError(error)));
        }
    }

    @Override
    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown", new Object[0]);
        if (this.cdsLbState != null) {
            this.cdsLbState.shutdown();
        }
        if (this.xdsClientPool != null) {
            this.xdsClientPool.returnObject(this.xdsClient);
        }
    }

    private final class CdsLbState {
        private final ClusterState root;
        private final Map<String, ClusterState> clusterStates = new ConcurrentHashMap<String, ClusterState>();
        private LoadBalancer childLb;

        private CdsLbState(String rootCluster) {
            this.root = new ClusterState(rootCluster);
        }

        private void start() {
            this.root.start();
        }

        private void shutdown() {
            this.root.shutdown();
            if (this.childLb != null) {
                this.childLb.shutdown();
            }
        }

        private void handleClusterDiscovered() {
            ArrayList<ClusterResolverLoadBalancerProvider.ClusterResolverConfig.DiscoveryMechanism> instances = new ArrayList<ClusterResolverLoadBalancerProvider.ClusterResolverConfig.DiscoveryMechanism>();
            HashMap<ClusterState, List<ClusterState>> parentClusters = new HashMap<ClusterState, List<ClusterState>>();
            Status loopStatus = null;
            ArrayDeque<ClusterState> queue = new ArrayDeque<ClusterState>();
            queue.add(this.root);
            while (!queue.isEmpty()) {
                int size = queue.size();
                for (int i = 0; i < size; ++i) {
                    ClusterState clusterState = (ClusterState)queue.remove();
                    if (!clusterState.discovered) {
                        return;
                    }
                    if (clusterState.result == null) continue;
                    if (clusterState.isLeaf) {
                        if (!instances.stream().map(inst -> inst.cluster).noneMatch(clusterState.name::equals)) continue;
                        ClusterResolverLoadBalancerProvider.ClusterResolverConfig.DiscoveryMechanism instance = clusterState.result.clusterType() == XdsClusterResource.CdsUpdate.ClusterType.EDS ? ClusterResolverLoadBalancerProvider.ClusterResolverConfig.DiscoveryMechanism.forEds(clusterState.name, clusterState.result.edsServiceName(), clusterState.result.lrsServerInfo(), clusterState.result.maxConcurrentRequests(), clusterState.result.upstreamTlsContext(), clusterState.result.filterMetadata(), clusterState.result.outlierDetection()) : ClusterResolverLoadBalancerProvider.ClusterResolverConfig.DiscoveryMechanism.forLogicalDns(clusterState.name, clusterState.result.dnsHostName(), clusterState.result.lrsServerInfo(), clusterState.result.maxConcurrentRequests(), clusterState.result.upstreamTlsContext(), clusterState.result.filterMetadata());
                        instances.add(instance);
                        continue;
                    }
                    if (clusterState.childClusterStates == null) continue;
                    List<String> namesCausingLoops = this.identifyLoops(clusterState, parentClusters);
                    if (namesCausingLoops.isEmpty()) {
                        queue.addAll(clusterState.childClusterStates.values());
                        continue;
                    }
                    if (this.childLb != null) {
                        this.childLb.shutdown();
                        this.childLb = null;
                    }
                    if (loopStatus != null) {
                        CdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Multiple loops in CDS config.  Old msg:  " + loopStatus.getDescription(), new Object[0]);
                    }
                    loopStatus = Status.UNAVAILABLE.withDescription(String.format("CDS error: circular aggregate clusters directly under %s for root cluster %s, named %s, xDS node ID: %s", clusterState.name, this.root.name, namesCausingLoops, CdsLoadBalancer2.this.xdsClient.getBootstrapInfo().node().getId()));
                }
            }
            if (loopStatus != null) {
                CdsLoadBalancer2.this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError(loopStatus)));
                return;
            }
            if (instances.isEmpty()) {
                if (this.childLb != null) {
                    this.childLb.shutdown();
                    this.childLb = null;
                }
                Status unavailable = Status.UNAVAILABLE.withDescription(String.format("CDS error: found 0 leaf (logical DNS or EDS) clusters for root cluster %s xDS node ID: %s", this.root.name, CdsLoadBalancer2.this.xdsClient.getBootstrapInfo().node().getId()));
                CdsLoadBalancer2.this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError(unavailable)));
                return;
            }
            NameResolver.ConfigOrError configOrError = GracefulSwitchLoadBalancer.parseLoadBalancingPolicyConfig(Arrays.asList(this.root.result.lbPolicyConfig()), CdsLoadBalancer2.this.lbRegistry);
            if (configOrError.getError() != null) {
                throw configOrError.getError().augmentDescription("Unable to parse the LB config").asRuntimeException();
            }
            ClusterResolverLoadBalancerProvider.ClusterResolverConfig config = new ClusterResolverLoadBalancerProvider.ClusterResolverConfig(Collections.unmodifiableList(instances), configOrError.getConfig());
            if (this.childLb == null) {
                this.childLb = CdsLoadBalancer2.this.lbRegistry.getProvider("cluster_resolver_experimental").newLoadBalancer(CdsLoadBalancer2.this.helper);
            }
            this.childLb.handleResolvedAddresses(CdsLoadBalancer2.this.resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig(config).build());
        }

        private List<String> identifyLoops(ClusterState clusterState, Map<ClusterState, List<ClusterState>> parentClusters) {
            HashSet<String> ancestors = new HashSet<String>();
            ancestors.add(clusterState.name);
            this.addAncestors(ancestors, clusterState, parentClusters);
            ArrayList<String> namesCausingLoops = new ArrayList<String>();
            for (ClusterState state : clusterState.childClusterStates.values()) {
                if (!ancestors.contains(state.name)) continue;
                namesCausingLoops.add(state.name);
            }
            clusterState.childClusterStates.values().stream().filter(child -> !namesCausingLoops.contains(((ClusterState)child).name)).forEach(child -> parentClusters.computeIfAbsent((ClusterState)child, k -> new ArrayList()).add(clusterState));
            return namesCausingLoops;
        }

        private void addAncestors(Set<String> ancestors, ClusterState clusterState, Map<ClusterState, List<ClusterState>> parentClusters) {
            List<ClusterState> directParents = parentClusters.get(clusterState);
            if (directParents != null) {
                directParents.stream().map(c -> ((ClusterState)c).name).forEach(ancestors::add);
                directParents.forEach(p -> this.addAncestors(ancestors, (ClusterState)p, parentClusters));
            }
        }

        private void handleClusterDiscoveryError(Status error) {
            String description = error.getDescription() == null ? "" : error.getDescription() + " ";
            Status errorWithNodeId = error.withDescription(description + "xDS node ID: " + CdsLoadBalancer2.this.xdsClient.getBootstrapInfo().node().getId());
            if (this.childLb != null) {
                this.childLb.handleNameResolutionError(errorWithNodeId);
            } else {
                CdsLoadBalancer2.this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError(errorWithNodeId)));
            }
        }

        private final class ClusterState
        implements XdsClient.ResourceWatcher<XdsClusterResource.CdsUpdate> {
            private final String name;
            @Nullable
            private Map<String, ClusterState> childClusterStates;
            @Nullable
            private XdsClusterResource.CdsUpdate result;
            private boolean isLeaf;
            private boolean discovered;
            private boolean shutdown;

            private ClusterState(String name) {
                this.name = name;
            }

            private void start() {
                this.shutdown = false;
                CdsLoadBalancer2.this.xdsClient.watchXdsResource(XdsClusterResource.getInstance(), this.name, this, CdsLoadBalancer2.this.syncContext);
            }

            void shutdown() {
                this.shutdown = true;
                CdsLoadBalancer2.this.xdsClient.cancelXdsResourceWatch(XdsClusterResource.getInstance(), this.name, this);
                if (this.childClusterStates != null) {
                    this.childClusterStates.values().stream().filter(state -> !state.shutdown).forEach(ClusterState::shutdown);
                }
            }

            @Override
            public void onError(Status error) {
                Status status = Status.UNAVAILABLE.withDescription(String.format("Unable to load CDS %s. xDS server returned: %s: %s", new Object[]{this.name, error.getCode(), error.getDescription()})).withCause(error.getCause());
                if (this.shutdown) {
                    return;
                }
                if (this == CdsLbState.this.root) {
                    CdsLbState.this.handleClusterDiscoveryError(status);
                }
            }

            @Override
            public void onResourceDoesNotExist(String resourceName) {
                if (this.shutdown) {
                    return;
                }
                this.discovered = true;
                this.result = null;
                if (this.childClusterStates != null) {
                    for (ClusterState state : this.childClusterStates.values()) {
                        state.shutdown();
                    }
                    this.childClusterStates = null;
                }
                CdsLbState.this.handleClusterDiscovered();
            }

            @Override
            public void onChanged(XdsClusterResource.CdsUpdate update) {
                if (this.shutdown) {
                    return;
                }
                CdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received cluster update {0}", update);
                this.discovered = true;
                this.result = update;
                if (update.clusterType() == XdsClusterResource.CdsUpdate.ClusterType.AGGREGATE) {
                    this.isLeaf = false;
                    CdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Aggregate cluster {0}, underlying clusters: {1}", update.clusterName(), update.prioritizedClusterNames());
                    LinkedHashMap<String, ClusterState> newChildStates = new LinkedHashMap<String, ClusterState>();
                    for (String cluster : update.prioritizedClusterNames()) {
                        if (newChildStates.containsKey(cluster)) {
                            CdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.WARNING, String.format("duplicate cluster name %s in aggregate %s is being ignored", cluster, update.clusterName()), new Object[0]);
                            continue;
                        }
                        if (this.childClusterStates == null || !this.childClusterStates.containsKey(cluster)) {
                            ClusterState childState;
                            if (CdsLbState.this.clusterStates.containsKey(cluster)) {
                                childState = (ClusterState)CdsLbState.this.clusterStates.get(cluster);
                                if (childState.shutdown) {
                                    childState.start();
                                }
                            } else {
                                childState = new ClusterState(cluster);
                                CdsLbState.this.clusterStates.put(cluster, childState);
                                childState.start();
                            }
                            newChildStates.put(cluster, childState);
                            continue;
                        }
                        newChildStates.put(cluster, this.childClusterStates.remove(cluster));
                    }
                    if (this.childClusterStates != null) {
                        for (ClusterState watcher : this.childClusterStates.values()) {
                            watcher.shutdown();
                        }
                    }
                    this.childClusterStates = newChildStates;
                } else if (update.clusterType() == XdsClusterResource.CdsUpdate.ClusterType.EDS) {
                    this.isLeaf = true;
                    CdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "EDS cluster {0}, edsServiceName: {1}", update.clusterName(), update.edsServiceName());
                } else {
                    this.isLeaf = true;
                    CdsLoadBalancer2.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Logical DNS cluster {0}", update.clusterName());
                }
                CdsLbState.this.handleClusterDiscovered();
            }
        }
    }
}

