/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.protoparser;

import com.google.api.RoutingParameter;
import com.google.api.RoutingProto;
import com.google.api.RoutingRule;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.gapic.model.Message;
import com.google.api.generator.gapic.model.RoutingHeaderRule;
import com.google.api.generator.gapic.protoparser.PatternParser;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import java.util.Map;
import java.util.Set;

public class RoutingRuleParser {
    public static RoutingHeaderRule parse(Descriptors.MethodDescriptor protoMethod, Message inputMessage, Map<String, Message> messageTypes) {
        DescriptorProtos.MethodOptions methodOptions = protoMethod.getOptions();
        if (!methodOptions.hasExtension(RoutingProto.routing)) {
            return null;
        }
        RoutingHeaderRule.Builder routingHeaderRuleBuilder = RoutingHeaderRule.builder();
        RoutingRule routingRule = methodOptions.getExtension(RoutingProto.routing);
        for (RoutingParameter routingParameter : routingRule.getRoutingParametersList()) {
            String key;
            String pathTemplate = routingParameter.getPathTemplate();
            String fieldName = routingParameter.getField();
            inputMessage.validateField(fieldName, messageTypes, TypeNode.STRING);
            if (Strings.isNullOrEmpty(pathTemplate)) {
                key = fieldName;
                pathTemplate = String.format("{%s=**}", key);
            } else {
                Set<String> namedSegments = PatternParser.getPatternBindings(pathTemplate);
                Preconditions.checkArgument(namedSegments.size() == 1, String.format("There needs to be one and only one named segment in path template %s", pathTemplate));
                key = namedSegments.iterator().next();
            }
            RoutingHeaderRule.RoutingHeaderParam routingHeaderParam = RoutingHeaderRule.RoutingHeaderParam.create(fieldName, key, pathTemplate);
            routingHeaderRuleBuilder.addParam(routingHeaderParam);
        }
        return routingHeaderRuleBuilder.build();
    }
}

