/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.model;

import com.google.api.generator.engine.ast.ClassDefinition;
import com.google.api.generator.engine.ast.ScopeNode;
import com.google.api.generator.gapic.model.AutoValue_GapicClass;
import com.google.api.generator.gapic.model.Sample;
import com.google.auto.value.AutoValue;
import java.util.Collections;
import java.util.List;

@AutoValue
public abstract class GapicClass {
    public abstract Kind kind();

    public abstract ClassDefinition classDefinition();

    public abstract List<Sample> samples();

    public abstract String apiShortName();

    public abstract String packageVersion();

    public static GapicClass createNonGeneratedGapicClass() {
        return GapicClass.builder().setKind(Kind.NON_GENERATED).setClassDefinition(ClassDefinition.builder().setPackageString("Empty Package").setName("Empty Name").setScope(ScopeNode.PUBLIC).build()).build();
    }

    public static GapicClass create(Kind kind, ClassDefinition classDefinition) {
        return GapicClass.builder().setKind(kind).setClassDefinition(classDefinition).build();
    }

    public static GapicClass create(Kind kind, ClassDefinition classDefinition, List<Sample> samples) {
        return GapicClass.builder().setKind(kind).setClassDefinition(classDefinition).setSamples(samples).build();
    }

    static Builder builder() {
        return new AutoValue_GapicClass.Builder().setSamples(Collections.emptyList()).setApiShortName("").setPackageVersion("");
    }

    abstract Builder toBuilder();

    public final GapicClass withSamples(List<Sample> samples) {
        return this.toBuilder().setSamples(samples).build();
    }

    public final GapicClass withApiShortName(String apiShortName) {
        return this.toBuilder().setApiShortName(apiShortName).build();
    }

    public final GapicClass withPackageVersion(String packageVersion) {
        return this.toBuilder().setPackageVersion(packageVersion).build();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setKind(Kind var1);

        abstract Builder setClassDefinition(ClassDefinition var1);

        abstract Builder setSamples(List<Sample> var1);

        abstract Builder setApiShortName(String var1);

        abstract Builder setPackageVersion(String var1);

        abstract GapicClass build();
    }

    public static enum Kind {
        MAIN,
        STUB,
        TEST,
        PROTO,
        NON_GENERATED;

    }
}

