/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_CastExpr;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;

@AutoValue
public abstract class CastExpr
implements Expr {
    @Override
    public abstract TypeNode type();

    public abstract Expr expr();

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public static Builder builder() {
        return new AutoValue_CastExpr.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setType(TypeNode var1);

        public abstract Builder setExpr(Expr var1);

        abstract CastExpr autoBuild();

        public CastExpr build() {
            CastExpr castExpr = this.autoBuild();
            TypeNode castType = castExpr.type();
            TypeNode exprType = castExpr.expr().type();
            Preconditions.checkState(!castType.equals(TypeNode.VOID) && !exprType.equals(TypeNode.VOID), "Casting cannot be done on or to void types");
            if (castType.isPrimitiveType() && exprType.isPrimitiveType()) {
                Preconditions.checkState(!(castType.equals(TypeNode.BOOLEAN) ^ exprType.equals(TypeNode.BOOLEAN)), "Numeric and boolean types are not inter-castable");
            } else {
                boolean isExprTypeReferenceOrNull = exprType.equals(TypeNode.NULL) || TypeNode.isReferenceType(exprType);
                boolean isValidReferenceTypeCast = TypeNode.isReferenceType(castType) && isExprTypeReferenceOrNull;
                boolean isEqualType = castType.equals(exprType);
                Preconditions.checkState(isEqualType || isValidReferenceTypeCast, "Boxed type and primitive type are inter-castable, otherwise reference types can only be casted to reference types or null type.");
            }
            return castExpr;
        }
    }
}

