/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc.testing;

import com.google.api.core.BetaApi;
import com.google.longrunning.Operation;
import com.google.protobuf.Descriptors;
import com.google.type.Color;
import com.google.type.Money;
import io.grpc.BindableService;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.protobuf.ProtoFileDescriptorSupplier;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;

@BetaApi
public final class FakeServiceGrpc {
    public static final String SERVICE_NAME = "google.gax.FakeService";
    public static final MethodDescriptor<Color, Money> METHOD_RECOGNIZE = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName("google.gax.FakeService", "Recognize")).setRequestMarshaller(ProtoUtils.marshaller(Color.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Money.getDefaultInstance())).build();
    public static final MethodDescriptor<Color, Operation> METHOD_LONG_RUNNING_RECOGNIZE = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName("google.gax.FakeService", "LongRunningRecognize")).setRequestMarshaller(ProtoUtils.marshaller(Color.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Operation.getDefaultInstance())).build();
    public static final MethodDescriptor<Color, Money> METHOD_STREAMING_RECOGNIZE = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName(MethodDescriptor.generateFullMethodName("google.gax.FakeService", "StreamingRecognize")).setRequestMarshaller(ProtoUtils.marshaller(Color.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Money.getDefaultInstance())).build();
    public static final MethodDescriptor<Color, Money> METHOD_STREAMING_RECOGNIZE_ERROR = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName(MethodDescriptor.generateFullMethodName("google.gax.FakeService", "StreamingRecognizeError")).setRequestMarshaller(ProtoUtils.marshaller(Color.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Money.getDefaultInstance())).build();
    public static final MethodDescriptor<Color, Money> METHOD_SERVER_STREAMING_RECOGNIZE = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName(MethodDescriptor.generateFullMethodName("google.gax.FakeService", "ServerStreamingRecognize")).setRequestMarshaller(ProtoUtils.marshaller(Color.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Money.getDefaultInstance())).build();
    public static final MethodDescriptor<Color, Money> METHOD_CLIENT_STREAMING_RECOGNIZE = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.CLIENT_STREAMING).setFullMethodName(MethodDescriptor.generateFullMethodName("google.gax.FakeService", "ClientStreamingRecognize")).setRequestMarshaller(ProtoUtils.marshaller(Color.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Money.getDefaultInstance())).build();
    private static final int METHODID_RECOGNIZE = 0;
    private static final int METHODID_LONG_RUNNING_RECOGNIZE = 1;
    private static final int METHODID_STREAMING_RECOGNIZE = 2;
    private static final int METHODID_STREAMING_RECOGNIZE_ERROR = 3;
    private static final int METHODID_SERVER_STREAMING_RECOGNIZE = 4;
    private static final int METHODID_CLIENT_STREAMING_RECOGNIZE = 5;
    private static volatile ServiceDescriptor serviceDescriptor;

    private FakeServiceGrpc() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServiceDescriptor getServiceDescriptor() {
        ServiceDescriptor result = serviceDescriptor;
        if (result != null) return result;
        Class<FakeServiceGrpc> clazz = FakeServiceGrpc.class;
        synchronized (FakeServiceGrpc.class) {
            result = serviceDescriptor;
            if (result != null) return result;
            serviceDescriptor = result = ServiceDescriptor.newBuilder(SERVICE_NAME).setSchemaDescriptor(new FakeServiceDescriptorSupplier()).addMethod(METHOD_RECOGNIZE).addMethod(METHOD_LONG_RUNNING_RECOGNIZE).addMethod(METHOD_STREAMING_RECOGNIZE).addMethod(METHOD_STREAMING_RECOGNIZE_ERROR).addMethod(METHOD_SERVER_STREAMING_RECOGNIZE).addMethod(METHOD_CLIENT_STREAMING_RECOGNIZE).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    private static final class FakeServiceDescriptorSupplier
    implements ProtoFileDescriptorSupplier {
        private FakeServiceDescriptorSupplier() {
        }

        @Override
        public Descriptors.FileDescriptor getFileDescriptor() {
            return null;
        }
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final FakeServiceImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(FakeServiceImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        @Override
        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    this.serviceImpl.recognize((Color)request, responseObserver);
                    break;
                }
                case 1: {
                    this.serviceImpl.longRunningRecognize((Color)request, responseObserver);
                    break;
                }
                case 4: {
                    this.serviceImpl.serverStreamingRecognize((Color)request, responseObserver);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        @Override
        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 2: {
                    return this.serviceImpl.streamingRecognize(responseObserver);
                }
                case 3: {
                    return this.serviceImpl.streamingRecognizeError(responseObserver);
                }
                case 5: {
                    return this.serviceImpl.clientStreamingRecognize(responseObserver);
                }
            }
            throw new AssertionError();
        }
    }

    public static abstract class FakeServiceImplBase
    implements BindableService {
        public void recognize(Color request, StreamObserver<Money> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_RECOGNIZE, responseObserver);
        }

        public void longRunningRecognize(Color request, StreamObserver<Operation> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_LONG_RUNNING_RECOGNIZE, responseObserver);
        }

        public StreamObserver<Color> streamingRecognize(StreamObserver<Money> responseObserver) {
            return ServerCalls.asyncUnimplementedStreamingCall(METHOD_STREAMING_RECOGNIZE, responseObserver);
        }

        public StreamObserver<Color> streamingRecognizeError(StreamObserver<Money> responseObserver) {
            return ServerCalls.asyncUnimplementedStreamingCall(METHOD_STREAMING_RECOGNIZE_ERROR, responseObserver);
        }

        public void serverStreamingRecognize(Color request, StreamObserver<Money> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_SERVER_STREAMING_RECOGNIZE, responseObserver);
        }

        public StreamObserver<Color> clientStreamingRecognize(StreamObserver<Money> responseObserver) {
            return ServerCalls.asyncUnimplementedStreamingCall(METHOD_CLIENT_STREAMING_RECOGNIZE, responseObserver);
        }

        @Override
        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder(FakeServiceGrpc.getServiceDescriptor()).addMethod(METHOD_RECOGNIZE, ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0))).addMethod(METHOD_LONG_RUNNING_RECOGNIZE, ServerCalls.asyncUnaryCall(new MethodHandlers(this, 1))).addMethod(METHOD_STREAMING_RECOGNIZE, ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 2))).addMethod(METHOD_STREAMING_RECOGNIZE_ERROR, ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 3))).addMethod(METHOD_SERVER_STREAMING_RECOGNIZE, ServerCalls.asyncServerStreamingCall(new MethodHandlers(this, 4))).addMethod(METHOD_CLIENT_STREAMING_RECOGNIZE, ServerCalls.asyncClientStreamingCall(new MethodHandlers(this, 5))).build();
        }
    }
}

