/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.CallOptions;
import io.grpc.ChannelCredentials;
import io.grpc.ClientCall;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.XdsTransportFactory;
import java.util.concurrent.TimeUnit;

final class GrpcXdsTransportFactory
implements XdsTransportFactory {
    static final GrpcXdsTransportFactory DEFAULT_XDS_TRANSPORT_FACTORY = new GrpcXdsTransportFactory();

    GrpcXdsTransportFactory() {
    }

    @Override
    public XdsTransportFactory.XdsTransport create(Bootstrapper.ServerInfo serverInfo) {
        return new GrpcXdsTransport(serverInfo);
    }

    @VisibleForTesting
    public XdsTransportFactory.XdsTransport createForTest(ManagedChannel channel) {
        return new GrpcXdsTransport(channel);
    }

    private static class EventHandlerToCallListenerAdapter<T>
    extends ClientCall.Listener<T> {
        private final XdsTransportFactory.EventHandler<T> handler;

        EventHandlerToCallListenerAdapter(XdsTransportFactory.EventHandler<T> eventHandler) {
            this.handler = Preconditions.checkNotNull(eventHandler, "eventHandler");
        }

        @Override
        public void onHeaders(Metadata headers) {
        }

        @Override
        public void onMessage(T message) {
            this.handler.onRecvMessage(message);
        }

        @Override
        public void onClose(Status status, Metadata trailers) {
            this.handler.onStatusReceived(status);
        }

        @Override
        public void onReady() {
            this.handler.onReady();
        }
    }

    @VisibleForTesting
    static class GrpcXdsTransport
    implements XdsTransportFactory.XdsTransport {
        private final ManagedChannel channel;

        public GrpcXdsTransport(Bootstrapper.ServerInfo serverInfo) {
            String target = serverInfo.target();
            ChannelCredentials channelCredentials = serverInfo.channelCredentials();
            this.channel = ((ManagedChannelBuilder)Grpc.newChannelBuilder(target, channelCredentials).keepAliveTime(5L, TimeUnit.MINUTES)).build();
        }

        @VisibleForTesting
        public GrpcXdsTransport(ManagedChannel channel) {
            this.channel = Preconditions.checkNotNull(channel, "channel");
        }

        @Override
        public <ReqT, RespT> XdsTransportFactory.StreamingCall<ReqT, RespT> createStreamingCall(String fullMethodName, MethodDescriptor.Marshaller<ReqT> reqMarshaller, MethodDescriptor.Marshaller<RespT> respMarshaller) {
            return new XdsStreamingCall<ReqT, RespT>(fullMethodName, reqMarshaller, respMarshaller);
        }

        @Override
        public void shutdown() {
            this.channel.shutdown();
        }

        private class XdsStreamingCall<ReqT, RespT>
        implements XdsTransportFactory.StreamingCall<ReqT, RespT> {
            private final ClientCall<ReqT, RespT> call;

            public XdsStreamingCall(String methodName, MethodDescriptor.Marshaller<ReqT> reqMarshaller, MethodDescriptor.Marshaller<RespT> respMarshaller) {
                this.call = GrpcXdsTransport.this.channel.newCall(MethodDescriptor.newBuilder().setFullMethodName(methodName).setType(MethodDescriptor.MethodType.BIDI_STREAMING).setRequestMarshaller(reqMarshaller).setResponseMarshaller(respMarshaller).build(), CallOptions.DEFAULT);
            }

            @Override
            public void start(XdsTransportFactory.EventHandler<RespT> eventHandler) {
                this.call.start(new EventHandlerToCallListenerAdapter<RespT>(eventHandler), new Metadata());
                this.call.request(1);
            }

            @Override
            public void sendMessage(ReqT message) {
                this.call.sendMessage(message);
            }

            @Override
            public void startRecvMessage() {
                this.call.request(1);
            }

            @Override
            public void sendError(Exception e) {
                this.call.cancel("Cancelled by XdsClientImpl", e);
            }

            @Override
            public boolean isReady() {
                return this.call.isReady();
            }
        }
    }
}

