/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.util;

import com.google.api.generator.util.TriFunction;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public class Trie<T> {
    private final Node<T> root = new Node();

    public void insert(List<T> word) {
        Map children = this.root.children;
        for (int i = 0; i < word.size(); ++i) {
            Node<Object> t2;
            T chr = word.get(i);
            if (children.containsKey(chr)) {
                t2 = children.get(chr);
            } else {
                t2 = new Node<T>(chr);
                children.put(chr, t2);
            }
            children = t2.children;
            if (i != word.size() - 1) continue;
            t2.isLeaf = true;
        }
    }

    public boolean search(List<T> word) {
        Node<T> node = this.searchNode(word);
        return node != null && node.isLeaf;
    }

    public boolean hasPrefix(List<T> prefix) {
        return this.searchNode(prefix) != null;
    }

    public <R> R dfsTraverseAndReduce(Function<T, R> parentPreprocFn, TriFunction<T, R, R, R> parentPostprocFn, BiFunction<T, R, R> leafReduceFn, R baseValue) {
        return this.dfsTraverseAndReduce(this.root, parentPreprocFn, parentPostprocFn, leafReduceFn, baseValue);
    }

    private <R> R dfsTraverseAndReduce(Node<T> node, Function<T, R> parentPreprocFn, TriFunction<T, R, R, R> parentPostprocFn, BiFunction<T, R, R> leafReduceFn, R baseValue) {
        if (node.isLeaf) {
            return leafReduceFn.apply(node.chr, baseValue);
        }
        R leafReducedValue = node.chr == null ? baseValue : parentPreprocFn.apply(node.chr);
        for (Map.Entry e : node.children.entrySet()) {
            leafReducedValue = this.dfsTraverseAndReduce(e.getValue(), parentPreprocFn, parentPostprocFn, leafReduceFn, leafReducedValue);
        }
        return parentPostprocFn.apply(node.chr, baseValue, leafReducedValue);
    }

    private Node<T> searchNode(List<T> word) {
        Map children = this.root.children;
        Node t2 = null;
        for (T chr : word) {
            if (children.containsKey(chr)) {
                t2 = children.get(chr);
                children = t2.children;
                continue;
            }
            return null;
        }
        return t2;
    }

    private static class Node<U> {
        final U chr;
        Map<U, Node<U>> children = new LinkedHashMap<U, Node<U>>();
        boolean isLeaf;

        Node() {
            this.chr = null;
        }

        Node(U chr) {
            this.chr = chr;
        }
    }
}

