/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.composer.grpc;

import com.google.api.generator.engine.ast.ConcreteReference;
import com.google.api.generator.engine.ast.MethodDefinition;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.gapic.composer.common.AbstractServiceCallableFactoryClassComposer;
import com.google.api.generator.gapic.composer.grpc.GrpcContext;
import com.google.api.generator.gapic.composer.store.TypeStore;
import com.google.api.generator.gapic.model.Service;
import com.google.longrunning.Operation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class GrpcServiceCallableFactoryClassComposer
extends AbstractServiceCallableFactoryClassComposer {
    private static final GrpcServiceCallableFactoryClassComposer INSTANCE = new GrpcServiceCallableFactoryClassComposer();
    private static final TypeNode OPERATION_TYPE = TypeNode.withReference(ConcreteReference.withClazz(Operation.class));

    protected GrpcServiceCallableFactoryClassComposer() {
        super(GrpcContext.instance());
    }

    public static GrpcServiceCallableFactoryClassComposer instance() {
        return INSTANCE;
    }

    @Override
    protected List<TypeNode> createClassImplements(Service service, TypeStore typeStore) {
        return Arrays.asList(this.getTransportContext().stubCallableFactoryType());
    }

    @Override
    protected List<MethodDefinition> createClassMethods(Service service, TypeStore typeStore) {
        ArrayList<MethodDefinition> classMethods = new ArrayList<MethodDefinition>(super.createClassMethods(service, typeStore));
        classMethods.addAll(Arrays.asList(this.createBidiStreamingCallableMethod(service, typeStore), this.createServerStreamingCallableMethod(service, typeStore), this.createClientStreamingCallableMethod(service, typeStore)));
        return classMethods;
    }

    @Override
    protected MethodDefinition createUnaryCallableMethod(Service service, TypeStore typeStore) {
        String methodVariantName = "Unary";
        String requestTemplateName = "RequestT";
        String responseTemplateName = "ResponseT";
        List<String> methodTemplateNames = Arrays.asList(requestTemplateName, responseTemplateName);
        return this.createGenericCallableMethod(service, typeStore, methodTemplateNames, methodVariantName, methodTemplateNames, methodVariantName, methodTemplateNames.stream().map(n -> n).collect(Collectors.toList()), methodVariantName, methodTemplateNames.stream().map(n -> n).collect(Collectors.toList()));
    }

    @Override
    protected MethodDefinition createPagedCallableMethod(Service service, TypeStore typeStore) {
        String methodVariantName = "Paged";
        String requestTemplateName = "RequestT";
        String pagedResponseTemplateName = "PagedListResponseT";
        String responseTemplateName = "ResponseT";
        List<String> methodTemplateNames = Arrays.asList(requestTemplateName, responseTemplateName, pagedResponseTemplateName);
        return this.createGenericCallableMethod(service, typeStore, methodTemplateNames, "Unary", Arrays.asList(requestTemplateName, pagedResponseTemplateName), methodVariantName, Arrays.asList(requestTemplateName, responseTemplateName), methodVariantName, methodTemplateNames.stream().map(n -> n).collect(Collectors.toList()));
    }

    @Override
    protected MethodDefinition createOperationCallableMethod(Service service, TypeStore typeStore) {
        String methodVariantName = "Operation";
        String requestTemplateName = "RequestT";
        String responseTemplateName = "ResponseT";
        List<String> methodTemplateNames = Arrays.asList(requestTemplateName, responseTemplateName, "MetadataT");
        return this.createGenericCallableMethod(service, typeStore, methodTemplateNames, methodVariantName, methodTemplateNames, methodVariantName, Arrays.asList(requestTemplateName, OPERATION_TYPE), methodVariantName, methodTemplateNames.stream().map(n -> n).collect(Collectors.toList()));
    }

    private MethodDefinition createBidiStreamingCallableMethod(Service service, TypeStore typeStore) {
        String methodVariantName = "BidiStreaming";
        String requestTemplateName = "RequestT";
        String responseTemplateName = "ResponseT";
        List<String> methodTemplateNames = Arrays.asList(requestTemplateName, responseTemplateName);
        return this.createGenericCallableMethod(service, typeStore, methodTemplateNames, methodVariantName, methodTemplateNames, methodVariantName, methodTemplateNames.stream().map(n -> n).collect(Collectors.toList()), "Streaming", methodTemplateNames.stream().map(n -> n).collect(Collectors.toList()));
    }

    private MethodDefinition createClientStreamingCallableMethod(Service service, TypeStore typeStore) {
        String methodVariantName = "ClientStreaming";
        String requestTemplateName = "RequestT";
        String responseTemplateName = "ResponseT";
        List<String> methodTemplateNames = Arrays.asList(requestTemplateName, responseTemplateName);
        return this.createGenericCallableMethod(service, typeStore, methodTemplateNames, methodVariantName, methodTemplateNames, methodVariantName, methodTemplateNames.stream().map(n -> n).collect(Collectors.toList()), "Streaming", methodTemplateNames.stream().map(n -> n).collect(Collectors.toList()));
    }
}

