/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_UnaryOperationExpr;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.OperationExpr;
import com.google.api.generator.engine.ast.OperatorKind;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.VariableExpr;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;

@AutoValue
public abstract class UnaryOperationExpr
implements OperationExpr {
    public abstract Expr expr();

    @Override
    public abstract OperatorKind operatorKind();

    @Override
    public abstract TypeNode type();

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public boolean isPostfixIncrement() {
        return this.operatorKind().equals((Object)OperatorKind.UNARY_POST_INCREMENT);
    }

    public static UnaryOperationExpr postfixIncrementWithExpr(Expr expr) {
        return UnaryOperationExpr.builder().setExpr(expr).setOperatorKind(OperatorKind.UNARY_POST_INCREMENT).setType(expr.type()).build();
    }

    public static UnaryOperationExpr logicalNotWithExpr(Expr expr) {
        return UnaryOperationExpr.builder().setOperatorKind(OperatorKind.UNARY_LOGICAL_NOT).setExpr(expr).setType(TypeNode.BOOLEAN).build();
    }

    private static Builder builder() {
        return new AutoValue_UnaryOperationExpr.Builder();
    }

    private static boolean isValidLogicalNotType(TypeNode exprType) {
        return exprType.equals(TypeNode.BOOLEAN);
    }

    private static boolean isValidIncrementType(TypeNode exprType) {
        return TypeNode.isNumericType(exprType);
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setExpr(Expr var1);

        abstract Builder setOperatorKind(OperatorKind var1);

        abstract Builder setType(TypeNode var1);

        abstract UnaryOperationExpr autoBuild();

        private UnaryOperationExpr build() {
            UnaryOperationExpr unaryOperationExpr = this.autoBuild();
            TypeNode exprType = unaryOperationExpr.expr().type();
            OperatorKind operator = unaryOperationExpr.operatorKind();
            if (operator.equals((Object)OperatorKind.UNARY_POST_INCREMENT) && unaryOperationExpr.expr() instanceof VariableExpr) {
                VariableExpr varExpr = (VariableExpr)unaryOperationExpr.expr();
                Preconditions.checkState(!varExpr.isFinal(), String.format("Cannot increment the final variable '%s'.", varExpr.variable().name()));
                Preconditions.checkState(!varExpr.isDecl(), String.format("Cannot increment the declaration of variable %s", varExpr.variable().name()));
            }
            String errorMsg = String.format("Unary operator %s can not be applied to %s. ", new Object[]{operator, exprType.toString()});
            Preconditions.checkState(!exprType.equals(TypeNode.VOID) && !exprType.equals(TypeNode.NULL), errorMsg);
            if (operator.equals((Object)OperatorKind.UNARY_LOGICAL_NOT)) {
                Preconditions.checkState(UnaryOperationExpr.isValidLogicalNotType(exprType), errorMsg);
            }
            if (operator.equals((Object)OperatorKind.UNARY_POST_INCREMENT)) {
                Preconditions.checkState(UnaryOperationExpr.isValidIncrementType(exprType), errorMsg);
            }
            return unaryOperationExpr;
        }
    }
}

