/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_EnumRefExpr;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.IdentifierNode;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;

@AutoValue
public abstract class EnumRefExpr
implements Expr {
    public abstract IdentifierNode identifier();

    @Override
    public abstract TypeNode type();

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    abstract String name();

    public static Builder builder() {
        return new AutoValue_EnumRefExpr.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setType(TypeNode var1);

        public abstract Builder setName(String var1);

        abstract String name();

        abstract Builder setIdentifier(IdentifierNode var1);

        abstract EnumRefExpr autoBuild();

        public EnumRefExpr build() {
            this.setIdentifier(IdentifierNode.builder().setName(this.name()).build());
            EnumRefExpr enumRefExpr = this.autoBuild();
            Preconditions.checkState(TypeNode.isReferenceType(enumRefExpr.type()), "Enum reference type must be a reference type");
            return enumRefExpr;
        }
    }
}

