/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.code;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.openjdk.javax.lang.model.element.Element;
import org.openjdk.javax.lang.model.element.ElementKind;
import org.openjdk.javax.lang.model.element.ElementVisitor;
import org.openjdk.javax.lang.model.element.ExecutableElement;
import org.openjdk.javax.lang.model.element.Modifier;
import org.openjdk.javax.lang.model.element.ModuleElement;
import org.openjdk.javax.lang.model.element.NestingKind;
import org.openjdk.javax.lang.model.element.PackageElement;
import org.openjdk.javax.lang.model.element.TypeElement;
import org.openjdk.javax.lang.model.element.TypeParameterElement;
import org.openjdk.javax.lang.model.element.VariableElement;
import org.openjdk.javax.tools.JavaFileManager;
import org.openjdk.javax.tools.JavaFileObject;
import org.openjdk.tools.javac.code.AnnoConstruct;
import org.openjdk.tools.javac.code.Attribute;
import org.openjdk.tools.javac.code.ClassFinder;
import org.openjdk.tools.javac.code.Directive;
import org.openjdk.tools.javac.code.Flags;
import org.openjdk.tools.javac.code.Kinds;
import org.openjdk.tools.javac.code.Scope;
import org.openjdk.tools.javac.code.SymbolMetadata;
import org.openjdk.tools.javac.code.TargetType;
import org.openjdk.tools.javac.code.Type;
import org.openjdk.tools.javac.code.TypeTag;
import org.openjdk.tools.javac.code.Types;
import org.openjdk.tools.javac.comp.Annotate;
import org.openjdk.tools.javac.comp.Attr;
import org.openjdk.tools.javac.comp.AttrContext;
import org.openjdk.tools.javac.comp.Env;
import org.openjdk.tools.javac.jvm.Code;
import org.openjdk.tools.javac.jvm.Pool;
import org.openjdk.tools.javac.tree.JCTree;
import org.openjdk.tools.javac.util.Assert;
import org.openjdk.tools.javac.util.Constants;
import org.openjdk.tools.javac.util.Filter;
import org.openjdk.tools.javac.util.JCDiagnostic;
import org.openjdk.tools.javac.util.ListBuffer;
import org.openjdk.tools.javac.util.Log;
import org.openjdk.tools.javac.util.Name;

public abstract class Symbol
extends AnnoConstruct
implements Element {
    public Kinds.Kind kind;
    public long flags_field;
    public Name name;
    public Type type;
    public Symbol owner;
    public Completer completer;
    public Type erasure_field;
    protected SymbolMetadata metadata;

    public long flags() {
        return this.flags_field;
    }

    public org.openjdk.tools.javac.util.List<Attribute.Compound> getRawAttributes() {
        return this.metadata == null ? org.openjdk.tools.javac.util.List.nil() : this.metadata.getDeclarationAttributes();
    }

    public org.openjdk.tools.javac.util.List<Attribute.TypeCompound> getRawTypeAttributes() {
        return this.metadata == null ? org.openjdk.tools.javac.util.List.nil() : this.metadata.getTypeAttributes();
    }

    public Attribute.Compound attribute(Symbol symbol) {
        for (Attribute.Compound compound : this.getRawAttributes()) {
            if (compound.type.tsym != symbol) continue;
            return compound;
        }
        return null;
    }

    public boolean annotationsPendingCompletion() {
        return this.metadata == null ? false : this.metadata.pendingCompletion();
    }

    public void appendAttributes(org.openjdk.tools.javac.util.List<Attribute.Compound> list) {
        if (list.nonEmpty()) {
            this.initedMetadata().append(list);
        }
    }

    public void appendClassInitTypeAttributes(org.openjdk.tools.javac.util.List<Attribute.TypeCompound> list) {
        if (list.nonEmpty()) {
            this.initedMetadata().appendClassInitTypeAttributes(list);
        }
    }

    public void appendInitTypeAttributes(org.openjdk.tools.javac.util.List<Attribute.TypeCompound> list) {
        if (list.nonEmpty()) {
            this.initedMetadata().appendInitTypeAttributes(list);
        }
    }

    public void appendUniqueTypeAttributes(org.openjdk.tools.javac.util.List<Attribute.TypeCompound> list) {
        if (list.nonEmpty()) {
            this.initedMetadata().appendUniqueTypes(list);
        }
    }

    public org.openjdk.tools.javac.util.List<Attribute.TypeCompound> getClassInitTypeAttributes() {
        return this.metadata == null ? org.openjdk.tools.javac.util.List.nil() : this.metadata.getClassInitTypeAttributes();
    }

    public org.openjdk.tools.javac.util.List<Attribute.TypeCompound> getInitTypeAttributes() {
        return this.metadata == null ? org.openjdk.tools.javac.util.List.nil() : this.metadata.getInitTypeAttributes();
    }

    public void setInitTypeAttributes(org.openjdk.tools.javac.util.List<Attribute.TypeCompound> list) {
        this.initedMetadata().setInitTypeAttributes(list);
    }

    public void setClassInitTypeAttributes(org.openjdk.tools.javac.util.List<Attribute.TypeCompound> list) {
        this.initedMetadata().setClassInitTypeAttributes(list);
    }

    public org.openjdk.tools.javac.util.List<Attribute.Compound> getDeclarationAttributes() {
        return this.metadata == null ? org.openjdk.tools.javac.util.List.nil() : this.metadata.getDeclarationAttributes();
    }

    public boolean hasAnnotations() {
        return this.metadata != null && !this.metadata.isEmpty();
    }

    public boolean hasTypeAnnotations() {
        return this.metadata != null && !this.metadata.isTypesEmpty();
    }

    public boolean isCompleted() {
        return this.completer.isTerminal();
    }

    public void prependAttributes(org.openjdk.tools.javac.util.List<Attribute.Compound> list) {
        if (list.nonEmpty()) {
            this.initedMetadata().prepend(list);
        }
    }

    public void resetAnnotations() {
        this.initedMetadata().reset();
    }

    public void setAttributes(Symbol symbol) {
        if (this.metadata != null || symbol.metadata != null) {
            this.initedMetadata().setAttributes(symbol.metadata);
        }
    }

    public void setDeclarationAttributes(org.openjdk.tools.javac.util.List<Attribute.Compound> list) {
        if (this.metadata != null || list.nonEmpty()) {
            this.initedMetadata().setDeclarationAttributes(list);
        }
    }

    public void setTypeAttributes(org.openjdk.tools.javac.util.List<Attribute.TypeCompound> list) {
        if (this.metadata != null || list.nonEmpty()) {
            if (this.metadata == null) {
                this.metadata = new SymbolMetadata(this);
            }
            this.metadata.setTypeAttributes(list);
        }
    }

    private SymbolMetadata initedMetadata() {
        if (this.metadata == null) {
            this.metadata = new SymbolMetadata(this);
        }
        return this.metadata;
    }

    public SymbolMetadata getMetadata() {
        return this.metadata;
    }

    public Symbol(Kinds.Kind kind, long l, Name name, Type type, Symbol symbol) {
        this.kind = kind;
        this.flags_field = l;
        this.type = type;
        this.owner = symbol;
        this.completer = Completer.NULL_COMPLETER;
        this.erasure_field = null;
        this.name = name;
    }

    public Symbol clone(Symbol symbol) {
        throw new AssertionError();
    }

    public <R, P> R accept(Visitor<R, P> visitor, P p) {
        return visitor.visitSymbol(this, p);
    }

    public String toString() {
        return this.name.toString();
    }

    public Symbol location() {
        if (this.owner.name == null || this.owner.name.isEmpty() && (this.owner.flags() & 0x100000L) == 0L && this.owner.kind != Kinds.Kind.PCK && this.owner.kind != Kinds.Kind.TYP) {
            return null;
        }
        return this.owner;
    }

    public Symbol location(Type type, Types types) {
        Type type2;
        if (this.owner.name == null || this.owner.name.isEmpty()) {
            return this.location();
        }
        if (this.owner.type.hasTag(TypeTag.CLASS) && (type2 = types.asOuterSuper(type, this.owner)) != null) {
            return type2.tsym;
        }
        return this.owner;
    }

    public Symbol baseSymbol() {
        return this;
    }

    public Type erasure(Types types) {
        if (this.erasure_field == null) {
            this.erasure_field = types.erasure(this.type);
        }
        return this.erasure_field;
    }

    public Type externalType(Types types) {
        Type type = this.erasure(types);
        if (this.name == this.name.table.names.init && this.owner.hasOuterInstance()) {
            Type type2 = types.erasure(this.owner.type.getEnclosingType());
            return new Type.MethodType(type.getParameterTypes().prepend(type2), type.getReturnType(), type.getThrownTypes(), type.tsym);
        }
        return type;
    }

    public boolean isDeprecated() {
        return (this.flags_field & 0x20000L) != 0L;
    }

    public boolean hasDeprecatedAnnotation() {
        return (this.flags_field & 0x40000000000000L) != 0L;
    }

    public boolean isDeprecatedForRemoval() {
        return (this.flags_field & 0x80000000000000L) != 0L;
    }

    public boolean isDeprecatableViaAnnotation() {
        switch (this.getKind()) {
            case LOCAL_VARIABLE: 
            case PACKAGE: 
            case PARAMETER: 
            case RESOURCE_VARIABLE: 
            case EXCEPTION_PARAMETER: {
                return false;
            }
        }
        return true;
    }

    public boolean isStatic() {
        return (this.flags() & 8L) != 0L || (this.owner.flags() & 0x200L) != 0L && this.kind != Kinds.Kind.MTH && this.name != this.name.table.names._this;
    }

    public boolean isInterface() {
        return (this.flags() & 0x200L) != 0L;
    }

    public boolean isPrivate() {
        return (this.flags_field & 7L) == 2L;
    }

    public boolean isEnum() {
        return (this.flags() & 0x4000L) != 0L;
    }

    public boolean isLocal() {
        return this.owner.kind.matches(Kinds.KindSelector.VAL_MTH) || this.owner.kind == Kinds.Kind.TYP && this.owner.isLocal();
    }

    public boolean isAnonymous() {
        return this.name.isEmpty();
    }

    public boolean isConstructor() {
        return this.name == this.name.table.names.init;
    }

    public Name getQualifiedName() {
        return this.name;
    }

    public Name flatName() {
        return this.getQualifiedName();
    }

    public Scope.WriteableScope members() {
        return null;
    }

    public boolean isInner() {
        return this.kind == Kinds.Kind.TYP && this.type.getEnclosingType().hasTag(TypeTag.CLASS);
    }

    public boolean hasOuterInstance() {
        return this.type.getEnclosingType().hasTag(TypeTag.CLASS) && (this.flags() & 0x400200L) == 0L;
    }

    public ClassSymbol enclClass() {
        Symbol symbol = this;
        while (!(symbol == null || symbol.kind.matches(Kinds.KindSelector.TYP) && symbol.type.hasTag(TypeTag.CLASS))) {
            symbol = symbol.owner;
        }
        return (ClassSymbol)symbol;
    }

    public ClassSymbol outermostClass() {
        Symbol symbol = this;
        Symbol symbol2 = null;
        while (symbol.kind != Kinds.Kind.PCK) {
            symbol2 = symbol;
            symbol = symbol.owner;
        }
        return (ClassSymbol)symbol2;
    }

    public PackageSymbol packge() {
        Symbol symbol = this;
        while (symbol.kind != Kinds.Kind.PCK) {
            symbol = symbol.owner;
        }
        return (PackageSymbol)symbol;
    }

    public boolean isSubClass(Symbol symbol, Types types) {
        throw new AssertionError((Object)("isSubClass " + this));
    }

    public boolean isMemberOf(TypeSymbol typeSymbol, Types types) {
        return this.owner == typeSymbol || typeSymbol.isSubClass(this.owner, types) && this.isInheritedIn(typeSymbol, types) && !this.hiddenIn((ClassSymbol)typeSymbol, types);
    }

    public boolean isEnclosedBy(ClassSymbol classSymbol) {
        Symbol symbol = this;
        while (symbol.kind != Kinds.Kind.PCK) {
            if (symbol == classSymbol) {
                return true;
            }
            symbol = symbol.owner;
        }
        return false;
    }

    private boolean hiddenIn(ClassSymbol classSymbol, Types types) {
        Symbol symbol = this.hiddenInInternal(classSymbol, types);
        Assert.check(symbol != null, "the result of hiddenInInternal() can't be null");
        return symbol != this;
    }

    private Symbol hiddenInInternal(ClassSymbol classSymbol, Types types) {
        if (classSymbol == this.owner) {
            return this;
        }
        for (Symbol object : classSymbol.members().getSymbolsByName(this.name)) {
            if (object.kind != this.kind || this.kind == Kinds.Kind.MTH && ((object.flags() & 8L) == 0L || !types.isSubSignature(object.type, this.type))) continue;
            return object;
        }
        Object object = null;
        for (Type type : types.interfaces(classSymbol.type).prepend(types.supertype(classSymbol.type))) {
            if (type == null || !type.hasTag(TypeTag.CLASS)) continue;
            Symbol symbol = this.hiddenInInternal((ClassSymbol)type.tsym, types);
            if (symbol == this) {
                return this;
            }
            if (symbol == null) continue;
            object = symbol;
        }
        return object;
    }

    public boolean isInheritedIn(Symbol symbol, Types types) {
        switch ((int)(this.flags_field & 7L)) {
            default: {
                return true;
            }
            case 2: {
                return this.owner == symbol;
            }
            case 4: {
                return (symbol.flags() & 0x200L) == 0L;
            }
            case 0: 
        }
        PackageSymbol packageSymbol = this.packge();
        Symbol symbol2 = symbol;
        while (symbol2 != null && symbol2 != this.owner) {
            while (symbol2.type.hasTag(TypeTag.TYPEVAR)) {
                symbol2 = symbol2.type.getUpperBound().tsym;
            }
            if (symbol2.type.isErroneous()) {
                return true;
            }
            if ((symbol2.flags() & 0x1000000L) == 0L && symbol2.packge() != packageSymbol) {
                return false;
            }
            symbol2 = types.supertype((Type)symbol2.type).tsym;
        }
        return (symbol.flags() & 0x200L) == 0L;
    }

    public Symbol asMemberOf(Type type, Types types) {
        throw new AssertionError();
    }

    public boolean overrides(Symbol symbol, TypeSymbol typeSymbol, Types types, boolean bl) {
        return false;
    }

    public void complete() throws CompletionFailure {
        if (this.completer != Completer.NULL_COMPLETER) {
            Completer completer = this.completer;
            this.completer = Completer.NULL_COMPLETER;
            completer.complete(this);
        }
    }

    public boolean exists() {
        return true;
    }

    @Override
    public Type asType() {
        return this.type;
    }

    @Override
    public Symbol getEnclosingElement() {
        return this.owner;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.OTHER;
    }

    @Override
    public Set<Modifier> getModifiers() {
        return Flags.asModifierSet(this.flags());
    }

    @Override
    public Name getSimpleName() {
        return this.name;
    }

    @Override
    public org.openjdk.tools.javac.util.List<Attribute.Compound> getAnnotationMirrors() {
        return this.getRawAttributes();
    }

    public List<Symbol> getEnclosedElements() {
        return org.openjdk.tools.javac.util.List.nil();
    }

    public org.openjdk.tools.javac.util.List<TypeVariableSymbol> getTypeParameters() {
        ListBuffer<TypeVariableSymbol> listBuffer = new ListBuffer<TypeVariableSymbol>();
        for (Type type : this.type.getTypeArguments()) {
            Assert.check(type.tsym.getKind() == ElementKind.TYPE_PARAMETER);
            listBuffer.append((TypeVariableSymbol)type.tsym);
        }
        return listBuffer.toList();
    }

    public static interface Visitor<R, P> {
        public R visitClassSymbol(ClassSymbol var1, P var2);

        public R visitMethodSymbol(MethodSymbol var1, P var2);

        public R visitPackageSymbol(PackageSymbol var1, P var2);

        public R visitOperatorSymbol(OperatorSymbol var1, P var2);

        public R visitVarSymbol(VarSymbol var1, P var2);

        public R visitTypeSymbol(TypeSymbol var1, P var2);

        public R visitSymbol(Symbol var1, P var2);
    }

    public static class CompletionFailure
    extends RuntimeException {
        private static final long serialVersionUID = 0L;
        public Symbol sym;
        public JCDiagnostic diag;
        @Deprecated
        public String errmsg;

        public CompletionFailure(Symbol symbol, String string) {
            this.sym = symbol;
            this.errmsg = string;
        }

        public CompletionFailure(Symbol symbol, JCDiagnostic jCDiagnostic) {
            this.sym = symbol;
            this.diag = jCDiagnostic;
        }

        public JCDiagnostic getDiagnostic() {
            return this.diag;
        }

        @Override
        public String getMessage() {
            if (this.diag != null) {
                return this.diag.getMessage(null);
            }
            return this.errmsg;
        }

        public Object getDetailValue() {
            return this.diag != null ? this.diag : this.errmsg;
        }

        @Override
        public CompletionFailure initCause(Throwable throwable) {
            super.initCause(throwable);
            return this;
        }
    }

    public static interface Completer {
        public static final Completer NULL_COMPLETER = new Completer(){

            @Override
            public void complete(Symbol symbol) {
            }

            @Override
            public boolean isTerminal() {
                return true;
            }
        };

        public void complete(Symbol var1) throws CompletionFailure;

        default public boolean isTerminal() {
            return false;
        }
    }

    public static class OperatorSymbol
    extends MethodSymbol {
        public int opcode;
        private int accessCode = Integer.MIN_VALUE;

        public OperatorSymbol(Name name, Type type, int n, Symbol symbol) {
            super(9L, name, type, symbol);
            this.opcode = n;
        }

        @Override
        public <R, P> R accept(Visitor<R, P> visitor, P p) {
            return visitor.visitOperatorSymbol(this, p);
        }

        public int getAccessCode(JCTree.Tag tag) {
            if (this.accessCode != Integer.MIN_VALUE && !tag.isIncOrDecUnaryOp()) {
                return this.accessCode;
            }
            this.accessCode = AccessCode.from(tag, this.opcode);
            return this.accessCode;
        }

        public static enum AccessCode {
            UNKNOWN(-1, JCTree.Tag.NO_TAG),
            DEREF(0, JCTree.Tag.NO_TAG),
            ASSIGN(2, JCTree.Tag.ASSIGN),
            PREINC(4, JCTree.Tag.PREINC),
            PREDEC(6, JCTree.Tag.PREDEC),
            POSTINC(8, JCTree.Tag.POSTINC),
            POSTDEC(10, JCTree.Tag.POSTDEC),
            FIRSTASGOP(12, JCTree.Tag.NO_TAG);

            public final int code;
            public final JCTree.Tag tag;
            public static final int numberOfAccessCodes;

            private AccessCode(int n2, JCTree.Tag tag) {
                this.code = n2;
                this.tag = tag;
            }

            public static AccessCode getFromCode(int n) {
                for (AccessCode accessCode : AccessCode.values()) {
                    if (accessCode.code != n) continue;
                    return accessCode;
                }
                return UNKNOWN;
            }

            static int from(JCTree.Tag tag, int n) {
                switch (tag) {
                    case PREINC: {
                        return AccessCode.PREINC.code;
                    }
                    case PREDEC: {
                        return AccessCode.PREDEC.code;
                    }
                    case POSTINC: {
                        return AccessCode.POSTINC.code;
                    }
                    case POSTDEC: {
                        return AccessCode.POSTDEC.code;
                    }
                }
                if (96 <= n && n <= 131) {
                    return (n - 96) * 2 + AccessCode.FIRSTASGOP.code;
                }
                if (n == 256) {
                    return 72 + AccessCode.FIRSTASGOP.code;
                }
                if (270 <= n && n <= 275) {
                    return (n - 270 + 131 + 2 - 96) * 2 + AccessCode.FIRSTASGOP.code;
                }
                return -1;
            }

            static {
                numberOfAccessCodes = 84 + AccessCode.FIRSTASGOP.code + 2;
            }
        }
    }

    public static class DynamicMethodSymbol
    extends MethodSymbol {
        public Object[] staticArgs;
        public Symbol bsm;
        public int bsmKind;

        public DynamicMethodSymbol(Name name, Symbol symbol, int n, MethodSymbol methodSymbol, Type type, Object[] objectArray) {
            super(0L, name, type, symbol);
            this.bsm = methodSymbol;
            this.bsmKind = n;
            this.staticArgs = objectArray;
        }

        @Override
        public boolean isDynamic() {
            return true;
        }
    }

    public static class MethodSymbol
    extends Symbol
    implements ExecutableElement {
        public Code code = null;
        public org.openjdk.tools.javac.util.List<VarSymbol> extraParams = org.openjdk.tools.javac.util.List.nil();
        public org.openjdk.tools.javac.util.List<VarSymbol> capturedLocals = org.openjdk.tools.javac.util.List.nil();
        public org.openjdk.tools.javac.util.List<VarSymbol> params = null;
        public Attribute defaultValue = null;
        public static final Filter<Symbol> implementation_filter = symbol -> symbol.kind == Kinds.Kind.MTH && (symbol.flags() & 0x1000L) == 0L;

        public MethodSymbol(long l, Name name, Type type, Symbol symbol) {
            super(Kinds.Kind.MTH, l, name, type, symbol);
            if (symbol.type.hasTag(TypeTag.TYPEVAR)) {
                Assert.error(symbol + "." + name);
            }
        }

        @Override
        public MethodSymbol clone(Symbol symbol) {
            MethodSymbol methodSymbol = new MethodSymbol(this.flags_field, this.name, this.type, symbol){

                @Override
                public Symbol baseSymbol() {
                    return this;
                }
            };
            methodSymbol.code = this.code;
            return methodSymbol;
        }

        @Override
        public Set<Modifier> getModifiers() {
            long l = this.flags();
            return Flags.asModifierSet((l & 0x80000000000L) != 0L ? l & 0xFFFFFFFFFFFFFBFFL : l);
        }

        @Override
        public String toString() {
            String string;
            if ((this.flags() & 0x100000L) != 0L) {
                return this.owner.name.toString();
            }
            String string2 = string = this.name == this.name.table.names.init ? this.owner.name.toString() : this.name.toString();
            if (this.type != null) {
                if (this.type.hasTag(TypeTag.FORALL)) {
                    string = "<" + ((Type.ForAll)this.type).getTypeArguments() + ">" + string;
                }
                string = string + "(" + this.type.argtypes((this.flags() & 0x400000000L) != 0L) + ")";
            }
            return string;
        }

        public boolean isDynamic() {
            return false;
        }

        public Symbol implemented(TypeSymbol typeSymbol, Types types) {
            Symbol symbol = null;
            org.openjdk.tools.javac.util.List<Type> list = types.interfaces(typeSymbol.type);
            while (symbol == null && list.nonEmpty()) {
                TypeSymbol typeSymbol2 = ((Type)list.head).tsym;
                symbol = this.implementedIn(typeSymbol2, types);
                if (symbol == null) {
                    symbol = this.implemented(typeSymbol2, types);
                }
                list = list.tail;
            }
            return symbol;
        }

        public Symbol implementedIn(TypeSymbol typeSymbol, Types types) {
            Symbol symbol = null;
            for (Symbol symbol2 : typeSymbol.members().getSymbolsByName(this.name)) {
                if (!this.overrides(symbol2, (TypeSymbol)this.owner, types, true) || !types.isSameType(this.type.getReturnType(), types.memberType(this.owner.type, symbol2).getReturnType())) continue;
                symbol = symbol2;
            }
            return symbol;
        }

        public boolean binaryOverrides(Symbol symbol, TypeSymbol typeSymbol, Types types) {
            if (this.isConstructor() || symbol.kind != Kinds.Kind.MTH) {
                return false;
            }
            if (this == symbol) {
                return true;
            }
            MethodSymbol methodSymbol = (MethodSymbol)symbol;
            if (methodSymbol.isOverridableIn((TypeSymbol)this.owner) && types.asSuper(this.owner.type, methodSymbol.owner) != null && types.isSameType(this.erasure(types), methodSymbol.erasure(types))) {
                return true;
            }
            return (this.flags() & 0x400L) == 0L && methodSymbol.isOverridableIn(typeSymbol) && this.isMemberOf(typeSymbol, types) && types.isSameType(this.erasure(types), methodSymbol.erasure(types));
        }

        public MethodSymbol binaryImplementation(ClassSymbol classSymbol, Types types) {
            TypeSymbol typeSymbol = classSymbol;
            while (typeSymbol != null) {
                for (Symbol symbol : ((Symbol)typeSymbol).members().getSymbolsByName(this.name)) {
                    if (symbol.kind != Kinds.Kind.MTH || !((MethodSymbol)symbol).binaryOverrides(this, classSymbol, types)) continue;
                    return (MethodSymbol)symbol;
                }
                typeSymbol = types.supertype((Type)typeSymbol.type).tsym;
            }
            return null;
        }

        @Override
        public boolean overrides(Symbol symbol, TypeSymbol typeSymbol, Types types, boolean bl) {
            return this.overrides(symbol, typeSymbol, types, bl, true);
        }

        public boolean overrides(Symbol symbol, TypeSymbol typeSymbol, Types types, boolean bl, boolean bl2) {
            Type type;
            Type type2;
            if (this.isConstructor() || symbol.kind != Kinds.Kind.MTH) {
                return false;
            }
            if (this == symbol) {
                return true;
            }
            MethodSymbol methodSymbol = (MethodSymbol)symbol;
            if (methodSymbol.isOverridableIn((TypeSymbol)this.owner) && types.asSuper(this.owner.type, methodSymbol.owner) != null && types.isSubSignature(type2 = types.memberType(this.owner.type, this), type = types.memberType(this.owner.type, methodSymbol))) {
                if (!bl) {
                    return true;
                }
                if (types.returnTypeSubstitutable(type2, type)) {
                    return true;
                }
            }
            if ((this.flags() & 0x400L) != 0L && bl2 || (methodSymbol.flags() & 0x400L) == 0L && (methodSymbol.flags() & 0x80000000000L) == 0L || !methodSymbol.isOverridableIn(typeSymbol) || !this.isMemberOf(typeSymbol, types)) {
                return false;
            }
            type2 = types.memberType(typeSymbol.type, this);
            return types.isSubSignature(type2, type = types.memberType(typeSymbol.type, methodSymbol)) && (!bl || types.resultSubtype(type2, type, types.noWarnings));
        }

        private boolean isOverridableIn(TypeSymbol typeSymbol) {
            switch ((int)(this.flags_field & 7L)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return !this.owner.isInterface() || (this.flags_field & 8L) == 0L;
                }
                case 4: {
                    return (typeSymbol.flags() & 0x200L) == 0L;
                }
                case 0: {
                    return this.packge() == typeSymbol.packge() && (typeSymbol.flags() & 0x200L) == 0L;
                }
            }
            return false;
        }

        @Override
        public boolean isInheritedIn(Symbol symbol, Types types) {
            switch ((int)(this.flags_field & 7L)) {
                case 1: {
                    return !this.owner.isInterface() || symbol == this.owner || (this.flags_field & 8L) == 0L;
                }
            }
            return super.isInheritedIn(symbol, types);
        }

        public boolean isLambdaMethod() {
            return (this.flags() & 0x2000000000000L) == 0x2000000000000L;
        }

        public MethodSymbol implementation(TypeSymbol typeSymbol, Types types, boolean bl) {
            return this.implementation(typeSymbol, types, bl, implementation_filter);
        }

        public MethodSymbol implementation(TypeSymbol typeSymbol, Types types, boolean bl, Filter<Symbol> filter) {
            MethodSymbol methodSymbol = types.implementation(this, typeSymbol, bl, filter);
            if (methodSymbol != null) {
                return methodSymbol;
            }
            if (types.isDerivedRaw(typeSymbol.type) && !typeSymbol.isInterface()) {
                return this.implementation(types.supertype((Type)typeSymbol.type).tsym, types, bl);
            }
            return null;
        }

        public org.openjdk.tools.javac.util.List<VarSymbol> params() {
            this.owner.complete();
            if (this.params == null) {
                ListBuffer<VarSymbol> listBuffer = new ListBuffer<VarSymbol>();
                int n = 0;
                for (Type type : this.type.getParameterTypes()) {
                    Name name = this.name.table.fromString("arg" + n);
                    VarSymbol varSymbol = new VarSymbol(0x200000000L, name, type, this);
                    listBuffer.append(varSymbol);
                }
                this.params = listBuffer.toList();
            }
            Assert.checkNonNull(this.params);
            return this.params;
        }

        @Override
        public Symbol asMemberOf(Type type, Types types) {
            return new MethodSymbol(this.flags_field, this.name, types.memberType(type, this), this.owner);
        }

        @Override
        public ElementKind getKind() {
            if (this.name == this.name.table.names.init) {
                return ElementKind.CONSTRUCTOR;
            }
            if (this.name == this.name.table.names.clinit) {
                return ElementKind.STATIC_INIT;
            }
            if ((this.flags() & 0x100000L) != 0L) {
                return this.isStatic() ? ElementKind.STATIC_INIT : ElementKind.INSTANCE_INIT;
            }
            return ElementKind.METHOD;
        }

        public boolean isStaticOrInstanceInit() {
            return this.getKind() == ElementKind.STATIC_INIT || this.getKind() == ElementKind.INSTANCE_INIT;
        }

        @Override
        public Attribute getDefaultValue() {
            return this.defaultValue;
        }

        public org.openjdk.tools.javac.util.List<VarSymbol> getParameters() {
            return this.params();
        }

        @Override
        public boolean isVarArgs() {
            return (this.flags() & 0x400000000L) != 0L;
        }

        @Override
        public boolean isDefault() {
            return (this.flags() & 0x80000000000L) != 0L;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> elementVisitor, P p) {
            return elementVisitor.visitExecutable(this, p);
        }

        @Override
        public <R, P> R accept(Visitor<R, P> visitor, P p) {
            return visitor.visitMethodSymbol(this, p);
        }

        @Override
        public Type getReceiverType() {
            return ((Type)this.asType()).getReceiverType();
        }

        @Override
        public Type getReturnType() {
            return ((Type)this.asType()).getReturnType();
        }

        public org.openjdk.tools.javac.util.List<Type> getThrownTypes() {
            return ((Type)this.asType()).getThrownTypes();
        }
    }

    public static class VarSymbol
    extends Symbol
    implements VariableElement {
        public int pos = -1;
        public int adr = -1;
        private Object data;

        public VarSymbol(long l, Name name, Type type, Symbol symbol) {
            super(Kinds.Kind.VAR, l, name, type, symbol);
        }

        @Override
        public VarSymbol clone(Symbol symbol) {
            VarSymbol varSymbol = new VarSymbol(this.flags_field, this.name, this.type, symbol){

                @Override
                public Symbol baseSymbol() {
                    return this;
                }
            };
            varSymbol.pos = this.pos;
            varSymbol.adr = this.adr;
            varSymbol.data = this.data;
            return varSymbol;
        }

        @Override
        public String toString() {
            return this.name.toString();
        }

        @Override
        public Symbol asMemberOf(Type type, Types types) {
            return new VarSymbol(this.flags_field, this.name, types.memberType(type, this), this.owner);
        }

        @Override
        public ElementKind getKind() {
            long l = this.flags();
            if ((l & 0x200000000L) != 0L) {
                if (this.isExceptionParameter()) {
                    return ElementKind.EXCEPTION_PARAMETER;
                }
                return ElementKind.PARAMETER;
            }
            if ((l & 0x4000L) != 0L) {
                return ElementKind.ENUM_CONSTANT;
            }
            if (this.owner.kind == Kinds.Kind.TYP || this.owner.kind == Kinds.Kind.ERR) {
                return ElementKind.FIELD;
            }
            if (this.isResourceVariable()) {
                return ElementKind.RESOURCE_VARIABLE;
            }
            return ElementKind.LOCAL_VARIABLE;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> elementVisitor, P p) {
            return elementVisitor.visitVariable(this, p);
        }

        @Override
        public Object getConstantValue() {
            return Constants.decode(this.getConstValue(), this.type);
        }

        public void setLazyConstValue(Env<AttrContext> env, Attr attr, JCTree.JCVariableDecl jCVariableDecl) {
            this.setData(() -> attr.attribLazyConstantValue(env, jCVariableDecl, this.type));
        }

        public boolean isExceptionParameter() {
            return this.data == ElementKind.EXCEPTION_PARAMETER;
        }

        public boolean isResourceVariable() {
            return this.data == ElementKind.RESOURCE_VARIABLE;
        }

        public Object getConstValue() {
            if (this.data == ElementKind.EXCEPTION_PARAMETER || this.data == ElementKind.RESOURCE_VARIABLE) {
                return null;
            }
            if (this.data instanceof Callable) {
                Callable callable = (Callable)this.data;
                this.data = null;
                try {
                    this.data = callable.call();
                }
                catch (Exception exception) {
                    throw new AssertionError((Object)exception);
                }
            }
            return this.data;
        }

        public void setData(Object object) {
            Assert.check(!(object instanceof Env), this);
            this.data = object;
        }

        @Override
        public <R, P> R accept(Visitor<R, P> visitor, P p) {
            return visitor.visitVarSymbol(this, p);
        }
    }

    public static class ClassSymbol
    extends TypeSymbol
    implements TypeElement {
        public Scope.WriteableScope members_field = null;
        public Name fullname;
        public Name flatname;
        public JavaFileObject sourcefile;
        public JavaFileObject classfile;
        public org.openjdk.tools.javac.util.List<ClassSymbol> trans_local;
        public Pool pool;
        private Annotate.AnnotationTypeMetadata annotationTypeMetadata;

        public ClassSymbol(long l, Name name, Type type, Symbol symbol) {
            super(Kinds.Kind.TYP, l, name, type, symbol);
            this.fullname = ClassSymbol.formFullName(name, symbol);
            this.flatname = ClassSymbol.formFlatName(name, symbol);
            this.sourcefile = null;
            this.classfile = null;
            this.pool = null;
            this.annotationTypeMetadata = Annotate.AnnotationTypeMetadata.notAnAnnotationType();
        }

        public ClassSymbol(long l, Name name, Symbol symbol) {
            this(l, name, new Type.ClassType(Type.noType, null, null), symbol);
            this.type.tsym = this;
        }

        @Override
        public String toString() {
            return this.className();
        }

        @Override
        public long flags() {
            this.complete();
            return this.flags_field;
        }

        @Override
        public Scope.WriteableScope members() {
            this.complete();
            return this.members_field;
        }

        @Override
        public org.openjdk.tools.javac.util.List<Attribute.Compound> getRawAttributes() {
            this.complete();
            return super.getRawAttributes();
        }

        @Override
        public org.openjdk.tools.javac.util.List<Attribute.TypeCompound> getRawTypeAttributes() {
            this.complete();
            return super.getRawTypeAttributes();
        }

        @Override
        public Type erasure(Types types) {
            if (this.erasure_field == null) {
                this.erasure_field = new Type.ClassType(types.erasure(this.type.getEnclosingType()), org.openjdk.tools.javac.util.List.nil(), this, this.type.getMetadata());
            }
            return this.erasure_field;
        }

        public String className() {
            if (this.name.isEmpty()) {
                return Log.getLocalizedString("anonymous.class", this.flatname);
            }
            return this.fullname.toString();
        }

        @Override
        public Name getQualifiedName() {
            return this.fullname;
        }

        @Override
        public Name flatName() {
            return this.flatname;
        }

        @Override
        public boolean isSubClass(Symbol symbol, Types types) {
            if (this == symbol) {
                return true;
            }
            if ((symbol.flags() & 0x200L) != 0L) {
                Type type = this.type;
                while (type.hasTag(TypeTag.CLASS)) {
                    org.openjdk.tools.javac.util.List<Type> list = types.interfaces(type);
                    while (list.nonEmpty()) {
                        if (((Type)list.head).tsym.isSubClass(symbol, types)) {
                            return true;
                        }
                        list = list.tail;
                    }
                    type = types.supertype(type);
                }
            } else {
                Type type = this.type;
                while (type.hasTag(TypeTag.CLASS)) {
                    if (type.tsym == symbol) {
                        return true;
                    }
                    type = types.supertype(type);
                }
            }
            return false;
        }

        @Override
        public void complete() throws CompletionFailure {
            try {
                super.complete();
            }
            catch (CompletionFailure completionFailure) {
                this.flags_field |= 9L;
                this.type = new Type.ErrorType(this, Type.noType);
                throw completionFailure;
            }
        }

        public org.openjdk.tools.javac.util.List<Type> getInterfaces() {
            this.complete();
            if (this.type instanceof Type.ClassType) {
                Type.ClassType classType = (Type.ClassType)this.type;
                if (classType.interfaces_field == null) {
                    classType.interfaces_field = org.openjdk.tools.javac.util.List.nil();
                }
                if (classType.all_interfaces_field != null) {
                    return Type.getModelTypes(classType.all_interfaces_field);
                }
                return classType.interfaces_field;
            }
            return org.openjdk.tools.javac.util.List.nil();
        }

        @Override
        public Type getSuperclass() {
            this.complete();
            if (this.type instanceof Type.ClassType) {
                Type.ClassType classType = (Type.ClassType)this.type;
                if (classType.supertype_field == null) {
                    classType.supertype_field = Type.noType;
                }
                return classType.isInterface() ? Type.noType : classType.supertype_field.getModelType();
            }
            return Type.noType;
        }

        private ClassSymbol getSuperClassToSearchForAnnotations() {
            Type type = this.getSuperclass();
            if (!type.hasTag(TypeTag.CLASS) || type.isErroneous()) {
                return null;
            }
            return (ClassSymbol)type.tsym;
        }

        @Override
        protected <A extends Annotation> A[] getInheritedAnnotations(Class<A> clazz) {
            ClassSymbol classSymbol = this.getSuperClassToSearchForAnnotations();
            return classSymbol == null ? super.getInheritedAnnotations(clazz) : classSymbol.getAnnotationsByType(clazz);
        }

        @Override
        public ElementKind getKind() {
            long l = this.flags();
            if ((l & 0x2000L) != 0L) {
                return ElementKind.ANNOTATION_TYPE;
            }
            if ((l & 0x200L) != 0L) {
                return ElementKind.INTERFACE;
            }
            if ((l & 0x4000L) != 0L) {
                return ElementKind.ENUM;
            }
            return ElementKind.CLASS;
        }

        @Override
        public Set<Modifier> getModifiers() {
            long l = this.flags();
            return Flags.asModifierSet(l & 0xFFFFF7FFFFFFFFFFL);
        }

        @Override
        public NestingKind getNestingKind() {
            this.complete();
            if (this.owner.kind == Kinds.Kind.PCK) {
                return NestingKind.TOP_LEVEL;
            }
            if (this.name.isEmpty()) {
                return NestingKind.ANONYMOUS;
            }
            if (this.owner.kind == Kinds.Kind.MTH) {
                return NestingKind.LOCAL;
            }
            return NestingKind.MEMBER;
        }

        @Override
        protected <A extends Annotation> Attribute.Compound getAttribute(Class<A> clazz) {
            Attribute.Compound compound = super.getAttribute(clazz);
            boolean bl = clazz.isAnnotationPresent(Inherited.class);
            if (compound != null || !bl) {
                return compound;
            }
            ClassSymbol classSymbol = this.getSuperClassToSearchForAnnotations();
            return classSymbol == null ? null : classSymbol.getAttribute(clazz);
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> elementVisitor, P p) {
            return elementVisitor.visitType(this, p);
        }

        @Override
        public <R, P> R accept(Visitor<R, P> visitor, P p) {
            return visitor.visitClassSymbol(this, p);
        }

        public void markAbstractIfNeeded(Types types) {
            if (types.enter.getEnv(this) != null && (this.flags() & 0x4000L) != 0L && types.supertype((Type)this.type).tsym == types.syms.enumSym && (this.flags() & 0x410L) == 0L && types.firstUnimplementedAbstract(this) != null) {
                this.flags_field |= 0x400L;
            }
        }

        public void reset() {
            this.kind = Kinds.Kind.TYP;
            this.erasure_field = null;
            this.members_field = null;
            this.flags_field = 0L;
            if (this.type instanceof Type.ClassType) {
                Type.ClassType classType = (Type.ClassType)this.type;
                classType.setEnclosingType(Type.noType);
                classType.rank_field = -1;
                classType.typarams_field = null;
                classType.allparams_field = null;
                classType.supertype_field = null;
                classType.interfaces_field = null;
                classType.all_interfaces_field = null;
            }
            this.clearAnnotationMetadata();
        }

        public void clearAnnotationMetadata() {
            this.metadata = null;
            this.annotationTypeMetadata = Annotate.AnnotationTypeMetadata.notAnAnnotationType();
        }

        @Override
        public Annotate.AnnotationTypeMetadata getAnnotationTypeMetadata() {
            return this.annotationTypeMetadata;
        }

        @Override
        public boolean isAnnotationType() {
            return (this.flags_field & 0x2000L) != 0L;
        }

        public void setAnnotationTypeMetadata(Annotate.AnnotationTypeMetadata annotationTypeMetadata) {
            Assert.checkNonNull(annotationTypeMetadata);
            Assert.check(!this.annotationTypeMetadata.isMetadataForAnnotationType());
            this.annotationTypeMetadata = annotationTypeMetadata;
        }
    }

    public static class PackageSymbol
    extends TypeSymbol
    implements PackageElement {
        public Scope.WriteableScope members_field = null;
        public Name fullname;
        public ClassSymbol package_info;
        public ModuleSymbol modle;
        public JavaFileObject sourcefile;

        public PackageSymbol(Name name, Type type, Symbol symbol) {
            super(Kinds.Kind.PCK, 0L, name, type, symbol);
            this.fullname = PackageSymbol.formFullName(name, symbol);
        }

        public PackageSymbol(Name name, Symbol symbol) {
            this(name, null, symbol);
            this.type = new Type.PackageType(this);
        }

        @Override
        public String toString() {
            return this.fullname.toString();
        }

        @Override
        public Name getQualifiedName() {
            return this.fullname;
        }

        @Override
        public boolean isUnnamed() {
            return this.name.isEmpty() && this.owner != null;
        }

        @Override
        public Scope.WriteableScope members() {
            this.complete();
            return this.members_field;
        }

        @Override
        public long flags() {
            this.complete();
            return this.flags_field;
        }

        @Override
        public org.openjdk.tools.javac.util.List<Attribute.Compound> getRawAttributes() {
            this.complete();
            if (this.package_info != null) {
                this.package_info.complete();
                this.mergeAttributes();
            }
            return super.getRawAttributes();
        }

        private void mergeAttributes() {
            if (this.metadata == null && this.package_info.metadata != null) {
                this.metadata = new SymbolMetadata(this);
                this.metadata.setAttributes(this.package_info.metadata);
            }
        }

        @Override
        public boolean exists() {
            return (this.flags_field & 0x800000L) != 0L;
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.PACKAGE;
        }

        @Override
        public Symbol getEnclosingElement() {
            return this.modle != null && !this.modle.isNoModule() ? this.modle : null;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> elementVisitor, P p) {
            return elementVisitor.visitPackage(this, p);
        }

        @Override
        public <R, P> R accept(Visitor<R, P> visitor, P p) {
            return visitor.visitPackageSymbol(this, p);
        }

        public void reset() {
            this.metadata = null;
        }
    }

    public static enum ModuleResolutionFlags {
        DO_NOT_RESOLVE_BY_DEFAULT(1),
        WARN_DEPRECATED(2),
        WARN_DEPRECATED_REMOVAL(4),
        WARN_INCUBATING(8);

        public final int value;

        public static int value(Set<ModuleResolutionFlags> set) {
            int n = 0;
            for (ModuleResolutionFlags moduleResolutionFlags : set) {
                n |= moduleResolutionFlags.value;
            }
            return n;
        }

        private ModuleResolutionFlags(int n2) {
            this.value = n2;
        }
    }

    public static enum ModuleFlags {
        OPEN(32),
        SYNTHETIC(4096),
        MANDATED(32768);

        public final int value;

        public static int value(Set<ModuleFlags> set) {
            int n = 0;
            for (ModuleFlags moduleFlags : set) {
                n |= moduleFlags.value;
            }
            return n;
        }

        private ModuleFlags(int n2) {
            this.value = n2;
        }
    }

    public static class ModuleSymbol
    extends TypeSymbol
    implements ModuleElement {
        public Name version;
        public JavaFileManager.Location sourceLocation;
        public JavaFileManager.Location classLocation;
        public JavaFileManager.Location patchLocation;
        public JavaFileManager.Location patchOutputLocation;
        public org.openjdk.tools.javac.util.List<Directive> directives;
        public org.openjdk.tools.javac.util.List<Directive.RequiresDirective> requires;
        public org.openjdk.tools.javac.util.List<Directive.ExportsDirective> exports;
        public org.openjdk.tools.javac.util.List<Directive.OpensDirective> opens;
        public org.openjdk.tools.javac.util.List<Directive.ProvidesDirective> provides;
        public org.openjdk.tools.javac.util.List<Directive.UsesDirective> uses;
        public ClassSymbol module_info;
        public PackageSymbol unnamedPackage;
        public Map<Name, PackageSymbol> visiblePackages;
        public Set<ModuleSymbol> readModules;
        public org.openjdk.tools.javac.util.List<Symbol> enclosedPackages = org.openjdk.tools.javac.util.List.nil();
        public Completer usesProvidesCompleter = Completer.NULL_COMPLETER;
        public final Set<ModuleFlags> flags = EnumSet.noneOf(ModuleFlags.class);
        public final Set<ModuleResolutionFlags> resolutionFlags = EnumSet.noneOf(ModuleResolutionFlags.class);

        public static ModuleSymbol create(Name name, Name name2) {
            ModuleSymbol moduleSymbol = new ModuleSymbol(name, null);
            ClassSymbol classSymbol = new ClassSymbol(0x8000000000000L, name2, moduleSymbol);
            classSymbol.flatname = classSymbol.fullname = ModuleSymbol.formFullName(name2, moduleSymbol);
            classSymbol.members_field = Scope.WriteableScope.create(classSymbol);
            moduleSymbol.module_info = classSymbol;
            return moduleSymbol;
        }

        public ModuleSymbol(Name name, Symbol symbol) {
            super(Kinds.Kind.MDL, 0L, name, null, symbol);
            Assert.checkNonNull(name);
            this.type = new Type.ModuleType(this);
        }

        @Override
        public Name getSimpleName() {
            org.openjdk.javax.lang.model.element.Name name = this.getQualifiedName();
            int n = ((Name)name).lastIndexOf((byte)46);
            if (n == -1) {
                return name;
            }
            return ((Name)name).subName(n + 1, ((Name)name).length());
        }

        @Override
        public boolean isOpen() {
            return this.flags.contains((Object)ModuleFlags.OPEN);
        }

        @Override
        public boolean isUnnamed() {
            return this.name.isEmpty() && this.owner == null;
        }

        @Override
        public boolean isDeprecated() {
            return this.hasDeprecatedAnnotation();
        }

        public boolean isNoModule() {
            return false;
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.MODULE;
        }

        public List<ModuleElement.Directive> getDirectives() {
            this.complete();
            this.completeUsesProvides();
            return Collections.unmodifiableList(this.directives);
        }

        public void completeUsesProvides() {
            if (this.usesProvidesCompleter != Completer.NULL_COMPLETER) {
                Completer completer = this.usesProvidesCompleter;
                this.usesProvidesCompleter = Completer.NULL_COMPLETER;
                completer.complete(this);
            }
        }

        @Override
        public ClassSymbol outermostClass() {
            return null;
        }

        @Override
        public String toString() {
            String string = this.name == null ? "<unknown>" : (this.name.isEmpty() ? "<unnamed>" : String.valueOf(this.name));
            return string;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> elementVisitor, P p) {
            return elementVisitor.visitModule(this, p);
        }

        public org.openjdk.tools.javac.util.List<Symbol> getEnclosedElements() {
            org.openjdk.tools.javac.util.List<Symbol> list = org.openjdk.tools.javac.util.List.nil();
            for (Symbol symbol2 : this.enclosedPackages) {
                if (!symbol2.members().anyMatch(symbol -> symbol.kind == Kinds.Kind.TYP)) continue;
                list = list.prepend(symbol2);
            }
            return list;
        }

        public void reset() {
            this.directives = null;
            this.requires = null;
            this.exports = null;
            this.provides = null;
            this.uses = null;
            this.visiblePackages = null;
        }
    }

    public static class TypeVariableSymbol
    extends TypeSymbol
    implements TypeParameterElement {
        public TypeVariableSymbol(long l, Name name, Type type, Symbol symbol) {
            super(Kinds.Kind.TYP, l, name, type, symbol);
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.TYPE_PARAMETER;
        }

        @Override
        public Symbol getGenericElement() {
            return this.owner;
        }

        public org.openjdk.tools.javac.util.List<Type> getBounds() {
            Type.TypeVar typeVar = (Type.TypeVar)this.type;
            Type type = typeVar.getUpperBound();
            if (!type.isCompound()) {
                return org.openjdk.tools.javac.util.List.of(type);
            }
            Type.ClassType classType = (Type.ClassType)type;
            if (!classType.tsym.erasure_field.isInterface()) {
                return classType.interfaces_field.prepend(classType.supertype_field);
            }
            return classType.interfaces_field;
        }

        @Override
        public org.openjdk.tools.javac.util.List<Attribute.Compound> getAnnotationMirrors() {
            org.openjdk.tools.javac.util.List<Attribute.TypeCompound> list = this.owner.getRawTypeAttributes();
            int n = this.owner.getTypeParameters().indexOf(this);
            org.openjdk.tools.javac.util.List<Attribute.TypeCompound> list2 = org.openjdk.tools.javac.util.List.nil();
            for (Attribute.TypeCompound typeCompound : list) {
                if (!this.isCurrentSymbolsAnnotation(typeCompound, n)) continue;
                list2 = list2.prepend(typeCompound);
            }
            return list2.reverse();
        }

        @Override
        public <A extends Annotation> Attribute.Compound getAttribute(Class<A> clazz) {
            String string = clazz.getName();
            org.openjdk.tools.javac.util.List<Attribute.TypeCompound> list = this.owner.getRawTypeAttributes();
            int n = this.owner.getTypeParameters().indexOf(this);
            for (Attribute.TypeCompound typeCompound : list) {
                if (!this.isCurrentSymbolsAnnotation(typeCompound, n) || !string.contentEquals(typeCompound.type.tsym.flatName())) continue;
                return typeCompound;
            }
            return null;
        }

        boolean isCurrentSymbolsAnnotation(Attribute.TypeCompound typeCompound, int n) {
            return (typeCompound.position.type == TargetType.CLASS_TYPE_PARAMETER || typeCompound.position.type == TargetType.METHOD_TYPE_PARAMETER) && typeCompound.position.parameter_index == n;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> elementVisitor, P p) {
            return elementVisitor.visitTypeParameter(this, p);
        }
    }

    public static abstract class TypeSymbol
    extends Symbol {
        public TypeSymbol(Kinds.Kind kind, long l, Name name, Type type, Symbol symbol) {
            super(kind, l, name, type, symbol);
        }

        public static Name formFullName(Name name, Symbol symbol) {
            if (symbol == null) {
                return name;
            }
            if (symbol.kind != Kinds.Kind.ERR && (symbol.kind.matches(Kinds.KindSelector.VAL_MTH) || symbol.kind == Kinds.Kind.TYP && symbol.type.hasTag(TypeTag.TYPEVAR))) {
                return name;
            }
            Name name2 = symbol.getQualifiedName();
            if (name2 == null || name2 == name2.table.names.empty) {
                return name;
            }
            return name2.append('.', name);
        }

        public static Name formFlatName(Name name, Symbol symbol) {
            if (symbol == null || symbol.kind.matches(Kinds.KindSelector.VAL_MTH) || symbol.kind == Kinds.Kind.TYP && symbol.type.hasTag(TypeTag.TYPEVAR)) {
                return name;
            }
            char c = symbol.kind == Kinds.Kind.TYP ? (char)'$' : '.';
            Name name2 = symbol.flatName();
            if (name2 == null || name2 == name2.table.names.empty) {
                return name;
            }
            return name2.append(c, name);
        }

        public final boolean precedes(TypeSymbol typeSymbol, Types types) {
            if (this == typeSymbol) {
                return false;
            }
            if (this.type.hasTag(typeSymbol.type.getTag())) {
                if (this.type.hasTag(TypeTag.CLASS)) {
                    return types.rank(typeSymbol.type) < types.rank(this.type) || types.rank(typeSymbol.type) == types.rank(this.type) && typeSymbol.getQualifiedName().compareTo(this.getQualifiedName()) < 0;
                }
                if (this.type.hasTag(TypeTag.TYPEVAR)) {
                    return types.isSubtype(this.type, typeSymbol.type);
                }
            }
            return this.type.hasTag(TypeTag.TYPEVAR);
        }

        @Override
        public List<Symbol> getEnclosedElements() {
            org.openjdk.tools.javac.util.List<Symbol> list = org.openjdk.tools.javac.util.List.nil();
            if (this.kind == Kinds.Kind.TYP && this.type.hasTag(TypeTag.TYPEVAR)) {
                return list;
            }
            for (Symbol symbol : this.members().getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
                try {
                    if (symbol == null || (symbol.flags() & 0x1000L) != 0L || symbol.owner != this) continue;
                    list = list.prepend(symbol);
                }
                catch (ClassFinder.BadEnclosingMethodAttr badEnclosingMethodAttr) {}
            }
            return list;
        }

        public Annotate.AnnotationTypeMetadata getAnnotationTypeMetadata() {
            Assert.error("Only on ClassSymbol");
            return null;
        }

        public boolean isAnnotationType() {
            return false;
        }

        @Override
        public <R, P> R accept(Visitor<R, P> visitor, P p) {
            return visitor.visitTypeSymbol(this, p);
        }
    }

    public static class DelegatedSymbol<T extends Symbol>
    extends Symbol {
        protected T other;

        public DelegatedSymbol(T t2) {
            super(((Symbol)t2).kind, ((Symbol)t2).flags_field, ((Symbol)t2).name, ((Symbol)t2).type, ((Symbol)t2).owner);
            this.other = t2;
        }

        @Override
        public String toString() {
            return ((Symbol)this.other).toString();
        }

        @Override
        public Symbol location() {
            return ((Symbol)this.other).location();
        }

        @Override
        public Symbol location(Type type, Types types) {
            return ((Symbol)this.other).location(type, types);
        }

        @Override
        public Symbol baseSymbol() {
            return this.other;
        }

        @Override
        public Type erasure(Types types) {
            return ((Symbol)this.other).erasure(types);
        }

        @Override
        public Type externalType(Types types) {
            return ((Symbol)this.other).externalType(types);
        }

        @Override
        public boolean isLocal() {
            return ((Symbol)this.other).isLocal();
        }

        @Override
        public boolean isConstructor() {
            return ((Symbol)this.other).isConstructor();
        }

        @Override
        public Name getQualifiedName() {
            return ((Symbol)this.other).getQualifiedName();
        }

        @Override
        public Name flatName() {
            return ((Symbol)this.other).flatName();
        }

        @Override
        public Scope.WriteableScope members() {
            return ((Symbol)this.other).members();
        }

        @Override
        public boolean isInner() {
            return ((Symbol)this.other).isInner();
        }

        @Override
        public boolean hasOuterInstance() {
            return ((Symbol)this.other).hasOuterInstance();
        }

        @Override
        public ClassSymbol enclClass() {
            return ((Symbol)this.other).enclClass();
        }

        @Override
        public ClassSymbol outermostClass() {
            return ((Symbol)this.other).outermostClass();
        }

        @Override
        public PackageSymbol packge() {
            return ((Symbol)this.other).packge();
        }

        @Override
        public boolean isSubClass(Symbol symbol, Types types) {
            return ((Symbol)this.other).isSubClass(symbol, types);
        }

        @Override
        public boolean isMemberOf(TypeSymbol typeSymbol, Types types) {
            return ((Symbol)this.other).isMemberOf(typeSymbol, types);
        }

        @Override
        public boolean isEnclosedBy(ClassSymbol classSymbol) {
            return ((Symbol)this.other).isEnclosedBy(classSymbol);
        }

        @Override
        public boolean isInheritedIn(Symbol symbol, Types types) {
            return ((Symbol)this.other).isInheritedIn(symbol, types);
        }

        @Override
        public Symbol asMemberOf(Type type, Types types) {
            return ((Symbol)this.other).asMemberOf(type, types);
        }

        @Override
        public void complete() throws CompletionFailure {
            ((Symbol)this.other).complete();
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> elementVisitor, P p) {
            return this.other.accept(elementVisitor, p);
        }

        @Override
        public <R, P> R accept(Visitor<R, P> visitor, P p) {
            return visitor.visitSymbol((Symbol)this.other, p);
        }

        public T getUnderlyingSymbol() {
            return this.other;
        }
    }
}

