/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts.internal;

import com.google.common.base.Preconditions;
import io.grpc.alts.internal.AeadCrypter;
import io.grpc.alts.internal.AesGcmAeadCrypter;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

final class AesGcmHkdfAeadCrypter
implements AeadCrypter {
    private static final int KDF_KEY_LENGTH = 32;
    private static final int KDF_COUNTER_OFFSET = 2;
    private static final int KDF_COUNTER_LENGTH = 6;
    private static final int NONCE_LENGTH = 12;
    private static final int KEY_LENGTH = 44;
    private final byte[] kdfKey;
    private final byte[] kdfCounter = new byte[6];
    private final byte[] nonceMask;
    private final byte[] nonceBuffer = new byte[12];
    private AeadCrypter aeadCrypter;

    AesGcmHkdfAeadCrypter(byte[] key) {
        Preconditions.checkArgument(key.length == 44);
        this.kdfKey = Arrays.copyOf(key, 32);
        this.nonceMask = Arrays.copyOfRange(key, 32, 44);
    }

    @Override
    public void encrypt(ByteBuffer ciphertext, ByteBuffer plaintext, byte[] nonce) throws GeneralSecurityException {
        this.maybeRekey(nonce);
        AesGcmHkdfAeadCrypter.maskNonce(this.nonceBuffer, this.nonceMask, nonce);
        this.aeadCrypter.encrypt(ciphertext, plaintext, this.nonceBuffer);
    }

    @Override
    public void encrypt(ByteBuffer ciphertext, ByteBuffer plaintext, ByteBuffer aad, byte[] nonce) throws GeneralSecurityException {
        this.maybeRekey(nonce);
        AesGcmHkdfAeadCrypter.maskNonce(this.nonceBuffer, this.nonceMask, nonce);
        this.aeadCrypter.encrypt(ciphertext, plaintext, aad, this.nonceBuffer);
    }

    @Override
    public void decrypt(ByteBuffer plaintext, ByteBuffer ciphertext, byte[] nonce) throws GeneralSecurityException {
        this.maybeRekey(nonce);
        AesGcmHkdfAeadCrypter.maskNonce(this.nonceBuffer, this.nonceMask, nonce);
        this.aeadCrypter.decrypt(plaintext, ciphertext, this.nonceBuffer);
    }

    @Override
    public void decrypt(ByteBuffer plaintext, ByteBuffer ciphertext, ByteBuffer aad, byte[] nonce) throws GeneralSecurityException {
        this.maybeRekey(nonce);
        AesGcmHkdfAeadCrypter.maskNonce(this.nonceBuffer, this.nonceMask, nonce);
        this.aeadCrypter.decrypt(plaintext, ciphertext, aad, this.nonceBuffer);
    }

    private void maybeRekey(byte[] nonce) throws GeneralSecurityException {
        if (this.aeadCrypter != null && AesGcmHkdfAeadCrypter.arrayEqualOn(nonce, 2, this.kdfCounter, 0, 6)) {
            return;
        }
        System.arraycopy(nonce, 2, this.kdfCounter, 0, 6);
        int aeKeyLen = AesGcmAeadCrypter.getKeyLength();
        byte[] aeKey = Arrays.copyOf(AesGcmHkdfAeadCrypter.hkdfExpandSha256(this.kdfKey, this.kdfCounter), aeKeyLen);
        this.aeadCrypter = new AesGcmAeadCrypter(aeKey);
    }

    private static void maskNonce(byte[] nonceBuffer, byte[] nonceMask, byte[] nonce) {
        Preconditions.checkArgument(nonce.length == 12);
        for (int i = 0; i < 12; ++i) {
            nonceBuffer[i] = (byte)(nonceMask[i] ^ nonce[i]);
        }
    }

    private static byte[] hkdfExpandSha256(byte[] key, byte[] info) throws GeneralSecurityException {
        Mac mac = Mac.getInstance("HMACSHA256");
        mac.init(new SecretKeySpec(key, mac.getAlgorithm()));
        mac.update(info);
        mac.update((byte)1);
        return mac.doFinal();
    }

    private static boolean arrayEqualOn(byte[] a, int aPos, byte[] b, int bPos, int length) {
        for (int i = 0; i < length; ++i) {
            if (a[aPos + i] == b[bPos + i]) continue;
            return false;
        }
        return true;
    }

    static int getKeyLength() {
        return 44;
    }
}

