/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.collect.Range;
import java.util.Objects;

public class Replacement {
    private final Range<Integer> replaceRange;
    private final String replacementString;

    public static Replacement create(int startPosition, int endPosition, String replaceWith) {
        return new Replacement(Range.closedOpen(startPosition, endPosition), replaceWith);
    }

    public static Replacement create(Range<Integer> range, String replaceWith) {
        return new Replacement(range, replaceWith);
    }

    Replacement(Range<Integer> replaceRange, String replacementString) {
        if (replaceRange == null) {
            throw new NullPointerException("Null replaceRange");
        }
        this.replaceRange = replaceRange;
        if (replacementString == null) {
            throw new NullPointerException("Null replacementString");
        }
        this.replacementString = replacementString;
    }

    public Range<Integer> getReplaceRange() {
        return this.replaceRange;
    }

    public String getReplacementString() {
        return this.replacementString;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Replacement) {
            Replacement that = (Replacement)o;
            return this.replaceRange.equals(that.getReplaceRange()) && this.replacementString.equals(that.getReplacementString());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.replaceRange, this.replacementString);
    }
}

