/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.googlejavaformat.CommentsHelper;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.OpsBuilder;
import com.google.googlejavaformat.Output;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.JavaInput;
import com.google.googlejavaformat.java.Replacement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class JavaOutput
extends Output {
    private final String lineSeparator;
    private final JavaInput javaInput;
    private final CommentsHelper commentsHelper;
    private final Map<Integer, OpsBuilder.BlankLineWanted> blankLines = new HashMap<Integer, OpsBuilder.BlankLineWanted>();
    private final RangeSet<Integer> partialFormatRanges = TreeRangeSet.create();
    private final List<String> mutableLines = new ArrayList<String>();
    private final int kN;
    private int iLine = 0;
    private int lastK = -1;
    private int spacesPending = 0;
    private int newlinesPending = 0;
    private StringBuilder lineBuilder = new StringBuilder();

    public JavaOutput(String lineSeparator, JavaInput javaInput, CommentsHelper commentsHelper) {
        this.lineSeparator = lineSeparator;
        this.javaInput = javaInput;
        this.commentsHelper = commentsHelper;
        this.kN = javaInput.getkN();
    }

    @Override
    public void blankLine(int k, OpsBuilder.BlankLineWanted wanted) {
        if (this.blankLines.containsKey(k)) {
            this.blankLines.put(k, this.blankLines.get(k).merge(wanted));
        } else {
            this.blankLines.put(k, wanted);
        }
    }

    @Override
    public void markForPartialFormat(Input.Token start, Input.Token end) {
        int lo = JavaOutput.startTok(start).getIndex();
        int hi = JavaOutput.endTok(end).getIndex();
        this.partialFormatRanges.add(Range.closed(lo, hi));
    }

    @Override
    public void append(String text, Range<Integer> range) {
        if (!range.isEmpty()) {
            boolean sawNewlines = false;
            int iN = this.javaInput.getLineCount();
            while (this.iLine < iN && (this.javaInput.getRanges(this.iLine).isEmpty() || this.javaInput.getRanges(this.iLine).upperEndpoint() <= range.lowerEndpoint())) {
                if (this.javaInput.getRanges(this.iLine).isEmpty()) {
                    sawNewlines = true;
                }
                ++this.iLine;
            }
            OpsBuilder.BlankLineWanted wanted = this.blankLines.getOrDefault(this.lastK, OpsBuilder.BlankLineWanted.NO);
            if (this.isComment(text) ? sawNewlines : wanted.wanted().orElse(sawNewlines) != false) {
                ++this.newlinesPending;
            }
        }
        if (Newlines.isNewline(text)) {
            if (this.newlinesPending == 0) {
                ++this.newlinesPending;
            }
            this.spacesPending = 0;
        } else {
            boolean rangesSet = false;
            int textN = text.length();
            block6: for (int i = 0; i < textN; ++i) {
                char c = text.charAt(i);
                switch (c) {
                    case ' ': {
                        ++this.spacesPending;
                        continue block6;
                    }
                    case '\r': {
                        if (i + 1 < text.length() && text.charAt(i + 1) == '\n') {
                            ++i;
                        }
                    }
                    case '\n': {
                        this.spacesPending = 0;
                        ++this.newlinesPending;
                        continue block6;
                    }
                    default: {
                        while (this.newlinesPending > 0) {
                            if (!this.mutableLines.isEmpty() || this.lineBuilder.length() > 0) {
                                this.mutableLines.add(this.lineBuilder.toString());
                            }
                            this.lineBuilder = new StringBuilder();
                            rangesSet = false;
                            --this.newlinesPending;
                        }
                        while (this.spacesPending > 0) {
                            this.lineBuilder.append(' ');
                            --this.spacesPending;
                        }
                        this.lineBuilder.append(c);
                        if (range.isEmpty() || rangesSet) continue block6;
                        while (this.ranges.size() <= this.mutableLines.size()) {
                            this.ranges.add(Formatter.EMPTY_RANGE);
                        }
                        this.ranges.set(this.mutableLines.size(), JavaOutput.union((Range)this.ranges.get(this.mutableLines.size()), range));
                        rangesSet = true;
                    }
                }
            }
        }
        if (!range.isEmpty()) {
            this.lastK = range.upperEndpoint();
        }
    }

    @Override
    public void indent(int indent) {
        this.spacesPending = indent;
    }

    void flush() {
        String lastLine = this.lineBuilder.toString();
        if (!CharMatcher.whitespace().matchesAllOf(lastLine)) {
            this.mutableLines.add(lastLine);
        }
        int jN = this.mutableLines.size();
        Range<Integer> eofRange = Range.closedOpen(this.kN, this.kN + 1);
        while (this.ranges.size() < jN) {
            this.ranges.add(Formatter.EMPTY_RANGE);
        }
        this.ranges.add(eofRange);
        this.setLines(ImmutableList.copyOf(this.mutableLines));
    }

    @Override
    public CommentsHelper getCommentsHelper() {
        return this.commentsHelper;
    }

    public ImmutableList<Replacement> getFormatReplacements(RangeSet<Integer> iRangeSet0) {
        ImmutableList.Builder result = ImmutableList.builder();
        Map<Integer, Range<Integer>> kToJ = JavaOutput.makeKToIJ(this);
        TreeRangeSet<Integer> breakableRanges = TreeRangeSet.create();
        RangeSet<Integer> iRangeSet = iRangeSet0.subRangeSet(Range.closed(0, this.javaInput.getkN()));
        for (Range<Integer> range : iRangeSet.asRanges()) {
            Range<Integer> range2 = this.expandToBreakableRegions(range.canonical(DiscreteDomain.integers()));
            if (range2.equals(EMPTY_RANGE)) continue;
            breakableRanges.add(range2);
        }
        for (Range<Integer> range : breakableRanges.asRanges()) {
            int i;
            int replaceFrom;
            Input.Tok startTok = JavaOutput.startTok(this.javaInput.getToken(range.lowerEndpoint()));
            Input.Tok endTok = JavaOutput.endTok(this.javaInput.getToken(range.upperEndpoint() - 1));
            StringBuilder replacement = new StringBuilder();
            for (replaceFrom = startTok.getPosition(); replaceFrom > 0; --replaceFrom) {
                char previous = this.javaInput.getText().charAt(replaceFrom - 1);
                if (!CharMatcher.whitespace().matches(previous)) break;
            }
            for (i = kToJ.get(startTok.getIndex()).lowerEndpoint().intValue(); i > 0 && this.getLine(i - 1).isEmpty(); --i) {
            }
            while (i < kToJ.get(endTok.getIndex()).upperEndpoint()) {
                if (i < this.getLineCount()) {
                    if (i > 0) {
                        replacement.append(this.lineSeparator);
                    }
                    replacement.append(this.getLine(i));
                }
                ++i;
            }
            int replaceTo = Math.min(endTok.getPosition() + endTok.length(), this.javaInput.getText().length());
            if (endTok.getIndex() == this.javaInput.getkN() - 1) {
                replaceTo = this.javaInput.getText().length();
            }
            int newline = -1;
            while (replaceTo < this.javaInput.getText().length()) {
                char next = this.javaInput.getText().charAt(replaceTo);
                if (!CharMatcher.whitespace().matches(next)) break;
                int newlineLength = Newlines.hasNewlineAt(this.javaInput.getText(), replaceTo);
                if (newlineLength != -1) {
                    newline = replaceTo;
                    replaceTo += newlineLength;
                    continue;
                }
                ++replaceTo;
            }
            if (newline != -1) {
                replaceTo = newline;
            }
            if (newline == -1) {
                replacement.append(this.lineSeparator);
            }
            while (i < this.getLineCount()) {
                String after = this.getLine(i);
                int idx = CharMatcher.whitespace().negate().indexIn(after);
                if (idx != -1) {
                    if (newline != -1) break;
                    replacement.append(after.substring(0, idx));
                    break;
                }
                replacement.append(this.lineSeparator);
                ++i;
            }
            result.add(Replacement.create(replaceFrom, replaceTo, replacement.toString()));
        }
        return result.build();
    }

    private Range<Integer> expandToBreakableRegions(Range<Integer> iRange) {
        int loTok = iRange.lowerEndpoint();
        int hiTok = iRange.upperEndpoint() - 1;
        if (!this.partialFormatRanges.contains(loTok) || !this.partialFormatRanges.contains(hiTok)) {
            return EMPTY_RANGE;
        }
        loTok = this.partialFormatRanges.rangeContaining(loTok).lowerEndpoint();
        hiTok = this.partialFormatRanges.rangeContaining(hiTok).upperEndpoint();
        return Range.closedOpen(loTok, hiTok + 1);
    }

    public static String applyReplacements(String input, List<Replacement> replacements) {
        replacements = new ArrayList<Replacement>(replacements);
        replacements.sort(Comparator.comparing(r -> r.getReplaceRange().lowerEndpoint()).reversed());
        StringBuilder writer = new StringBuilder(input);
        for (Replacement replacement : replacements) {
            writer.replace(replacement.getReplaceRange().lowerEndpoint(), replacement.getReplaceRange().upperEndpoint(), replacement.getReplacementString());
        }
        return writer.toString();
    }

    public static int startPosition(Input.Token token) {
        int min2 = token.getTok().getPosition();
        for (Input.Tok tok : token.getToksBefore()) {
            min2 = Math.min(min2, tok.getPosition());
        }
        return min2;
    }

    public static Input.Tok startTok(Input.Token token) {
        for (Input.Tok tok : token.getToksBefore()) {
            if (tok.getIndex() < 0) continue;
            return tok;
        }
        return token.getTok();
    }

    public static Input.Tok endTok(Input.Token token) {
        for (int i = token.getToksAfter().size() - 1; i >= 0; --i) {
            Input.Tok tok = (Input.Tok)token.getToksAfter().get(i);
            if (tok.getIndex() < 0) continue;
            return tok;
        }
        return token.getTok();
    }

    private boolean isComment(String text) {
        return text.startsWith("//") || text.startsWith("/*");
    }

    private static Range<Integer> union(Range<Integer> x, Range<Integer> y) {
        return x.isEmpty() ? y : (y.isEmpty() ? x : x.span(y).canonical(DiscreteDomain.integers()));
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("iLine", this.iLine).add("lastK", this.lastK).add("spacesPending", this.spacesPending).add("newlinesPending", this.newlinesPending).add("blankLines", this.blankLines).add("super", super.toString()).toString();
    }
}

