/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.model;

import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.gapic.model.AutoValue_Service;
import com.google.api.generator.gapic.model.Method;
import com.google.api.generator.gapic.model.Transport;
import com.google.auto.value.AutoValue;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nullable;

@AutoValue
public abstract class Service {
    public abstract String name();

    public abstract String defaultHost();

    public abstract ImmutableList<String> oauthScopes();

    public abstract String pakkage();

    public abstract String protoPakkage();

    public abstract String originalJavaPackage();

    public abstract String overriddenName();

    public abstract boolean isDeprecated();

    public abstract ImmutableList<Method> methods();

    @Nullable
    public abstract String description();

    public boolean hasDescription() {
        return !Strings.isNullOrEmpty(this.description());
    }

    public String hostServiceName() {
        return Service.parseHostServiceName(this.defaultHost());
    }

    public String apiShortName() {
        if (!Strings.isNullOrEmpty(this.defaultHost())) {
            return Service.parseApiShortName(this.defaultHost());
        }
        return "";
    }

    public String apiVersion() {
        if (!Strings.isNullOrEmpty(this.protoPakkage())) {
            return Service.parseApiVersion(this.protoPakkage());
        }
        return "";
    }

    public Method operationPollingMethod() {
        for (Method method : this.methods()) {
            if (!method.isOperationPollingMethod()) continue;
            return method;
        }
        return null;
    }

    public TypeNode operationServiceStubType() {
        for (Method method : this.methods()) {
            if (!method.hasLro() || method.lro().operationServiceStubType() == null) continue;
            return method.lro().operationServiceStubType();
        }
        return null;
    }

    public TypeNode operationType() {
        for (Method method : this.methods()) {
            if (!method.hasLro() || method.lro().operationServiceStubType() == null) continue;
            return method.outputType();
        }
        return null;
    }

    public boolean hasLroMethods() {
        for (Method method : this.methods()) {
            if (!method.hasLro()) continue;
            return true;
        }
        return false;
    }

    public boolean hasStandardLroMethods() {
        for (Method method : this.methods()) {
            if (!method.hasLro() || method.lro().operationServiceStubType() != null) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyEnabledMethodsForTransport(String transportName) {
        return this.hasAnyEnabledMethodsForTransport(Transport.parse(transportName));
    }

    public boolean hasAnyEnabledMethodsForTransport(Transport transport) {
        if (transport == Transport.GRPC_REST) {
            throw new IllegalArgumentException(String.format("Invalid Transport: %s. Expecting GRPC or REST", transport.name()));
        }
        return this.methods().stream().anyMatch(x -> x.isSupportedByTransport(transport));
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_Service.Builder().setMethods(ImmutableList.of()).setIsDeprecated(false);
    }

    private static String parseApiVersion(String protoPackage) {
        String[] pakkage = protoPackage.split("\\.");
        String apiVersion = pakkage[pakkage.length - 1].matches("v[0-9].*") ? pakkage[pakkage.length - 1] : "";
        return apiVersion;
    }

    private static String parseHostServiceName(String defaultHost) {
        if (defaultHost.contains(".googleapis.com")) {
            return Iterables.getFirst(Splitter.on(".").split(defaultHost), defaultHost);
        }
        return "";
    }

    private static String parseApiShortName(String defaultHost) {
        String apiShortName = Iterables.getFirst(Splitter.on(".").split(defaultHost), defaultHost);
        apiShortName = Iterables.getLast(Splitter.on("-").split(apiShortName), defaultHost);
        if (defaultHost.contains("iam-meta-api")) {
            apiShortName = "iam";
        }
        return apiShortName;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setName(String var1);

        public abstract Builder setOverriddenName(String var1);

        public abstract Builder setDefaultHost(String var1);

        public abstract Builder setOauthScopes(List<String> var1);

        public abstract Builder setPakkage(String var1);

        public abstract Builder setProtoPakkage(String var1);

        public abstract Builder setOriginalJavaPackage(String var1);

        public abstract Builder setIsDeprecated(boolean var1);

        public abstract Builder setMethods(List<Method> var1);

        public abstract Builder setDescription(String var1);

        public abstract Service build();
    }
}

